	title	'PROF-181X D-RAM-Disk driver'

;	Letzte Aenderung am 23.11.1986 (Joachim)
;			    16.10.1990 Aenderung auf PROF-181

	dseg

	maclib	cpm3

	maclib	psys

	maclib	hd64180

	maclib	pkonfig

	public	fdram

	extrn	@adrv,@rdrv,@dma,@trk,@sect,@dbnk,@cbnk
	extrn	adrtab,dmatrans,@dtbl
	extrn	?move,?xmove,ibtab,ciecho,?pmsg

ibno	equ	28	; hier anzahl der internen banks angeben.
			; ACHTUNG: ibno muss den gleichen wert haben
			; wie ibno in p5.asm. (ibno kann nicht als
			; globale variable definiert werden, da in
			; der folgenden equ anweisung keine globale
			; variable stehen darf

rspace	equ	(32*(ibno-drambeg))		; ramfloppy in kb

block	set	1024
dirs	set	32
	if	rspace gt 96
dirs	set	64
	endif
	if	rspace gt 256
block	set	2048
dirs	set	128
	endif
	if	rspace gt 512
dirs	set	256
	endif
	if	rspace gt 1024
dirs	set	512
	endif

	; extended disk parameter header

	dw	fwrite
	dw	fread
	dw	flogin
	dw	finit
	db	0,0
fdram	dph	0,dpbr,0,rspace/(block/1024)/4

	cseg

dpbr	dpb	128,256,rspace/32,block,dirs,0,8000h

	dseg

flogin:				; kein login notwendig
	ret

finit:				; loesche direktory der ramfloppy mit e5h
				;
	lda	ramchips	; teste ob ramfloppy ueberhaupt erlaubt
	inr	a		;
	jrz	finit1		; sprung wenn ja
				;
	lxi	h,0		; ansonsten loesche eintrag in
	shld	@dtbl+8		; drivetable
	ret			;
				;
finit1:				;
	if	eraqflg		; code nur wenn am anfang abfrage nach loeschen
	lda	serbaud0	; lese modus bits ser0
	cpi	46h		; bei autoboot
	jrz	aboot		; kein eraqtxt, no operator !
	lxi	h,eraqtxt	;
	call	?pmsg		;
	call	ciecho		;
	cpi	'Y'		; soll nicht geloscht werden ?
	rnz			; dann return.
aboot:				;
	endif			;
				;
				; dieser teil schreibt 32K e5 an den
				; anfang der ramfloppy.
	pushix			;
	lxix	ibtab		; lade bankbeschreiber fuer erste
	ldx	a,drambeg	; bank der ramfloppy
	popix			;
	rlc			; rotiere um 4 bit
	rlc			;
	rlc			;
	rlc			;
	mov	b,a		; rette in b
	ani	00fh		;
	sta	adrtab+5	; oberster 4 bit der phys. dest. adresse
	mov	a,b		;
	ani	0f0h		;
	mov	h,a		;
	mvi	l,0		;
	shld	adrtab+3	; unterste 16 bit der phys dest. adresse
	lxi	h,fillbyte	; source adresse
	shld	adrtab		;
	xra	a		; aus bank 0
	sta	adrtab+2	;
	lxi	h,1		; laenge eins
	shld	adrtab+6	;
	call	dmatrans	; im ersten byte steht e5h
				;
	lda	adrtab+5	;
	sta	adrtab+2	; vervielfaeltige e5h
	lhld	adrtab+3	;
	shld	adrtab		;
	inx	h		;
	shld	adrtab+3	;
	lxi	h,7fffh		;
	shld	adrtab+6	;
	call	dmatrans	;
				;
	ret			;

fillbyte:
	db	0e5h		;

	if	eraqflg		;
eraqtxt:
	db	0dh,0ah
	db	'erase RAM-Floppy (Y/N) ?',0
	endif

fread:
	lda	@trk		;
	adi	drambeg		;
	mov	c,a		;
	lda	@dbnk		;
	mov	b,a		;
	call	?xmove		;
	lda	@sect		;
	rrc			;
	mov	b,a		;
	ani	7fh		;
	mov	d,a		;
	mov	a,b		;
	ani	80h		;
	mov	e,a		;
	lhld	@dma		;
	lxi	b,128		;
	call	?move		;
	xra	a		;
	ret			;

fwrite:
	lda	@trk		;
	adi	drambeg		;
	mov	b,a		;
	lda	@dbnk		;
	mov	c,a		;
	call	?xmove		;
	lda	@sect		;
	rrc			;
	mov	b,a		;
	ani	7fh		;
	mov	d,a		;
	mov	a,b		;
	ani	80h		;
	mov	e,a		;
	lhld	@dma		;
	xchg			;
	lxi	b,128		;
	call	?move		;
	xra	a		;
	ret			;

	end
