
; Testprogramm fuer PCF8583
;
; letzte Aenderung am 23.05.1989 (JH)

	org	100h

	maclib	hd64180

	maclib	pdef

HIGHSDA:			; DATENLEITUNG DES PCF8583 AUF HIGH LEGEN
	MVI	A,PAD$DATA OR 1	; GEBE HIGH AUF SDA DES PCF8583
	OUT	P$LS259		;
	RET			;

LOWSDA:				; DATENLEITUNG DES PCF8583 AUF LOW LEGEN
	MVI	A, PAD$DATA	; GEBE LOW AUF SDA DES PCF8583
	OUT	P$LS259		;
	RET			;

HIGHSLC:			; CLOCKLEITUNG DES PCF8583 AUF HIGH LEGEN
	MVI	A,PAD$CE	; GEBE HIGH AUF SDA DES PCF8583
	OUT	P$LS259		;
	RET			;

LOWSLC:				; CLOCKLEITUNG DES PCF8583 AUF LOW LEGEN
	MVI	A, PAD$CE OR 1	; GEBE LOW AUF SDA DES PCF8583
	OUT	P$LS259		;
	RET			;

WAIT4US:			; VERZOEGERUNG VON CA. 4 US BEI 9,2 MHZ TAKT
	MVI	A,3		;
WAIT4L:	DCR	A		;
	JZ	WAIT4L		;
	RET			;

SLCPULS:			; SENDE EINEN TAKTIMPULS ZU PCF8583
				; LESE DABEI DIE DATENLEITUNG DES PCF8583
				; DATENPEGEL WIRD IN CARRY UEBERGEBEN.
				;
	CALL	HIGHSLC		; SETZE SCL AUF HIGH
	CALL	WAIT4US		; WARTE 4 US
	MVI	A,1		; EINS IN AKKU, DAMIT A8 = 0
	IN	P$IN$LS258	; LESE DATEN EIN
	CMA			; INVERTIEREN, DA LS258 INVERTIERT
	RLC			; UND BIT 7 INS CARRY FLAG
	CALL	LOWSLC		; SLC WIEDER LOW
	RET			; UND RETURN


	

START8583:			; Sende Startsequenz fuer Daten und Clock
				;
	CALL	HIGHSDA		; SETZE DATENLEITUNG VORSICHTSHALBER AUF HIGH
	CALL	WAIT4US		; WARTE 4 US
	CALL	LOWSDA		; SETZE DATENLEITUNG AUF LOW
	CALL	WAIT4US		; WARTE NOCHMAL 4 US
	CALL	LOWSLC		; SETZE TAKT LOW
	RET

STOP8583:			; Sende Stopsequenz fuer Daten und Clock
	CALL	LOWSDA		; SETZE DATEN AUF LOW
	CALL	WAIT4US		; WARTE 4 US
	CALL	HIGHSDA		; SETZE DATEN AUF HIGH
	CALL	WAIT4US		; WARTE NOCHMAL 4 US
	CALL	HIGHSLC		; SETZE CLOCK HIGH
	RET			;

RWPCF:				; LESE ODER SCHREIBE 8 BIT <=> ZU PCF8583
				; EINGANG = AKKU, ENTHAELT DIE DATEN FUER
				; SCHREIBEN IN PCF8583
				; AUSGANG = AKKU, ENHAELT DIE GELESENEN DATEN.
				; OB GELESEN ODER GESCHRIEBEN WIRD HAENGT
				; VOM INTERNEN ZUSTAND DES PCF8583 AB.
				; ACHTUNG BEIM LESEN MUSS AKKU GLEICH FF SEIN.
				; BEIM SCHREIBEN ENTHAELT DER AKKU DIE
				; GESENDETEN DATEN.
				;
	PUSH	B		; RETTE BC REGISTER
	MOV	C,A		; KOPIERE AKKU IN REGISTER C
	MVI	B,8		; 8 BIT ZAEHLER IN REGISTER B
RWPCFL:	MOV	A,C		; KOPIERE REGISTER C IN AKKU
	RLC			; UND SCHIEBE BIT 7 INS CARRY
	CC	HIGHSDA		; WENN CARRY HIGH, DANN DATEN HIGH
	CNC	LOWSDA		; SONST DATEN LOW
	CALL	SLCPULS		; SENDE EINEN TAKTIMPULS
	MOV	A,C		; SCHIEBE GELESENES BIT IN REGISTER C
	RAL			;
	MOV	C,A		;
	DCR	B		; SPAETERU DURCH DJNZ ERSETZEN
	JNZ	RWPCFL		; WIEDERHOLE BIS 8 BIT BEARBEITET
	MOV	A,C		; KOPIERE GELESENE DATEN IN AKKU
	POP	B		; REGISTER BC ZURUECKLADEN
	RET			; UND RETURN


PCFADR:				; SENDE WORTADRESSE ZUM PCF8583
				; ADRESSE STEHT IM AKKU
	PUSH	A		; RETTE AKKU
	CALL	START8583	; SENDE START-KONDITION
	MVI	A,0A2H		; SENDE SLAVEADRESSE FUER SCHREIBEN
	CALL	RWPCF		;
	CALL	HIGHSDA		; DATENLEITUNG AUF HIGH
	CALL	SLCPULS		; LESE ACKNOWLEGE VOM SLAVE
				; HIER MOEGL. PRUEFEN OB OK
	POP	A		; LADE WORTADRESSE VOM STACK ZURUECK
	CALL	RWPCF		; UND SENDE DIE ADRESSE ZUM PCF8583
	CALL	HIGHSDA		; DATENLEITUNG FUER
	CALL	SLCPULS		; ACKNOWLEGE AUF HIGH
				; HIER MOEGL. PRUEFEN OB OK
	RET			; UND RETURN



READPCF:			; LESE DATEN AUS PCF8583
				; EINGANGSWERTE =>
				; AKKU    = STARTADRESSE IN PCF8583
				; REG. B  = ANZAHL DER BYTES
				; REG. HL = ZIELADRESSE DER DATEN IM RECHNER
				;
	CALL	PCFADR		; SENDE DIE WORTADRESSE ZU PCF8583
	CALL	HIGHSLC		; CLOCK HIGH FUER ERNEUTE START-KONDITION
				;
	CALL	START8583	; SENDE START-KONDITION
	MVI	A,0A3H		; SENDE SLAVEADRESSE FUER LESEN
	CALL	RWPCF		;
	CALL	HIGHSDA		; DATENLEITUNG AUF HIGH
	CALL	SLCPULS		; LESE ACKNOWLEGE VOM SLAVE
				; HIER MOEGL. PRUEFUNG OB OK
READ102:			; REG. B ENTHAELT ANZAHL DER BYTES
				; REG. HL ZEIGT AUF MEMORY-ADRESSE
	MVI	A,0FFH		; AKKU AUF FF FUER DATEN LESEN
	CALL	RWPCF		; LESE EIN BYTE
	MOV	M,A		; KOPIERE IN SPEICHER
	INX	H		; ERHOEHE ZEIGER AUF SPEICHERADRESSE
	DCR	B		; ERNIEDRIGE BYTEZAEHLER
	JNZ	READ103		; SPRUNG WENN WEITER
	CALL	HIGHSDA		; ENDE DER UEBERTRAGUNG, DESHALB
	CALL	SLCPULS		; ACKNOWLEGE MIT DATEN=HIGH
	JMP	RENDE		; 
READ103	CALL	LOWSDA		; SENDE ACKNOWLEGE
	CALL	SLCPULS		;
	JMP	READ102		; UND WEITER

RENDE	CALL	STOP8583	; STOP BEDINGUNG SENDEN
	RET


WRITEPCF:			; SCHREIBE DATEN IN PCF8583
				; EINGANGSWERTE =>
				; AKKU    = STARTADRESSE IN PCF8583
				; REG. B  = ANZAHL DER BYTES
				; REG. HL = QUELLADRESSE DER DATEN IM RECHNER
				;
	CALL	PCFADR		; SENDE DIE WORTADRESSE ZU PCF8583
WRITE01	MOV	A,M		; LADE BYTE VON QUELLADRESSE
	CALL	RWPCF		; SENDE DATEN-BYTE ZU PCF8583
	CALL	HIGHSDA		; LESE ACKNOWLEGE VOM SLAVE
	CALL	SLCPULS		;
				; HIER MOEGL. PRUEFUNG OB OK
	INX	HL		; ERHOEHE ZEIGER AUF QUELLADRESSE
	DCR	B		; WIEDERHOLE BIS ALLE DATEN
	JNZ	WRITE01		; GESENDET SIND
				;
	CALL	STOP8583	; STOP BEDINGUNG SENDEN
	RET

; DIE NAECHSTEN 4 ROUTINEN SIMULIEREN DEN ALTEN UHRENCHIP MK3538
; DIE ROUTINEN HABEN DIE GLEICHE FUNKTION WIE IN DEN VORANGEGANGENEN
; MONITOR-VERSIONEN
;
; HINWEIS: IM GEGENSATZ ZUM MK3538 BESITZT PCF8583 NUR ZWEI BIT
; FUER DIE JAHRES-ZAHL. WIR HABEN DESHALB EINEN WEITEREN (BCD-)
; JAHRESZAEHLER WIE FOLGT REALISIERT: DAS ALARMREGISTER WIRD AUF
; EINEN DATED-ALARM FUER DEN 1. JANUAR 00:00:00 GESETZT.
; DIE BCD-JAHRESZAHL WIRD IM NICHT BENUTZTEN TIMER-REGISTER GESPEICHERT.
; WIRD NUN BEIM LESEN DER UHR FESTGESTELLT, DASS EIN ALARM AUFGETRETEN
; IST, DANN WIRD DIE JAHRES-ZAHL UM EINS ERHOEHT UND DIE UHR MIT
; DER NEUEN JAHRESZAHL NEU GESETZT.

READ$TIME:			; LESE UHRZEIT IM FORMAT DES MK3835
				;
	PUSH	PSW		; RETTE ALLE REGISTER
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
				;
	MVI	A,0		; LESE UHRDATEN
	MVI	B,16		; 16 BYTE
	LXI	H,PCFBUF	; IN ZWISCHENSPEICHER
	CALL	READPCF		;
				; KOPIERE DATEN AUS PCF8583 IN TIME$FIELD
				; (MK3835 KOMPATIBEL)
	LXI	HL,PCFSEC	;
	LXI	DE,TIME$FIELD	;
	LXI	B,5		;
	LDIR			;
	LDA	ALRTIM		;
	STA	TIME$FIELD+6	;
				;
				; JETZT ERFOLGT DIE ERHOEHEUNG DER JAHRES ZAHL
				; FALLS ALRMFLAG GESETZT IST. ACHTUNG: DIE UHR 
				; DARF NICHT UM 00:00:00 DES 1. JANUAR AUSGELESEN
				; WERDEN, DA SONST DIE JAHRESZAHL UM ZWEI ERHOEHT
				; WIRD. (SOFTWARE WIRD DADURCH EINFACHER).
				;
	LDA	PCFCON		; PRUEFE OB NEUES JAHR
	ANI	00000010B	;
	JZ	OLDYEAR		; WENN BIT 2 = 1 NEUES JAHR SONST ALLES OK
	LDA	TIME$FIELD+6	; ERHOEHE JAHR UM EINS
	INR	A		;
	DAA			; DEZIMAL KORREKTUR
	STA	TIME$FIELD+6	;
	CALL	WRITE$TIME	; SCHREIBE NEUES JAHR IN PCF8583
OLDYEAR:			;
	POP	H		;
	POP	D		;
	POP	B		;
	POP	PSW		;
	RET			;


WRITE$TIME:			;
	PUSH	PSW		;
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
				;
	LXI	H,PCFDAT	; KOPIERE ERST EINMAL ALLE UNVERAENDERLICHEN
	LXI	D,PCFBUF	; DATEN IN DEN BUFFER
	LXI	B,15		;
	LDIR			;
				;
	LXI	H,TIME$FIELD	; UBERSCHREIBE JETZT DEN BUFFER 
	LXI	D,PCFSEC	; ZEIT UND DATUM
	LXI	B,5		;
	LDIR			;
				;
	LDA	PCFDAY		; DATE WIRD IN REGISTER C FUER DIE NACHFOLGENDE
	ANI	00111111B	; SCHALTJAHR ERZEUGUNG ZWISCHENGESPEICHERT
	MOV	C,A		;
				;
	LDA	TIME$FIELD+6	; LEGE BCD-JAHRESZAHL IM ALS RAM MISSBRAUCHTEN
	STA	ALRTIM		; ALARM TIMER REGISTER AB.
	
	RRC			; ERZEUGE AUS DER BCD JAHRESZAHL 2 BIT
	RRC			; FUER SCHALTJAHRZAEHLER IN PCF8583
	MOV	B,A		;
	RRC			;
	RRC			;
	RRC			;
	ANI	10000000B	;
	ADD	B		;
	ANI	11000000B	; ZWEI BIT FUER SCHALTJAHR ERZEUGT
	ORA	C		; PACKE DATE DAZU
	STA	PCFDAY		; UND ZURUECK IN BUFFER
	
				;
	MVI	A,0		; SCHREIBE DIE DATEN IN PCF8583
	MVI	B,16		;
	LXI	H,PCFBUF	;
	CALL	WRITEPCF	;
				;
	POP	H		;
	POP	D		;
	POP	B		;
	POP	PSW		;
	RET			;

PCFDAT	DB	0CH,00H,00H,00H,00H,00H,00H,00H
	DB	30H,00H,00H,00H,00H,01H,01H

PCFBUF:				; BUFFER FUER UHR-DATEN AUS PCF8583
PCFCON	DS	1		; CONTROL /STATUS
PCFHUN	DS	1		; HUNDERSTELSEKUNDEN
PCFSEC	DS	1		; SEKUNDEN
PCFMIN	DS	1		; MINUTEN
PCFHRS	DS	1		; STUNDEN
PCFDAY	DS	1		; TAG
PCFMON	DS	1		; MONAT
PCFTIM	DS	1		; TIMER
ALRCON	DS	1		; ALARM CONTROL 
ALRHUN	DS	1		; ALARM HUNDERSTELSEKUNDEN
ALRSEC	DS	1		; ALARM SEKUNDEN
ALRMIN	DS	1		; ALARM MINUTEN
ALRHRS	DS	1		; ALARM STUNDEN
ALRDAY	DS	1		; ALARM TAG
ALRMON	DS	1		; ALARM MONAT
ALRTIM	DS	1		; ALARM TIMER


TIME$FIELD	EQU	2000H	; NUR FUER TEST

	end
