;******************************************************************
;***								***
;***	DISKETTENFORMATE FUER PROF-181X				***
;***								***
;***	LETZTE AENDERUNNG AM: 04.10.1986 (JOACHIM)		***
;***								***
;******************************************************************
;
	TITLE	'PROF-181X Disk Parameter'
;
	PUBLIC	DTYPEB
;
	MACLIB	CPM3
;
	MACLIB	PKONFIG
;
	DSEG
;
;
; 
DTYPEB:
	;
	;DIESE LISTE DEFINIERT DIE VOM BETRIEBSSYSTEM LESBAREN
	;PLATTEN-TYPEN.
	;DIE LISTE BESTEHT AUS BELIEBIG VIELEN EINTRAEGEN,
	;DIE WIE NACHFOLGEND BESCHRIEBEN AUFGEBAUT
	;SIND:
	;	BYTE 1		:DISK-TYP WIE VON MONTEST ERMITTELT
	;	BYTE 2		:ERSTER SEKTOR AUF SPUR
	;	BYTE 3		:LETZTER SEKTOR AUF SPUR
	;	BYTE 4		:WRITE PRECOMPENSATION UND LW GUELTIGKEIT
	;	BYTE 5		:BYTE FUER LOGISCHE DISK VERWALTUNG
	;	BYTE 6		:GAP-LAENGE FUER UPD765 BEI READ/WRITE
	;	BYTE 7		:ANZAHL DER ZYLINDER
	;	BYTE 8		:AB DIESER SPUR ERFOLGT PRECOMPENSATION
	;	BYTE 9-25	:ZUGEHOEHRIGER DISK PARAMETER BLOCK
	;	BYTE 26-27	:ZEIGER AUF SEKTOR UEBERSETZUNGSTABELLE
	;	BYTE 28-29	:ZEIGER AUF TRACK UEBERSETUNGSTABELLE
	;	BYTE 30-45	:NAME DES FORMATS
	;	BYTE 46		:GAPLAENGE BEIM FORMATIEREN
	;	BYTE 47		:PHYSIKALISCHER SKEWFAKTOR BEIM FORMATIEREN
	;	BYTE 48		:RESERVIERT
	;
	;TEST$FORMAT VERGLEICHT DIE DREI ERSTEN BYTES MIT
	;TEST$TYPE TEST$LSEK UND TEST$MSEK DIE DAS UNTERPROGRAM MONTEST
	;LIEFERT. AUSSERDEM WIRD UEBERPRUEFT, OB DAS FORMAT AUF DEM
	;GETESTETEN LAUFWERK GUELTIG IST.
	;
	SSIDE	EQU	000H	;EQUATES FUER TYPE
	DSIDE	EQU	080H	;
	SDENS	EQU	000H	;
	DDENS	EQU	040H	;
	MAXIF	EQU	000H	;
	MINIF	EQU	020H	;
	VHB0	EQU	000H	;
	VHB1	EQU	010H	;
	S0128	EQU	000H	;
	S0256	EQU	001H	;
	S0512	EQU	002H	;
	S1024	EQU	003H	;
	;
	RHB0	EQU	000H	;EQUATES FUER LOGISCHE DISK VERWALTUNG
	RHB1	EQU	010H	;
	TUV1	EQU	000H	;
	TUV2	EQU	001H	;
	TUV3	EQU	002H	;
	TUV4	EQU	003H	;
	TUV5	EQU	004H	;
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 5 PROF-80 (8" STANDARD CP/M)	***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR SDENS OR MAXIF OR VHB0 OR S0128
	DB	1,26
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	07
	DB	77
	DB	0FFH
	DPB	128,26,77,1024,64,2
	DW	SKEW26
	DW	0
	DB	'Standard 8"     '
	DB	01BH
	DB	1
	DB	0
	;
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 6 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MAXIF OR VHB0 OR S1024
	DB	1,8
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	35H
	DB	77
	DB	0FFH
	DPB	1024,8,77,2048,128,2
	DW	SKEW8
	DW	0
	DB	'Conitec PROF 6  '
	DB	074H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 7 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MAXIF OR VHB0 OR S0256
	DB	1,26
	DB	000H					; * INAKTIV
	DB	RHB1 OR TUV1
	DB	7
	DB	77
	DB	0FFH
	DPB	256,52,77,4096,128,2
	DW	SKEW26
	DW	0
	DB	'PROF 7          '
	DB	036H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT ELAB 8" DS/DD			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MAXIF OR VHB0 OR S0256
	DB	1,26
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	7
	DB	77
	DB	0FFH
	DPB	256,52,77,4096,256,2
	DW	SKEW$ELAB$DS
	DW	0
	DB	'Elab 8" DS/DD   '
	DB	01BH
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 8 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MAXIF OR VHB0 OR S0512
	DB	1,15
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	18H
	DB	77
	DB	0FFH
	DPB	512,30,77,2048,256,2
	DW	SKEW15
	DW	0
	DB	'Conitec PROF 8  '
	DB	054H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT PROF high density		***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MAXIF OR VHB0 OR S1024
	DB	1,9
	DB	0F0H
	DB	RHB1 OR TUV2
	DB	18H
	DB	80
	DB	0FFH
	DPB	1024,9,160,2048,512,4
	DW	SKEW9
	DW	0
	DB	'PROF high dens  '
	DB	030H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 9 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MAXIF OR VHB0 OR S1024
	DB	1,8
	DB	0F0H
	DB	RHB1 OR TUV2
	DB	35H
	DB	77
	DB	0FFH
	DPB	1024,8,144,8192,256,4
	DW	SKEW8
	DW	0
	DB	'Conitec PROF 9  '
	DB	074H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 10 PROF-80 (ECMA 70)		***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S0256
	DB	1,16
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	1BH
	DB	40
	DB	0FFH
	DPB	256,16,40,1024,64,4
	DW	NOSKEW1
	DW	0
	DB	'ecma 70         '
	DB	032H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 1 PROF-80 (OSBORNE 1 DD)		***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S1024
	DB	1,5
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	1BH
	DB	40
	DB	0FFH
	DPB	1024,5,40,1024,64,3
	DW	SKEW5
	DW	0
	DB	'Osborne DD      '
	DB	030H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 3 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S1024
	DB	1,5
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	1BH
	DB	80
	DB	0FFH
	DPB	1024,5,80,2048,128,3
	DW	SKEW5
	DW	0
	DB	'Conitec PROF 3  '
	DB	030H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT MC FLO 2				***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S1024
	DB	1,5
	DB	000H					; * INAKTIV
	DB	RHB1 OR TUV2
	DB	1BH
	DB	80
	DB	0FFH
	DPB	1024,5,160,2048,256,4
	DW	NOSKEW1
	DW	0
	DB	'mc FLO 2        '
	DB	030H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT MC CP/M PLUS 3			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S1024
	DB	1,5
	DB	000H					; * INAKTIV
	DB	RHB1 OR TUV2
	DB	1BH
	DB	80
	DB	0FFH
	DPB	1024,5,160,4096,128,4
	DW	NOSKEW1
	DW	0
	DB	'mc CP/M plus 3  '
	DB	030H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 2 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S0512
	DB	1,10
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	0EH
	DB	40
	DB	0FFH
	DPB	512,20,40,2048,128,3
	DW	SKEW10
	DW	0
	DB	'Conitec PROF 2  '
	DB	01BH
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT IBM-PC DS/DD			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S0512
	DB	1,8
	DB	0F0H
	DB	RHB1 OR TUV4
	DB	0EH
	DB	40
	DB	0FFH
	DPB	512,8,80,2048,64,1
	DW	NOSKEW1
	DW	0
	DB	'IBM-PC DS/DD    '
	DB	030H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 4 PROF-80			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S0512
	DB	1,10
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	0EH
	DB	80
	DB	0FFH
	DPB	512,20,80,2048,128,3
	DW	SKEW10
	DW	0
	DB	'Conitec PROF 4  '
	DB	01BH
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT 11				***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S1024
	DB	0,4
	DB	0F0H
	DB	RHB1 OR TUV2
	DB	1BH
	DB	80
	DB	0FFH
	DPB	1024,5,160,2048,256,4
	DW	SKEW05
	DW	0
	DB	'Conitec PROF 11 '
	DB	030H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT BONDWELL 14			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S0256
	DB	0,17
	DB	0F0H
	DB	RHB1 OR TUV3
	DB	0EH
	DB	40
	DB	0FFH
	DPB	256,18,80,2048,128,2
	DW	NOSKEW0
	DW	0
	DB	'Bondwell 14     '
	DB	01BH
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT KONTRON MINI 77 TRACK DS		***
	;	***	NOCH NICHT AUF RUECKSEITE GETESTET	***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S0256
	DB	1,16
	DB	000H					; * INAKTIV
	DB	RHB1 OR TUV3
	DB	0EH
	DB	77
	DB	0FFH
	DPB	256,16,154,2048,256,4
	DW	SKEW3$16
	DW	0
	DB	'Kontron 77 track'
	DB	020H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT PHILIPS P2000-C			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S0256
	DB	1,16
	DB	000H					; * INAKTIV
	DB	RHB1 OR TUV2
	DB	0EH
	DB	80
	DB	0FFH
	DPB	256,16,160,4096,128,2
	DW	SKEW2$16
	DW	0
	DB	'Philips P2000-C '
	DB	020H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT ITT 3030				***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S0256
	DB	1,16
	DB	0F0H
	DB	RHB1 OR TUV3
	DB	0EH
	DB	70
	DB	0FFH
	DPB	256,16,140,2048,128,4
	DW	NOSKEW1
	DW	0
	DB	'ITT 3030        '
	DB	020H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT Vortex/Schneider			***
	;	***						***
	;	***************************************************
	;
	DB	DSIDE OR DDENS OR MINIF OR VHB0 OR S0512
	DB	1,9
	DB	0F0H
	DB	RHB1 OR TUV2
	DB	0EH
	DB	80
	DB	0FFH
	DPB	512,9,160,4096,128,2
	DW	NOSKEW1
	DW	0
	DB	'Vortex/Schneider'
	DB	020H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT MSDOS 360k			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S0512
	DB	1,9
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	01BH
	DB	40
	DB	0FFH
	DPB	512,18,40,2048,128,0
	DW	SKEW1$9
	DW	0
	DB	'MSDOS 360k      '
	DB	050H
	DB	1
	DB	0
	;
	;	***************************************************
	;	***						***
	;	***	FORMAT KayPro II			***
	;	***						***
	;	***************************************************
	;
	DB	SSIDE OR DDENS OR MINIF OR VHB0 OR S0512
	DB	0,9
	DB	0F0H
	DB	RHB1 OR TUV1
	DB	01BH
	DB	40
	DB	0FFH
	DPB	512,10,40,1024,64,1
	DW	SKEW1$10
	DW	0
	DB	'KayPro II       '
	DB	030H
	DB	1
	DB	0
	;
	;
	DB	008H

skew26:		skew	26,6,1
		skew1	26,6,1

skew15:		skew	15,4,1
		skew1	15,4,1

skew5:		skew	5,1,1
		skew1	5,1,1

skew10:		skew	10,2,1
		skew1	10,2,1

skew1$9:	skew	9,1,1
		skew1	9,1,1

skew05:		skew	5,2,0
skew8:		skew	8,3,1
skew9:		skew	9,2,1
noskew1:	skew	48,1,1
noskew0:	skew	18,1,0
skew2$16:	skew	16,2,1
skew3$16:	skew	16,3,1
skew1$10:	skew	10,1,0

skew$elab$ds:
	db	1,4,7,10,13,16,19,22,25
	db	130,133,136,139,142,145,148,151,154
	db	3,6,9,12,15,18,21,24
	db	129,132,135,138,141,144,147,150,153
	db	2,5,8,11,14,17,20,23,26
	db	131,134,137,140,143,146,149,152


 	ds	dtypeb-$+dtblg	; halte speicherbereich
				; entsprechend der maximal
				; laenge der patch aerra frei.
				;
				; Kennung, um Formatparameter
				; in CPM3.SYS zu finden und
				; gegebenenfalls zu patchen
	db	'CoNi'		;
	dw	dtypeb,dtblg	;
				;

	END
