;******************************************************************
;***                                                            ***
;***  PROF-80 Monitor Version: 1.7                              ***
;***                                                            ***
;***  letzte Aenderung am: 29.02.1988      (c) Joachim Hanst    ***
;***                                                            ***
;***  Uebersetzt                                                ***
;***  in Z80-Mnemonics am: 17.07.2007          Wolfram Kurtz    ***
;***                                                            ***
;******************************************************************

          ; TITLE 'PROF-80 MONITOR VERSION 1.7'

          INCLUDE   ADEF.LIB            ; BENUTZE ZDEF.LIB FUER ALLE C-SYSTEM MODULE
                                        ; ANGEPASST FUER Z80ASM/ASIDE

          DEFSEGMENT "CSEG",0,1FFFH,"AMON17ROM"
          DEFSEGMENT "DSEG",0,0FFFFH,"AMON17RAM"


BELL:      EQU       07H
CNGPRMT:   EQU       '-'


          SEGMENT "CSEG"
          ORG       EPROM
MONITOR:
                                        ; SPRUNGVEKTOR FUER MONITOR SERVICE-ROUTINEN

          JP        INIT                ; MONITOR-EINGANG NACH RESET
          JP        START               ; MONITOR WARM-START
CS:       JP        UMLEIT_CONST        ; CONSOLEN STATUS,EIN-UND AUSGABE
CI:       JP        UMLEIT_CONIN        ; GEHEN ERST UEBER SPRUNG IM RAM
CO:       JP        UMLEIT_CONOUT       ; AUF IHRE VERTEILER
          JP        SETSEC_CNT          ; SETZE ANZAHL DER SEKTOREN
          JP        BOOTERR             ; DRUCKE FEHLERMELDUNG
          JP        SETCMDT             ; SETZE CMDTAB ENTSPRECHEND TEST
          JP        RECAL               ; SETZE AUSGEWAEHLETES DRIVE AUF TRACK 0
          JP        SELDSK              ; WAEHLE DRIVE AUS
          JP        SETTRK              ; SETZE SPUR FUER AUSGEWAEHLTES DRIVE
          JP        SETSEC              ; SETZE SEKTOR FUER AUSGEWAEHLTES DRIVE
          JP        SETDMA              ; SETZE DMA ADRESSE FUER READ/WRITE
          JP        READ                ; LESE DISK
          JP        WRITE               ; SCHREIBE DISK
          JP        START               ; IN ALTEN VERSIONEN WAR HIER GETMINIMAX
          JP        START

          JP        CONST               ; CONSOLEN STATUS-VERTEILER
SERNR:    DEFW      28028               ; SERIEN NUMMER
RSTART7:  JP        RST_VERTEILER       ; RST 7 EINSPRUNG (MUSS 38H SEIN)
          JP        CONIN               ; CONSOLEN EINGABE-VERTEILER
          JP        CONOUT              ; CONSOLEN AUSGABE-VERTEILER
          JP        TEST                ; TESTE DISK-FORMAT
          JP        MOTO                ; WARTE AUF READY UND GEBE DISK-BEFEHL
          JP        CMFD                ; SENDE DISK-BEFEHL OHNE READY
          JP        RESULT              ; ERGEBNISPHASE DES UPD 765
          JP        SEEK                ; POSITIONIERE AUF SPUR
          JP        NEXT                ; LESE EIN RESULT-BYTE AUS UPD 765
          JP        MULTIP              ; MULTIPLIKATION
          JP        START               ; DIVISION WURDE ENTFERNT
          JP        INT_SERVICE         ; EINLESEN EINES ZEICHENS NACH INT.
          JP        GRAFIN              ; VIDEO KARTE EINGABE
          JP        GRAFOUT             ; VIDEO KARTE AUSGABE
          JP        GRAFIST             ; VIDEO KARTE EIN STATUS
VERSIONNR:
          DEFB      17H                 ; VERSIONS NUMMER
          JP        UMLEIT_NMI          ; SPRUNG AUF NMI ROUTINE
          JP        GRAFOST             ; VIDEO KARTE AUS STATUS
          JP        SOFTIN              ; SOFT SCHNITTSTELLE EINGABE
          JP        SOFTOUT             ; SOFT SCHNITTSTELLE AUSGABE
          JP        SOFTIST             ; SOFT SCHNITTSTELLE EIN STATUS
          JP        SOFTOST             ; SOFT SCHNITTSTELLE AUS STATUS
USER1IN:  JP        SAIN                ; UNIO-SIO-A EINGABE
USER1OUT:
          JP        SAOUT               ; UNIO-SIO-A AUSGABE
USER1IST:
          JP        SAIST               ; UNIO-SIO-A EIN STATUS
USER1OST:
          JP        SAOST               ; UNIO-SIO-A AUS STATUS
USER2IN:  JP        SBIN                ; UNIO-SIO-B EINGABE
USER2OUT:
          JP        SBOUT               ; UNIO-SIO-B AUSGABE
USER2IST:
          JP        SBIST               ; UNIO-SIO-B EIN STATUS
USER2OST:
          JP        SBOST               ; UNIO-SIO-B AUS STATUS
USERINIT:
          RET                           ; BENUTZER INITIALISIERUNG
          NOP
          NOP
          JP        DISKERR             ; FLOPPY-FEHLERMELDUNG
          JP        SOFTPRNTOUT         ; SIMPLEX SCHNITTSTELLE
          JP        SOFTPRNTOST         ; SIMPLEX BEREIT
          JP        SET_PHYS_TIME       ; SETZE ZEIT
          JP        READ_PHYS_TIME      ; LESE ZEIT
          JP        SET_SHIFT           ; SETZE SHIFT-REGISTER
          JP        SET_DUPLEX_BAUD     ; SETZE BAUDRATE DUPLEX
          JP        SET_SIMPLEX_BAUD    ; SETZE BAUDRATE SIMPLEX
          JP        SPECD               ; SETZE DISKPARAMETER

                                        ; DIE NACHFOLGENDEN DATEN WERDEN
                                        ; NACH EINEM RESET IN DIE
                                        ; SYSTEMPAGE UEBERNOMMEN.
                                        ; DIE DATEN BEFINDEN SICH AB VERS 1.4
                                        ; IMMER AN DEN GLEICHEN EPROM
                                        ; ADRESSEN, SO DASS SIE VOM
                                        ; BENUTZER LEICHT GEPATCHT WERDEN
                                        ; KOENNEN.

XSPECD_WORD:
          DEFW      HLOS*256+256+SRTS*16+HUTS ; STEPRATE, HLT, HUT
                                        ; DIESE DATEN GEBEN DIE DEFAULT
                                        ; EINSTELLUNG AN, SIE WERDEN DURCH
                                        ; DEN U-BEFEHL UEBERDECKT
XSEEKNR:  DEFB      000H                ; DOUBLESTEPVEKTOR
XREADY_BYTE:
          DEFB      0FFH                ; READYBYTE KANN VORDEFINIERT WERDEN.
XTE_TIME:
          DEFB      010H                ; WARTEZEIT NACH WRITE-DISK (IN 100 US)
XPRNT_BAUD:
          DEFB      003H                ; BAUDRATE SIMPLEX
STIBAUD:  DEFB      003H                ; BAUDRATE UNIO-STI
XSTEP_WAIT:
          DEFB      000H                ; WARTEZEIT VOR STEP WENN MOTOR AUS WAR

                                        ; SPRUNGVEKTOR FORTSETZUNG
CENT1OUT: JP        C1OUT
CENT1OST: JP        C1OST
CENT2OUT: JP        C2OUT
CENT2OST: JP        C2OST
STIIN:    JP        STIN
STIOUT:   JP        STOUT
STIIST:   JP        STIST
STIOST:   JP        STOST
STIINIT:  JP        STINIT
SIOAINIT: JP        SAINIT
SIOBINIT: JP        SBINIT



RST_VERTEILER:
                                        ; PRUEFT OB INTERRUPT-BETRIEB DER SOFT-SCHNITTSTELLE
                                        ; WENN NEIN, DANN SPRUNG ZUM MONITOR, SONST EINLESEN
                                        ; DES SERIELLEN ZEICHENS

          PUSH      AF                  ; RETTE AKKU
          LD        A,(IO_JUMPERBYTE)   ; IST INT.-BETRIEB
          DEC       A
          JR        NZ,RST_V1           ; SPRUNG WENN KEIN INT.-BETRIEB
          POP       AF
          JP        INT_SERVICE         ; SPRUNG ZUR INTERUPTROUTINE
RST_V1:   POP       AF                  ; SPRUNG ZUM MONITOR
          JP        START



START:
;----------------------------------------------ANFANG REGISTER RETTEN-----
          LD        (LSAVE),HL
          POP       HL
          LD        (PSAVE),HL
          LD        (SSAVE),SP          ; RETTE STACKPOINTER
          LD        SP,LSAVE            ; JETZT RETTEN DURCH PUSHBEFEHLE MOEGLICH
          PUSH      AF
          PUSH      BC
          PUSH      DE
          PUSH      IX                  ; ZUSAETZLICH Z80 REGISTER
          PUSH      IY
          EX        AF,AF'
          EXX                           ; SCHALTE REGISTER  UM
          PUSH      AF
          PUSH      BC
          PUSH      DE
          PUSH      HL
          EXX                           ; REGISTER ZURUECK SCHALTEN
          EX        AF,AF'
          LD        A,I                 ; SAVE I UND R REGISTER
          LD        B,A
          LD        A,R
          LD        C,A
          PUSH      BC
;--------------------------------------------------ENDE REGISTER RETTEN----


          LD        HL,SGNON            ; GEBE MONITOR-MELDUNG AUS
          CALL      SOUT

GETCM:
          LD        HL,MSTAK
          LD        SP,HL
          LD        C,':'
          CALL      CECHO
GTC03:
          CALL      GETCH1
          CALL      CECHO
          LD        D,C                 ; SAVE COMMAND
          LD        HL,CMDMSG           ; ZEIGE AUF TEXT
GTC01:    LD        A,D
          CP        (HL)                ; GLEICH
          JR        Z,GTC04
GTC02:    INC       HL
          LD        A,(HL)              ; GLEICH 00H
          CP        0
          JP        Z,CERROR             ; DANN FEHLER
          CP        '$'
          JR        NZ,GTC02            ; SUCHE
          INC       HL                  ; VERGLEICHE NAECHSTES KOMMANDO
          JR        GTC01
GTC04:    INC       HL                  ; GEFUNDEN GEBE AUS
          CALL      SOUT
          LD        A,D
          LD        C,D
          LD        BC,NCMDS            ; C ENTHAELT SCHL.U.INDEXZAEHLER
          LD        HL,CTAB
GTC05:
          CP        (HL)
          JP        Z,GTC10
          INC       HL
          DEC       C
          JP        NZ,GTC05
          JP        CERROR
GTC10:
          LD        HL,CADR
          ADD       HL,BC
          ADD       HL,BC
          LD        A,(HL)
          INC       HL
          LD        H,(HL)
          LD        L,A
          JP        (HL)

CRGETCM:
          CALL      CROUT
          JR        GETCM



DCMD:
          CALL      GETHX               ; LESE STARTADRESSE
          LD        H,B
          LD        L,C
          LD        A,D
          JR        C,DCM30
          CP        0DH
          LD        HL,(DISPADR)
          JR        NZ,DCM33            ; SPRUNG WENN NOCH ENDADRESSE KOMMT
DCM31:    LD        DE,00FFH            ; KEINE ENDADRESSE, 100H WEITER
          PUSH      HL                  ; SAVE ANFAANG
          ADD       HL,DE
          EX        DE,HL
          POP       HL
          JR        DCM05               ; AUSGABE KANN BEGINNEN
DCM30:    CP        0DH
          JR        Z,DCM31             ; KEINE ENDADRESSE
DCM33:    CALL      GETHX               ; LESE ZWEITE ADRESSE
          LD        A,D
          CP        0DH
          JP        NZ,CERROR
          LD        D,B
          LD        E,C
          CALL      HILO
          JR        NC,DCM05            ; HL>DE
          LD        D,H
          LD        E,L
DCM05:
          CALL      CROUT
          CALL      HLOUT
          LD        B,000H              ; ZAEHLER FUER ASCII AUSGABE
DCM10:
          INC       B                   ; EIN ZEICHEN WEITER
          LD        C,' '
          CALL      CECHO
          LD        A,(HL)
          CALL      NMOUT
          CALL      BREAK
          JP        C,DCM12
          CALL      HILO
          JP        NC,DCM15
DCM12:
          INC       HL
          CALL      DCM20
          CALL      CROUT
          LD        (DISPADR),HL
          JP        GETCM
DCM15:
          INC       HL
          LD        A,L
          AND       0FH
          JP        NZ,DCM10
          CALL      DCM20
          JR        DCM05

DCM20:    PUSH      DE                  ; SAVE D
          PUSH      HL                  ; SAVE H
          LD        C,' '
          CALL      CO
          LD        C,'>'
          CALL      CO
          LD        C,B
DCM23:    DEC       HL
          DJNZ      DCM23
          LD        B,C
DCM21:    LD        A,(HL)
          CP        20H
          JR        C,DCM22
          CP        07FH
          JR        NC,DCM22
          JR        DCM24
DCM22:    LD        A,'.'               ; DEFAULT FOR NON ASCII
DCM24:    LD        C,A
          CALL      CO
          INC       HL
          DJNZ      DCM21
          POP       HL
          POP       DE
          RET



GCMD:
          CALL      GETHX
          JP        NC,GCM05
          LD        A,D
          CP        0DH
          JP        NZ,CERROR
          LD        HL,PSAVE
          LD        (HL),C
          INC       HL
          LD        (HL),B
          JP        GCM10
GCM05:
          LD        A,D
          CP        0DH
          JP        NZ,CERROR
GCM10:
          JP        RSTTF



MCMD:
          LD        C,3
          CALL      GETNM
          POP       BC
          POP       HL
          POP       DE
MCM05:
          PUSH      HL
          LD        H,D
          LD        L,E
          LD        A,(HL)
          LD        H,B
          LD        L,C
          LD        (HL),A
          INC       BC
          LD        A,B
          OR        C
          JP        Z,GETCM
          INC       DE
          POP       HL
          CALL      HILO
          JP        NC,GETCM
          JP        MCM05



SCMD:
          CALL      GETHX
          PUSH      BC
          POP       HL
SCM05:
          LD        A,D
          CP        ' '
          JP        Z,SCM10
          CP        ','
          JP        NZ,GETCM
SCM10:
          LD        A,(HL)
          CALL      NMOUT
          LD        C,CNGPRMT
          CALL      CECHO
          CALL      GETHX
          JP        NC,SCM15
          LD        (HL),C
SCM15:
          INC       HL
          JP        SCM05



XCMD:
          CALL      GETCH
          LD        C,A
          CALL      CECHO
          LD        A,C
          CP        0DH
          JP        NZ,XCM05
          CALL      REGDS
          JP        GETCM
XCM05:
          LD        C,A
          CALL      RGADR
          PUSH      BC
          POP       HL
          LD        C,' '
          CALL      CECHO
          LD        A,C
          LD        (TEMP),A
XCM10:
          LD        A,(TEMP)
          CP        ' '
          JP        Z,XCM15
          CP        ','
          JP        NZ,GETCM
XCM15:
          LD        A,(HL)
          OR        A
          JP        NZ,XCM18
          JP        CRGETCM
XCM18:
          PUSH      HL
          LD        E,(HL)
          LD        D,(REGS AND 0FF00H) SHR 8     ; SAVE ADRESSE
          INC       HL
          LD        B,(HL)
          PUSH      DE
          PUSH      DE
          POP       HL
          PUSH      BC
          LD        A,(HL)
          CALL      NMOUT
          POP       AF
          PUSH      AF
          OR        A
          JP        Z,XCM20
          DEC       HL
          LD        A,(HL)
          CALL      NMOUT
XCM20:
          LD        C,CNGPRMT
          CALL      CECHO
          CALL      GETHX
          JP        NC,XCM30
          LD        A,D
          LD        (TEMP),A
          POP       AF
          POP       HL
          OR        A
          JP        Z,XCM25
          LD        (HL),B
          DEC       HL
XCM25:
          LD        (HL),C
XCM27:
          LD        DE,3
          POP       HL
          ADD       HL,DE
          JP        XCM10
XCM30:
          LD        A,D
          LD        (TEMP),A
          POP       DE
          POP       DE
          JP        XCM27



CCMD:
                                        ; TESTET PLATTE IM ANGEGEBENEN LAUFWERK
                                        ; UND GIBT ERGEBNISSE AUF DEM BILDSCHIRM AUS

          CALL      DISKDA              ; BEFEHL ERLAUBT?
          CALL      SPECD               ; SETZE DISK-TIMING
          CALL      GETCH1              ; WELCHES LAUFWERK?
          CALL      CECHO                ; GEBE ZEICHEN AUF CONSOLE
          LD        A,C                 ; ZEICHEN IN AKKU
          SUB       'A'                 ; WANDLE LW. CHR. IN NUMMER
          JP        C,CERROR             ; WENN KLEINER, FEHLER
          CP        4                   ; GROESSER 'D'
          JP        NC,CERROR            ; SPRUNG WENN JA
          LD        C,A                 ; RETTE ALTE UNIT
          LD        A,(UNIT)
          PUSH      AF
          LD        A,C
          LD        (UNIT),A            ; ZU TESTENDES LAUFWERK
          LD        B,5                 ; ANZAHL DER VERSUCHE
CCMD1:    PUSH      BC
          LD        HL,(UNIT)           ; RETTE UNIT UND TRACK
          PUSH      HL
          CALL      TEST
          POP       HL
          LD        (UNIT),HL
          POP       BC                  ; GET ZAEHLER
          OR        A                   ; FEHLER AUFGETRETEN?
          JR        Z,CCMD2             ; SPRUNG, WENN OK
          DJNZ      CCMD1               ; NOCH EIN VERSUCH?

          POP       AF                  ; HOLE ALTE UNIT
          LD        (UNIT),A
CCMD5:                                  ; HIER AUCH EINSPRUNG FUER BOOT ERROR
          LD        HL,CHKERR           ; DRUCKE FEHLERMELDUNG
          CALL      SOUT
          JP        GETCM               ; NEUE EINGABE

CHKERR:   DEFB      0DH,0AH,BELL
          DEFM      " Disk not correct"
          DEFB      0DH,0AH,24H

CCMD2:
                                        ; GEBE ART DER PLATTE AUS
          POP       AF                  ; SETZE STACK RICHTIG
          LD        HL,CTXT1
          CALL      SOUT
          LD        A,(TEST_TYPE)
          AND       20H                 ; MINI ODER MAXI
          LD        HL,CTXT11
          JR        Z,CCMD3
          LD        HL,CTXT12
CCMD3:    CALL      SOUT

          LD        HL,CTXT2
          CALL      SOUT
          LD        A,(TEST_TYPE)       ; NUMBER OF SURFACES
          RLCA
          AND       01H
          ADD       A,'1'               ; WANDLE IN ASCII
          LD        C,A
          CALL      CO                  ; UND GEBE SEITENZAHL AUS

          LD        HL,CTXT3
          CALL      SOUT
          LD        A,(TEST_TYPE)
          LD        HL,CTXT31
          AND       040H
          JR        Z,CCMD4
          LD        HL,CTXT32
CCMD4:    CALL      SOUT

          LD        HL,CTXT4  ; GEBE SEKTORGROESSE AUS
          CALL      SOUT
          LD        A,(TEST_TYPE)
          AND       0FH
          LD        H,0
          LD        L,A
          ADD       HL,HL
          ADD       HL,HL
          ADD       HL,HL
          LD        DE,SEKTXT
          ADD       HL,DE
          CALL      SOUT

          LD        HL,CTXT5  ; GEBE SEKTOREN/SPUR AUS
          CALL      SOUT
          LD        A,(TEST_MSEK)
          CALL      DEZOUT

          LD        HL,CTXT6  ; GEBE AUS OB DAS LAUFWERK
          CALL      SOUT                ; DAS READY SIGNAL LIEFERT
          CALL      READY_MASK
          AND       0FH
          LD        HL,CTXT62
          JR        NZ,CCMD6
          LD        HL,CTXT61
CCMD6:    CALL      SOUT
                                        ; SETZE CMDTAB
          CALL      SETCMDT

          JP        CRGETCM

CTXT1:    DEFM      0DH,0AH," Disk format...: $"
CTXT2:    DEFM      0DH,0AH," Heads.........: $"
CTXT3:    DEFM      0DH,0AH," Density.......: $"
CTXT4:    DEFM      0DH,0AH," Sector size...: #$"
CTXT5:    DEFM      0DH,0AH," Sectors/Track.: #$"
CTXT6:    DEFM      0DH,0AH," Ready signal..: $"
CTXT31:   DEFM      "single$"
CTXT32:   DEFM      "double$"
SEKTXT:   DEFM      "128    $"
          DEFM      "256    $"
          DEFM      "512    $"
          DEFM      "1024   $"
CTXT11:   DEFM      "maxi$"
CTXT12:   DEFM      "mini$"
CTXT61:   DEFM      "yes$"
CTXT62:   DEFM      "simulated by index$"



OCMD:
          CALL      GETHX               ; LESE PORTADRESSE
          LD        A,D                 ; WAR TRENNZEICHEN CR?
          CP        0DH
          JP        Z,CERROR             ; FEHLER WENN JA
          PUSH      BC                  ; SAVE INTEGER
          CALL      GETHX               ; LESE DATA BYTE
          LD        A,D                 ; WAR TRENNZEICHEN CR?
          CP        0DH
          JP        NZ,CERROR  ; FEHLER WENN NEIN
          LD        L,C
          POP       BC                  ; RESTORE PORTADR.
          OUT       (C),L               ; GEBE AUS
          JP        GETCM

RCMD:
                                        ; LIEST AB IN CMDTAB ANGEGEBENEN SEKTOR
          CALL      DISKDA
          CALL      PRINT_DRIVE
          CALL      RWINP               ; SETZE DMA ADRESSE UND LAENGE
          CALL      READ                ; LESE
          JP        GETCM

WCMD:
          CALL      DISKDA
          CALL      PRINT_DRIVE
          CALL      RWINP
          CALL      WRITE
          JP        GETCM

ICMD:
          LD        C,1
          CALL      GETNM
          POP       BC                  ; IN C STEHT PORT
          IN        A,(C)                         ; LESE NACH A
          LD        C,' '               ; GEBE BLANK AUS
          PUSH      AF
          CALL      CO
          POP       AF
          PUSH      AF
          CALL      NMOUT               ; GEBE HEX AUS
          LD        C,' '               ; GEBE BLANK AUS
          CALL      CO
          POP       AF
          LD        D,A                 ; IN D FUER BITOUT
          CALL      BITOUT
          JP        CRGETCM



ACMD:
                                        ; ZEIGT UND VERAENDERT TRACK, SECTOR UND HEAD
                                        ; DES EINGELOGTEN LAUFWERKS
          CALL      DISKDA              ; BEFEHL ERLAUBT?
          CALL      PRINT_DRIVE

          LD        HL,ATXT1  ; DISPLAY TRACK
          CALL      SOUT
          LD        A,(TRACK)
          CALL      NMOUT
          CALL      ACMD4               ; LESE NEUEN WERT
          JR        NC,ACMD1            ; KEINE EINGABE?
          LD        (TRACK),A
ACMD1:    CALL      ACMD5

          LD        HL,ATXT2  ; DISPLAY HEAD
          CALL      SOUT
          LD        A,(HEAD)
          CALL      NMOUT
          CALL      ACMD4
          JR        NC,ACMD2
          AND       03H                 ; MASK UPPER 6 BITS
          LD        (HEAD),A
ACMD2:    CALL      ACMD5

          LD        HL,ATXT3  ; DISPLAY SECTOR
          CALL      SOUT
          LD        A,(SECTOR)
          CALL      NMOUT
          CALL      ACMD4
          JR        NC,ACMD3
          LD        (SECTOR),A
ACMD3:    CALL      ACMD5

          JP        CRGETCM

ACMD4:    LD        C,CNGPRMT
          CALL      CECHO
          CALL      GETHX
          LD        A,C
          RET

ACMD5:    LD        A,D
          CP        0DH
          JP        Z,GETCM
          RET

ATXT1:    DEFM      0DH,0AH," Track..: $"
ATXT2:    DEFM      0DH,0AH," Head...: $"
ATXT3:    DEFM      0DH,0AH," Sector.: $"



BCMD:
                                        ; EINSPRUNG BOOTROUTINE

          CALL      DISKDA              ; BEFEHL ERLAUBT?
          XOR       A
          LD        (TEST_TRACK),A      ; ERSTE TESTSPUR IST 0
BCMD2:    LD        (UNIT),A            ; OK, IN CMDTAB
          CALL      SPECD               ; SETZT DISK TIMING
          LD        B,5                 ; TESTE PLATTE MAX. 5 MAL
BCMD3:    PUSH      BC
          CALL      TEST                ; SETZT CONTROLLER AUF MINI ODER MAXI
          POP       BC
          OR        A                   ; FEHLER AUFGETRETEN?
          JR        Z,BCMD4             ; SPRUNG WENN NEIN
          DJNZ      BCMD3               ; NOCH EIN VERSUCH?
          JP        CCMD5               ; GEBE FEHLER MELDUNG AUS
BCMD4:
          CALL      SETCMDT             ; SETZE CMDTABELLE
          XOR       A                   ; SETZE SPUR NULL
          LD        (TRACK),A
          LD        (HEAD),A            ; HEAD NULL
          INC       A
          LD        (SECTOR),A          ; SEKTOR EINS
          LD        HL,BOOTADR
          LD        (DMAADR),HL
          LD        A,01H               ; UEBERTRAGE EINEN SECTOR
          LD        (SECTCNT),A
                                        ; OK, ALLE WERTE SIND GESETZT
          CALL      READ                ; LESE
          OR        A                   ; FEHLER AUFGETRETEN?
          JP        NZ,BOOTERR
          LD        HL,BOOTADR          ; KOPIERE DIE ERSTEN 128 BYTE
          LD        DE,BOOTADR+380H     ; NACH HINTEN
          LD        BC,128
          LDIR
          JP        BOOTADR+380H



LCMD:
                                        ; ZEIGE DATUM UND ZEIT AN
          LD        A,(CLKFLG)          ; IST DIE UHR UEBERHAUPT DA?
          OR        A
          JP        Z,GCMD1
          CALL      DISP_TIME
          JP        GETCM

GCMD1:    LD        HL,CLKERR_TXT
          CALL      SOUT
          JP        GETCM

CLKERR_TXT:
          DEFM      0DH,0AH,BELL," Clock failure",0DH,0AH,'$'



NCMD:
                                        ; SETZE UHRZEIT UND DATUM
          LD        A,(CLKFLG)
          OR        A
          JP        Z,GCMD1
          LD        HL,CITXT1           ; LESE DATUM EIN
          CALL      SOUT
          CALL      GETDEZ
          CP        '/'
          JP        NZ,CERROR            ; FALSCHES TRENNZEICHEN
          LD        A,L
          CALL      DEZHEX
          RLCA                          ; IN RICHTIGE POSITION
          RLCA
          RLCA
          RLCA
          AND       0F0H
          CP        0                   ; MONAT ZWISCHEN 1 UND 12
          JP        Z,CERROR
          CP        0C1H
          JP        NC,CERROR
          LD        (PHYS_TIME+4),A     ; MONAT WEG
          CALL      GETDEZ
          CP        '/'
          JP        NZ,CERROR
          LD        A,L
          CP        0
          JP        Z,CERROR
          CP        32H
          JP        NC,CERROR
          LD        (PHYS_TIME+3),A     ; TAG WEG
          CALL      GETDEZ
          CP        0DH
          JP        NZ,CERROR
          LD        A,L
          CP        80H
          JP        C,CERROR
          CP        9AH
          JP        NC,CERROR
          LD        (TEMP),A  ; JAHR ZWISCHEN SPEICHERN

                                        ; UHRZEIT EINLESEN
          LD        HL, CITXT2
          CALL      SOUT
          CALL      GETDEZ
          CP        ':'
          JP        NZ,CERROR
          LD        A,L
          CP        24H
          JP        NC,CERROR
          LD        (PHYS_TIME+2),A
          CALL      GETDEZ
          CP        ':'
          JP        NZ,CERROR
          LD        A,L
          CP        60H
          JP        NC,CERROR
          LD        (PHYS_TIME+1),A
          CALL      GETDEZ
          CP        0DH
          JP        NZ,CERROR
          LD        A,L
          CP        60H
          JP        NC,CERROR
          LD        (PHYS_TIME),A

                                        ; SETZE DIE ZEIT
          LD        HL,CITXT3
          CALL      SOUT
          CALL      GETCH               ; WARTE AUF IRGEND EIN ZEICHEN
          CALL      SET_PHYS_TIME
          LD        A,(TEMP)            ; SETZE NOCH JAHR
          CALL      DEZHEX              ; WANDLE IN DEZIMALZAHL
          SUB       80                  ; ZIEHE 80 AB
          AND       1FH                 ; MASKIERE
          LD        B,A
          LD        A,(SHIFT_CONT+4)
          AND       0E0H
          OR        B
          LD        (SHIFT_CONT+4),A
          CALL      SET_SHIFT
          CALL      CROUT
          JP        CRGETCM

CITXT1:   DEFM      0DH,0AH,0AH," Enter today's date (MM/DD/YY): $"
CITXT2:   DEFM      " Enter the time (HH:MM:SS):     $"
CITXT3:   DEFM      " Press any key to set time$"



FCMD:
          LD        C,3                 ; HOLE 3 WERTE VON DER CONSOLE
          CALL      GETNM
          POP       BC                  ; FUELL BYTE
          POP       DE                  ; END WERT
          POP       HL                  ; ANFANGSWERT
FCMD1:    LD        (HL),C              ; FUELLE BYTE
          CALL      HILO                ; ENDE ERREICHT?
          JP        C,GETCM
          INC       HL
          JP        FCMD1



VCMD:
                                        ; VERGLEICHT ZWEI SPEICHERBEREICHE MITEINANDER
          LD        C,3                 ; LESE DREI ADRESSEN EIN
          CALL      GETNM
          POP       BC                  ; ZWEITER BLOCKANFANG
          POP       DE                  ; ERSTES BLOCKENDE
          POP       HL                  ; ERSTER BLOCKANFANG
VCMD1:    LD        A,(BC)              ; LESE BYTE AUS BLOCK 2
          CP        (HL)                ; VERGLEICHE MIT ERSTEM BLOCK
          CALL      NZ,VCMD2            ; GEBE UNGLEICHE ADDRESSEN AUS
          CALL      HILO                ; ENDE ERREICHT ?
          JP        C,GETCM             ; OK, ENDE
          INC       HL
          INC       BC
          JP        VCMD1               ; VERGL. NAECHSTES BYTE



TCMD:     LD        C,2                 ; LESE ANFANG UND ENDADDRESSE
          CALL      GETNM
          POP       DE
          POP       HL
TCMD1:    LD        C,(HL)
          LD        A,C                 ; LESE SPEICHERSTELLE
          CPL                           ; NEGIERE
          LD        (HL),A              ; SCHREIBE IN ZELLE
          LD        B,15                ; WARTE ETWAS
TCMD2:    DJNZ      TCMD2
          LD        A,(HL)              ; LESE WIEDER
          LD        (HL),C              ; ORGINAL BYTE ZURUECK
          CPL                           ; A SOLL GLEICH C SEIN
          XOR       C                   ; SETZE ALL UNGLEICHEN BITS
          CALL      NZ,FBYTOUT          ; GEBE FEHLERHAFTES BYTE AUS
          CALL      HILO                ; ENDE?
          JP        C,GETCM             ; SPRUNG WENN JA
          INC       HL                  ; TESTE NAECHSTES BYTE
          JR TCMD1                      ; LOOP






VCMD2:    PUSH      HL
          PUSH      DE
          PUSH      BC                  ; RETTE ALLE ADRESSEN
          CALL      DISPMEM
          LD        C,' '
          CALL      CECHO
          POP       HL
          PUSH      HL
          CALL      DISPMEM
          CALL      CROUT
          CALL      BREAK
          JP        C,GETCM
          POP       BC
          POP       DE
          POP       HL
          RET

DISPMEM:
                                        ; INPUT: HL
                                        ; ZEIGT HL UND (HL) AUF DEM BILDSCHIRM AN
                                        ; ZERSROERT A,B,C,FF'S
          CALL      HLOUT
          LD        C,'='
          CALL      CECHO
          LD        A,(HL)
          CALL      NMOUT
          RET



FBYTOUT:PUSH        HL
          PUSH      DE
          LD        D,A                 ; RETTE AKKU
          CALL      HLOUT
          LD        C,' '               ; GEBE NACH ADRRESE TRENNZEICHEN AUS
          CALL      CO
          CALL      BITOUT              ; GEBE BITFOLGE AUS
          CALL      CROUT
          CALL      BREAK               ; ABBRUCH
          JP        C,GETCM             ; SPRUNG ZUM MONITOR WENN JA
          POP       DE
          POP       HL
          RET



BITOUT:
                                        ; GIBT 8 BIT IN REG.D AUS
                                        ; ZERSTOERT A,B,C,D,E
          LD        B,8                 ; GEBE 8 BIT AUS
BITOUT1:  RLC       D                   ; SCHIEBE IN CARRY
          LD        A,'0'               ; ASCII 0
          LD        E,0
          ADC       A,E
          LD        C,A
          CALL      CO
          DJNZ      BITOUT1
          RET



KCMD:
                                        ; GIBT ALLE KONSOLENEINGABEN UNVERAENDERT AUS
                                        ; ESCAPE MIT CONTROL-C
          LD        HL,KCMDTXT
          CALL      SOUT
KCMD1:    CALL      CI                  ; LESE ZEICHEN
          CP        3                   ; CONTROL-C?
          JR        Z,KCMD2             ; DANN ENDE
          LD        C,A
          CALL      CO                  ; SONST GEBE ZEICHEN AUS
          JR KCMD1
KCMD2:    JP        CRGETCM

KCMDTXT:  DEFM      " (escape with ",5EH,43H,")",0DH,0AH,0DH,0AH,'$'
                                        ; ASide uebersetzt ^C !!!



UCMD:                                   ; SETZE DISK-TIMING
                                        ; UND ANZAHL DER STEP-IMPULSE
          LD        HL,UTXT1            ; LESE STEPRATE
          CALL      SOUT
          CALL      UCMD3
          DEC       A
          LD        C,A
          AND       0F0H                ; TESTE OB KLEINER 10H
          JP        NZ,CERROR            ; GROESSER, DANN FEHLER
          LD        A,C
          CPL                           ; BILDE KOMPLEMENT
          PUSH      AF                  ; RETTE AKKU
          LD        HL,UTXT2            ; LESE HEADUNLOAD TIME
          CALL      SOUT
          CALL      UCMD3
          RRCA
          RRCA
          RRCA
          RRCA
          AND       0FH                 ; MASKIERE
          LD        C,A                 ; RETTE IN C
          POP       AF                  ; GET STEPRATE
          RLCA
          RLCA
          RLCA
          RLCA
          AND       0F0H                ; MASKIERE
          OR        C                   ; UNLOAD TIME DAZU
          LD        (SHIFT_CONT+2),A
          LD        HL,UTXT3            ; LESE HEAD LOAD TIME
          CALL      SOUT
          CALL      UCMD3
          AND       0FEH
          LD        (SHIFT_CONT+3),A
          LD        HL,UTXT4            ; DOPPELSTEP VEKTOR UND
          CALL      SOUT                ; TWOSIDED BITS
          CALL      UCMD3
          LD        (SHIFT_CONT+1),A
                                        ; BOOT UNIT
          LD        HL,UTXT5
          CALL      SOUT
          CALL      GETCH1
          LD        C,00100000B
          CP        'F'
          JR        Z,UCMD20
          LD        C,00000000B
          CP        'H'
          JR        Z,UCMD20
          JP        CERROR
UCMD20:
          PUSH      AF                  ; RETTE ZEICHEN
          LD        A,(SHIFT_CONT+4)

          AND       11011111B
          OR        C
          LD        (SHIFT_CONT+4),A

          OR        1FH                 ; BERECHNE PRUEFSUMME
          LD        HL,SHIFT_CONT+3
          LD        B,3
UCMD1:    ADD       A,(HL)
          DEC       HL
          DJNZ      UCMD1
          CPL                           ; BILDE KOMPLEMENT
          INC       A
          LD        (HL),A
          CALL      UCMD2
          CALL      SPECD
          CALL      SET_SHIFT
          POP       AF                  ; ZEICHEN FUER DEFAULTBOOT
          LD        C,A
          CALL      CECHO                ; MUSS NOCH AUSGEGEBEN WERDEN
          JP        CRGETCM

UCMD2:    LD        HL,(SHIFT_CONT+2)   ; SETZE DISKTIMING NEU
          LD        A,H
          OR        1
          LD        H,A
          LD        (SPECD_WORD),HL
          LD        A,(SHIFT_CONT+1)    ; SETZE SEEKNR (ANZAHL DER STEPIMPULSE)
          LD        (SEEKNR),A          ; UND TWO-SIDED-BITS

          LD        A,(SHIFT_CONT+4)    ; SETZE BOOT UNIT
          AND       00100000B
          LD        (BOOT_FLG),A

          RET

UCMD3:    CALL      GETHX
          LD        A,D
          CP        0DH
          JP        Z,CERROR
          LD        A,C
          RET

UTXT1:    DEFM      10,13," Steprate ...........: $"
UTXT2:    DEFM      10,13," Head unload time ...: $"
UTXT3:    DEFM      10,13," Head load time .....: $"
UTXT4:    DEFM      10,13," Double step vector .: $"
UTXT5:    DEFM      10,13," Default boot unit ..: $"



;-------------------------------------------------------INITIALISIERUNG------

INIT:

;***
          LD        HL,6000             ; VERZOEGERUNG ZUM WARM WERDEN
INIT7:    DEC       HL
          LD        A,PAD_TX OR 1       ; SETZE TX DUPLEX LEITUNG AUF 1
          OUT       (P_LS259),A
          LD        A,PAD_RTS OR 1      ; SETZE RTS INAKTIV
          OUT       (P_LS259),A
          LD        A,PAD_TXP OR 1      ; SETZE TX SIMPLEX LEITUNG AUF 1
          OUT       (P_LS259),A
          LD        A,PAD_POLEN OR 80H  ; AKTIVIERE DRIVE DECODER
          OUT       (P_LS259),A
          LD        A,5                 ; UNIO STROBE 1 HIGH
          OUT       (CONTR),A
          LD        A,7                 ; UNIO STROBE 2 HIGH
          OUT       (CONTR),A
          LD        A,9                 ; UNIO INIT HIGH
          OUT       (CONTR),A
          LD        A,H
          OR        L
          JP        NZ,INIT7

;***
          LD        A,PAD_MOTOR OR 80H
          OUT       (P_LS259),A
          LD        A,PAD_MOTAB OR 1
          OUT       (P_LS259),A
;***

          LD        B,00                ; INITIALISIERE EPROM
          LD        C,P_RAM_TABLE       ; PORTADRESSE DER RAM-TABELLE
          LD        D,16
          LD        E,0                 ; EPROM BANK-ADRESSE
          OUT       (C),E                        ; GEBE BANKADRESSE FUER KACHEL 0 AUS
          LD        A,D                 ; NAECHSTE KACHEL
          ADD       A,B
          LD        B,A
          OUT       (C),E
                                        ; OK, EPROM-KACHELN AKTIV
          LD        A,D                 ; JETZT LOGISCHE RAM-BANK 0
          ADD       A,B
          LD        B,A
          LD        E,02H               ; PHYS.-BANK 13 IST LOG.-BANK 0
INIT8:    OUT       (C),E               ; INITIALISIERE RESTL. KACHELN
          LD        A,D
          ADD       A,B
          LD        B,A
          CP        80H
          JR        NZ,INIT16
          LD        E,0AH
INIT16:   OR        A
          JR        NZ,INIT8
                                        ; RAM-TABELLE OK
          LD        A,PAD_INIT OR 1     ; AKTIVIERE-BANKLEITUNGEN
          OUT       (P_LS259),A
                                        ; OK, RAM IST AKTIV
                                        ; TESTE BANK 0
          LD        HL,MSTAK-80         ; SCHREIBE 256 BYTES
          XOR       A                   ; IN STACK
INIT13:   LD        (HL),A
          INC       HL
          INC       A
          JR        NZ,INIT13
          LD        HL,0                ; VERZOEGERE ETWAS
INIT15:   DEC       HL
          LD        A,H
          OR        L
          JR        NZ,INIT15
          LD        HL,MSTAK-80
          XOR       A
INIT12:   CP        (HL)                ; UND VERGLEICHE WIEDER
          JR        NZ,INIT9            ; UNGLEICH, SETZE FLAG
          INC       HL                  ; EINEN WERT HOEHER
          INC       A
          JR        NZ,INIT12
          XOR       A                   ; FLAG FUER BANK 0 OK
          JR INIT10
INIT9:    LD        A,01H               ; FLAG FUER BANK 0 NICHT OK
INIT10:   LD        I,A                          ; RETTE FLAG IN INT.REGISTER

          LD        B,20H               ; SCHALTE BANK 1 EIN
          LD        C,P_RAM_TABLE
          LD        D,16
          LD        E,03H
INIT11:   OUT       (C),E               ; SETZE KACHEL
          LD        A,D                 ; EINS WEITER
          ADD       A,B
          LD        B,A
          CP        80H                 ; OBERE HAELFTE
          JR        NZ,INIT27
          LD        E,0BH               ; DANN E NEU SETZEN
INIT27:   OR        A                   ; IST AKKU GLEICH NULL
          JR        NZ,INIT11           ; ALLES BANK1 VOLLSTAENDIG EINGESCHALTET

          LD        HL,MSTAK-80         ; TESTE BANK 1
          XOR       A
INIT17:   LD        (HL),A              ; SCHREIBE 256 BYTES VOLL
          INC       HL
          INC       A
          JR        NZ,INIT17
          LD        HL,0                ; WARTE ETWAS
INIT18:   DEC       HL
          LD        A,H
          OR        L
          JR        NZ,INIT18
          LD        HL,MSTAK-80         ; UND VERGLEICHE WIEDER
          XOR       A
INIT19:   CP        (HL)
          JR        NZ,INIT20           ; FEHLER
          INC       HL
          INC       A
          JR        NZ,INIT19
          LD        B,0                 ; FLAG FUER KEIN FEHLER
          JR INIT21
INIT20:   LD        B,02H               ; FLAG FUER FEHLER
INIT21:   LD        A,I                 ; LADE FLAG VON BANK 0
          OR        B                   ; UND PACKE FLAK VON BANK 1 DAZU
          LD        I,A                 ; WIEDER IN INTERRUPT REGISTER

          CP        3                   ; SPRUNG WENN KEINE BANK
          JR        Z,BLINK_LOOP        ; IN ORDNUNG IST
          CP        1                   ; LASSE BANK 1 EINGESCHALTET
          JR        Z,INIT22            ; WENN BANK 0 FEHLERHAFT IST

          LD        B,20H               ; ANSONSTEN SCHALTE
          LD        C,P_RAM_TABLE       ; WIEDER BANK 0 EIN
          LD        D,16
          LD        E,02H
INIT23:   OUT       (C),E
          LD        A,D
          ADD       A,B
          LD        B,A
          CP        80H                 ; OBERE HAELFTE
          JR        NZ,INIT24
          LD        E,0AH
INIT24:   OR        A                   ; ALLES EINGESCHALTET?
          JR        NZ,INIT23
INIT22:   JR INIT14                     ; DANN WEITER

BLINK_LOOP:
          LD        B,80H               ; BESETZE
          LD        C,PAD_INUSE         ; REGISTER
          LD        HL,0                ; VOR
          EXX
          LD        B,MASK_RX
          LD        C,MASK_CTS
          LD        D,PAD_TX
          LD        E,PAD_RTS
          LD        H,01H
          LD        L,0FFH
          EXX
BLINK_LOOP1:
          DEC       HL                  ; HL EINS WENIGER

          LD        A,H
          ADD       A,A
          ADD       A,A
          AND       B                   ; SETZE LED GLEICH
          OR        C                   ; DEM DRITTHOECHSTEN
          OUT       (P_LS259),A         ; BIT DES H-REGISTERS

          EXX

          IN        A,(P_IN_LS258_A)    ; SETZE TX-LEITUNG
          AND       B                   ; AUF DEN
          ADD       A,L                 ; PEGEL DER
          CCF                           ; RX-LEITUNG
          RLA
          AND       H
          OR        D
          OUT       (P_LS259),A

          IN        A,(P_IN_LS258_A)    ; SETZE RTS-LEITUNG
          AND       C                   ; AUF DEN
          ADD       A,L                 ; PEGEL DER
          CCF                           ; CTS-LEITUNG
          RLA
          AND       H
          OR        E
          OUT       (P_LS259),A

          IN        A,(P_IN_LS258_A)    ; SETZE TXP-LEITUNG
          AND       MASK_CTSP           ; AUF DEN
          ADD       A,L                 ; PEGEL  DER
          CCF                           ; CTSP-LEITUNG
          RLA
          AND       H
          OR        PAD_TXP
          OUT       (P_LS259),A

          EXX

          JR BLINK_LOOP1

INIT14:                                 ; OK, MONITOR KANN LAUFEN

                                        ;***
          LD        SP,MSTAK            ; SETZE STACKPOINTER
                                        ;***
          LD        HL,DISKPAGE         ; COPIERE ALS ALLERERSTES NACH RAM EIN
          LD        DE,SYSTEMPAGE       ; DIE DISKPAGE AUF DIE SYSTEMPAGE
          LD        BC,256
          LDIR
                                        ;***
          LD        A,I                 ; SPEICHER BANKFEHLERBYTE IN
          LD        (BANK_ERR_BYTE),A   ; SYSTEMPAGE
                                        ;***
          CALL      FLOPPY_RESET        ; SETZE FLOPPY-CONTROLER
                                        ; ZURUECK
                                        ;***
                                        ; SETZE UMLEITUNGS SPRUENGE IM RAM
          LD        A,0C3H              ; JUMP BEFEHL IN AKKU
          LD        HL,GETCM            ; UMLEITUNGSADRESSE IN HL
          LD        (UMLEIT_GETCM),A
          LD        (UMLEIT_GETCM+1),HL
          LD        HL,CONST
          LD        (UMLEIT_CONST),A
          LD        (UMLEIT_CONST+1),HL
          LD        HL,CONIN
          LD        (UMLEIT_CONIN),A
          LD        (UMLEIT_CONIN+1),HL
          LD        HL,CONOUT
          LD        (UMLEIT_CONOUT),A
          LD        (UMLEIT_CONOUT+1),HL
          LD        HL,START
          LD        (UMLEIT_NMI),A
          LD        (UMLEIT_NMI+1),HL
                                        ;***
                                        ; BESETZE SPEICHERZELLEN VOR

          XOR       A                   ; BESETZE BYTE MIT 0
          LD        (HEAD),A
          LD        (DERMSG),A          ; FLOPPY-FEHLERMELDUNG AKTIV
          LD        A,1                 ; BESETZE BYTE MIT 1
          LD        (TEST_TRACK),A
          LD        (TRACK),A
          LD        (SECTOR),A
          LD        A,2
          LD        (WRITE_PRECOM),A    ; PRECOMPENSATIONSZEIT AUF FESTEN WERT
          LD        A,10
          LD        (RWRETRY),A         ; ANZAHL VERSUCHE FUER FLOPPY R/W
          LD        HL,0                ; BESETZE WORT MIT 0
          LD        (DISPADR),HL
          LD        HL,IN_BUFF_ZEIG     ; SETZE ZEIGER FUER SOFTIN BUFFER
          LD        (IN_BUFF_ZEIG),HL

          LD        A,(XSEEKNR)         ; VORBESTZUNG WIE IM EPROM EINGEPATCHT
          LD        (SEEKNR),A
          LD        A,(XREADY_BYTE)
          LD        (READY_BYTE),A
          LD        A,(XTE_TIME)
          LD        (TE_TIME),A
          LD        A,(XSTEP_WAIT)
          LD        (STEP_WAIT),A
          LD        HL,(XSPECD_WORD)
          LD        (SPECD_WORD),HL

          LD        DE,KENNUNG          ; SETZE KENNUNGSTEXT
          LD        HL,KENNUNGSTEXT
          LD        BC,7
          LDIR
          LD        A,(VERSIONNR)       ; SETZE MONITOR VERSIONSNUMMER
          LD        (MON_VERS),A        ; IM RAM


          CALL      USERINIT            ; INITIALISERE BENUTZER SCHNITSTELLEN

          CALL      GET_SPEED           ; IST UHR DA? UND WELCHE TAKTRATE IM SYS.
          LD        (CLKFLG),A          ; FLAG FUER UHR DA, NICHT DA
                                        ; WENN KEINE UHR DA, WIRD 4MHZ SYS.TAKT
           IF       NOT ACHTMHZ         ; ANGENOMMEN.
          OR        A
          JR        NZ,INIT3            ; DIES ENTSPRICHT 8MHZ BEI
           ENDIF                        ; ACHTMHZ=JA.
          LD        HL,40000
INIT3:    LD        (SYSTEMTAKT),HL     ; LEGE SYSTEMTAKT AB


          CALL      GET_JUMPER          ; SETZE BEIDE JUMPERBYTE
          CALL      SET_SOFT_BAUD       ; SETZE DIE VERZOEGERUNGSZEIT IN SOFTVERZ
                                        ; IN ABHAENIGKEIT VON BAUD_JUMPER_BYTE
                                        ; UND DEN EINTRAEGEN IN SOFT_BAUD_TAB
          LD        A,(XPRNT_BAUD)
          CALL      SET_SIMPLEX_BAUD    ; SETZE SIMPLEX VERZOEGERUNG

          CALL      UNIOINIT            ; INITIALISIERE UNIO



          LD        HL,INITXT0          ; GEBE KOPFTEXT AUS
          CALL      SOUT
          LD        HL,(SERNR)          ; GEBE SERIENNUMMER
          CALL      PDEC                ; ALS DEZIMALZAHL AUS
          CALL      CROUT


          LD        A,(BANK_ERR_BYTE)   ; GEBE GROESSE DES RAMBEREICHES AUS
          LD        HL,INITXT9          ; 128K
          CP        0
          JR        Z,INIT26
          LD        HL,INITXT6          ; 64K (NUR BANK 1)
          CP        1
          JR        Z,INIT26
          LD        HL,INITXT7          ; 64K (NUR BANK 0)
INIT26:   CALL      SOUT


          LD        A,(CLKFLG)          ; GEBE TAKTRATE AUS, WENN
          OR        A                   ; UHR UEBERHAUPT DA?
          JR        Z,NOCLK             ; GEBE MELDUNG AUS, WENN UHR DA
          LD        HL,INITXT1
          CALL      SOUT
           IF       NOT ACHTMHZ
          LD        HL,(SYSTEMTAKT)     ; GEBE ERMITTELTE TAKT FREQUENZ AUS
          CALL      PDEC
          LD        HL,INITXT2
          CALL      SOUT
           ENDIF
          CALL      DISP_TIME           ; GEBE UHRZEIT AUS
          JR NOCLK2
NOCLK:
           IF       ACHTMHZ
          LD        HL,INITXT1
          CALL      SOUT
           ENDIF
          LD        HL,INITXT4          ; GEBE MELDUNG AUS
          CALL      SOUT                ; WENN UHR NICHT DA
NOCLK2:



          IM        1                   ; INTERRUPT MODE 1
          EI                            ; ENABLE INTERRUPTS
          LD        A,(IO_JUMPERBYTE)   ; INTERRUPTBETRIEB DER SOFT-EINGABE?
          DEC       A                   ; WENN JA GEBE RTS FREI
          JR        NZ,INIT28
          LD        A,PAD_RTS
          OUT       (P_LS259),A
INIT28:


          LD        A,(CLKFLG)          ; SETZE DISKTIMING NEU, WENN
          OR        A                   ; A) UHR OK UND B) CHECKSUMME
          JP        Z,INIT29            ; DES SCHIFTREGISTERS STIMMT.
          LD        HL,SHIFT_CONT+4     ; BERECHNE PRUEFSUMME
          LD        A,(HL)
          OR        00011111B           ; MASKIERE JAHRESZAHL
          LD        B,4                 ; ADDIERE DIE RESTLICHEN 4 BYTE
INIT30:   DEC       HL
          ADD       A,(HL)
          DJNZ      INIT30
          OR        A                   ; PRUEFSUMME MUSS 0 SEIN
          LD        A,0                 ; FALLS SPRUNG, DANN A=0
          JP        NZ,INIT29           ; SONST DEFAULT WERTE
          CALL      UCMD2               ; SETZE NEUES TIMING
          LD        A,0FFH              ; FLAG FUER PROMT
INIT29:   LD        (TEMP),A



          CALL      INIFDC              ; IST FLOPPY CONTROLLER IN ORDNUNG?
                                        ; WENN JA SETZE SOFT RESET
          LD        A,(DISKFLG)         ; WAR ZUGRIFF AUF FLOPY CONTROLER MOEGLICH?
          OR        A
          JR        Z,INIT4             ; SPRUNG WENN FLOPY NICHT OK
          CALL      SPECD               ; SET DRIVE PAR. + DMA-MODE
          JR INIT5
INIT4:
          LD        HL,INITXT5          ; GEBE MELDUNG FUER FLOPPY FEHLER AUS
          CALL      SOUT
          LD        A,(BOOT_FLG)        ; DEFAULT BOOT VON HARDDISK
          OR        A                   ; JA, WENN NULL
          JP        NZ,START            ; SONST KEIN BOOT MOEGLICH, ZUM MONITOR
INIT5:



          LD        A,(TEMP)            ; GEBE MELDUNG AUS OB NON-DEFAULT
          LD        HL,INITXTA          ; DISKTIMING
          INC       A
          CALL      Z,SOUT



          LD        HL,INITXT3          ; MONITOR ODER BOOT
          CALL      SOUT
          LD        HL,INITXTC
          LD        A,(BOOT_FLG)
          OR        A
          JP        NZ,INITA
          LD        HL,INITXTB
INITA:    CALL      SOUT
          CALL      GETCH1
          PUSH      AF
          CALL      CROUT               ; GEBE AUF JEDEN FALL CR LF AUS
          POP       AF
          CP        0DH                 ; MONITOR?
          JP        Z,START             ; NEIN BOOT

          LD        A,(BOOT_FLG)        ; TESTE, OB BOOT VON
          OR        A                   ; HARDDISK ODER
          JP        Z,HCMD              ; FLOPPY
          JP        BCMD

;***

INITXT0:  DEFM        0CH,0DH,0AH,"PROF-80, EPROM version 1.7  serial no. #$"
INITXT1:
           IF       ACHTMHZ
          DEFM        0DH,0AH,"System speed 8.00 MHz assumed",0DH,0AH,'$'
           ELSE
          DEFM        0DH,0AH,"System speed $"
INITXT2:  DEFM        "00 (Hz)",0DH,0AH,'$'
           ENDIF
INITXTA:  DEFM        0DH,0AH,"user defined disk timing",0DH,0AH,'$'
INITXT3:  DEFM        0DH,0AH,"<RETURN> => Monitor, <other key> => boot from $"
INITXTC:  DEFM        "Floppy $"
INITXTB:  DEFM        "Harddisk $"
INITXT4:  DEFM        0DH,0AH,"Clock failure"
           IF       NOT ACHTMHZ
          DEFM      ", 4 MHz system speed is assumed"
           ENDIF
          DEFB      0DH,0AH,'$'
INITXT5:  DEFM        0DH,0AH,"Floppy failure",0DH,0AH,'$'
INITXT6:  DEFM        0DH,0AH,"    64K RAM (Bank 1 only)",0DH,0AH,'$'
INITXT7:  DEFM        0DH,0AH,"    64K RAM (Bank 0 only)",0DH,0AH,'$'
INITXT9:  DEFM        0DH,0AH,"    128K RAM",0DH,0AH,'$'

;----------------------------------------------------ENDE INITIALISIERUNG----

;----------------------------------------------------EIN-AUSGABEROUTINEN-----



GRAFIST:
                                        ; TERMINAL EINGABE STATUS
                                        ; AKKU 0 UND Z WENN KEIN ZEICHEN
                                        ; AKKU FF UN NZ WENN ZEICHEN
          IN        A,(GRIPC)
          AND       GRIPIN_MASK
          RET       Z
          LD        A,0FFH
          OR        A                   ; RESET ZERROFLAG
          RET



GRAFOST:
                                        ; TERMINAL AUSGABE STATUS
          IN        A,(GRIPC)
          AND       GRIPOUT_MASK
          RET       Z
          LD        A,0FFH
          OR        A
          RET



GRAFIN:
                                        ; TERMINAL EINGABE
          IN        A,(GRIPC)
          AND       GRIPIN_MASK         ; ZEICHEN DA ?
          JR        Z,GRAFIN            ; WARTE AUF ZEICHEN
          IN        A,(GRIPD)
          RET


GRAFOUT:
                                        ; TERMINAL AUSGABE
          IN        A,(GRIPC)
          AND       GRIPOUT_MASK
          JR        Z,GRAFOUT           ; WARTE BIS BUFFER LEER
          LD        A,C                 ; AUSGABE ZEICHEN NACH A
          OUT       (GRIPD),A
          RET



                                        ; EIN-AUSGABE FUER DIE DUPLEX SCHNITTSTELLE AUF DER CPU-KARTE


SOFTOUT:
                                        ; GEBE INHALT VON REGISTER C IM SERIELLEN FORMAT AUS

          PUSH      BC                  ; RETTE BC
          PUSH      DE                  ; RETTE DE
          PUSH      HL                  ; RETTE HL
SOFTOUT4:

          IN        A,(P_IN_LS258_A)    ; WARTE AUF FREIGABE
          AND       MASK_CTS
          JR        Z,SOFTOUT4
          LD        A,PAD_RTS OR 1      ; SPERRE EINGABE
          OUT       (P_LS259),A
          DI                            ; SPERRE INTERRUPTS
          RLC       C                   ; BITS RICHTIG FUER AUSGABE
          LD        D,PAD_TX            ; ADRESSE DES TXD BITS AM LS259
          XOR       A                   ; STARTBIT IN AKKU
          LD        B,9                 ; GEBE 9 BITS AUS
SOFTOUT1:
          AND       001H                ; MASKIERE BIT FUER AUSGABE <7>
          OR        D                   ; PACKE ADRESSE DAZU <4>
          OUT       (P_LS259),A         ; GEBE BIT AUS <11>
          LD        HL,(SOFTVERZ)       ; LADE VERZOEGERUNGSZEIT <16>
SOFTOUT2:
          DEC       HL                  ; VERZOEGERUNG <6>
          LD        A,H                 ; GLEICH NULL? <4>
          OR        L                   ; <4>
          JP        NZ,SOFTOUT2         ; <10>

          RRC       C                   ; SCHIEBE C UM EIN BIT NACH RECHTS <8>
          LD        A,C                 ; <4>
          DJNZ      SOFTOUT1            ; <13>

          LD        A,PAD_TX OR 1       ; GEBE STOPBIT AUS
          OUT       (P_LS259),A
          LD        HL,(SOFTVERZ)
          ADD       HL,HL               ; ZWEI STOPBITS
SOFTOUT3:
          DEC       HL                  ; VERZOEGERUNG FUER
          LD        A,H                 ; STOPBIT
          OR        L
          JP        NZ,SOFTOUT3

          EI                            ; GEBE INTERRUPTS FREI
          LD        A,(IO_JUMPERBYTE) ; KANN EINGABE FREI GEGEBEN WERDEN?
          DEC       A                   ; JA WENN INT.BETRIEB
          JR        NZ,SOFTOUT5
          LD        A,PAD_RTS ; GEBE EINGABE FREI
          OUT       (P_LS259),A
SOFTOUT5:
          POP       HL                  ; RETTE HL
          POP       DE                  ; RETTE DE
          POP       BC                  ; RETTE BC
          LD        A,C                 ; ZEICHEN IN AKKU
          RET



SOFTIN:
                                        ; EINLESEN EINES ZEICHENS SOWOHL IM INTERRUPT
                                        ; BETRIEB (INTERRUPT BETRIEB IST DANN, WENN DIE
                                        ; SOFTSCHNITTSTELLE DIE KONSOLE TREIBT)
                                        ; ALS AUCH IM NICHT INTERRUPT BETRIEB

          PUSH      BC
          PUSH      DE
          PUSH      HL
          LD        A,(IO_JUMPERBYTE) ; IST INTERRUPT-BETRIEB?
          DEC       A                   ; INT. WENN A=1
          JR        Z,SOFTIN8           ; SPRUNG BEI INTERRUPT
          LD        A,PAD_RTS ; GEBE RTS FREI
          OUT       (P_LS259),A
          CALL      SOFTIN1             ; ANSONSTEN WARTE AUF STARTBIT UND LESE EIN
          PUSH      AF
          LD        A,PAD_RTS OR 1
          OUT       (P_LS259),A
          POP       AF
          POP       HL
          POP       DE
          POP       BC
          RET

SOFTIN8:                      ; IM INTERRUPT-BETRIEB WIRD GEWARTET BIS
                                        ; DIE INTERRUPT SERVICE ROUTINE EIN ZEICHEN
                                        ; IN DEN BUFFER SCHREIBT

          EI                            ; VORSICHTSHALBER INT. ENABLE
          LD        A,PAD_RTS
          OUT       (P_LS259),A
          LD        C,IN_BUFF_ZEIG AND 0FFH
SOFTIN9:LD          A,(IN_BUFF_ZEIG) ; WARTE BIS EIN ZEICHEN KOMMT
          CP        C                   ; WENN GLEICH, DANN NOCH KEIN ZEICHEN
          JR        Z,SOFTIN9
          LD        A,PAD_RTS OR 1      ; RTS INAKTIV
          OUT       (P_LS259),A
          DI                            ; OK, ZEICHEN DA, SPERRE INT.
          LD        A,(IN_BUFF_ZEIG-1) ; LADE ZEICHEN IN AKKU
          LD        HL,(IN_BUFF_ZEIG)
          INC       HL                  ; UND ERHOEHE ZEIGER
          LD        (IN_BUFF_ZEIG),HL
          LD        DE,IN_BUFF_ZEIG-1 ; SCHIEBE ZEICHEN EINS HOCH
          LD        HL,IN_BUFF_ZEIG-2
          LD        BC,IN_BUFF_ZEIG-1-IN_BUFF_END
          LDDR
          EI                            ; INTERRUPTS ENABLE
          PUSH      AF
          LD        A,PAD_RTS ; GEBE EINGABE FREI
          OUT       (P_LS259),A
          POP       AF
          POP       HL
          POP       DE
          POP       BC
          RET



INT_SERVICE:
                                        ; NACH EINEM INTERRUPT UND WENN DIE SOFTSCHNITTSTELLE DIE KONSOLE
                                        ; BEDIENT, WIRD DIESE INTERRUPT-SERVIE-ROUTINE ANGESPROCHEN.
                                        ; SIE LIEST EIN ZEICHEN IN DIE SPEICHER ZELLE UNTER DIE IN_BUFF_ZEIG
                                        ; ZEIGT. IST DER BUFFER VOLL (11 BYTES), WIRD KEIN ZEICHEN
                                        ; MEHR EINGELESEN.

          PUSH      AF
          PUSH      BC
          PUSH      DE
          PUSH      HL
          CALL      SOFTIN2             ; LESE ZEICHEN EIN
          LD        C,A                 ; RETTE ZEICHEN IN C
          LD        HL,(IN_BUFF_ZEIG) ; LADE BUFFER-ZEIGER
          LD        A,IN_BUFF_END AND 0FFH
          CP        L                   ; ZEIGER SCHON AM ENDE?
          JR        Z,INT_SERVICE1      ; DANN GEHT ZEICHEN VERLOREN
          DEC       HL                  ; SONST LEGE ZEICHEN IN BUFFER
          LD        (HL),C
          LD        (IN_BUFF_ZEIG),HL ; UND SETZE ZEIGER NEU
INT_SERVICE1:

          POP       HL
          POP       DE
          POP       BC
          POP       AF
          EI                            ; GEBE INT. FREI
          RET



SOFTIN1:
                                        ; LESE ZEICHEN UEBER 74LS258 EIN

          IN        A,(P_IN_LS258_A)
          AND       MASK_RX             ; WARTE AUF STARTBIT
          JR        Z,SOFTIN1           ; DER LS258 NEGIERT
SOFTIN2:
          LD        HL,(SOFTVERZ)       ; LADE VERZOEGERUNG
          SRL       H                   ; TEILE DURCH ZWEI
          RR        L                   ; UM IN DER BIT MITTE ABZUTASTEN
SOFTIN5:DEC         HL                  ; VERZOEGERUNGSSCHLEIFE
          LD        A,H                 ; FUER EIN HALBES BIT
          OR        L
          JP        NZ,SOFTIN5

          LD        B,8                 ; LESE 8 BITS EIN
SOFTIN3:
          LD        HL,(SOFTVERZ)       ; ERST EIN BIT VERZOEGERN <16>
SOFTIN4:  DEC       HL                  ; VERZOEGERUNGSSCHLEIFE
          LD        A,H
          OR        L
          JP        NZ,SOFTIN4

          IN        A,(P_IN_LS258_A) ; LESE BIT EIN <11>
          AND       MASK_RX             ; <7>
          ADD       A,0FFH              ; SETZE CARRY WENN EINS <7>
          RR        C                   ; UND LEGE IN CHARPUF. <8>
          DJNZ      SOFTIN3             ; LESE 8 BITS EIN <13>

          LD        A,C                 ; ERGEBNISS IN AKKU
          CPL                           ; NEGIERE, DA LS258 AUCH NEGIERT
SOFTIN7:  AND       7FH                 ; STRIPP OF PARITY

          PUSH      AF
          LD        HL,(SOFTVERZ)       ; WARTE STOP BIT AB
SOFTIN10:
          DEC       HL
          LD        A,H
          OR        L
          JP        NZ,SOFTIN10
          POP       AF

          RET



SOFTIST:
                                        ; PRUEFE, OB IM INT.-BETRIEB EIN ZEICHEN IM BUFFER IST
                                        ; WENN EINS GEKOMMEN IST, SETZE A AUF FF
                                        ; SONST AUF 0
                                        ; IST KEIN INTERRUPT BETRIEB, DANN AKKU IMMER 0

          PUSH      HL
          PUSH      DE
          PUSH      BC
          LD        A,(IO_JUMPERBYTE) ; INT.  BETRIEB?
          DEC       A
          JR        NZ,SOFTST1                    ; SPRUNG WENN KEIN INT.-BETRIEB
          LD        A,(IN_BUFF_ZEIG) ; LADE ZEIGER
          LD        C,IN_BUFF_ZEIG AND 0FFH
          CP        C                   ; VERGLEICHE
          JR        Z,SOFTST1           ; SPRUNG WENN KEIN ZEICHEN DA
          LD        A,0FFH
          JR SOFTST2
SOFTST1:LD          A,0
SOFTST2:POP         HL
          POP       DE
          POP       HL
          OR        A                   ; SETZE ZEROFLAG
          RET



SOFTOST:
          IN        A,(P_IN_LS258_A) ; LESE CTS EIN
          AND       MASK_CTS  ; MASKIERE
          RET       Z                   ; RETURN WENN NICHT BEREIT
          LD        A,0FFH              ; SONST BEREIT
          OR        A                   ; RESET ZERRO-FLAG
          RET



SOFTPRNTOST:
          IN        A,(P_IN_LS258_A) ; LESE CTSP EIN
          AND       MASK_CTSP
          RET       Z
          LD        A,0FFH
          OR        A
          RET



SOFTPRNTOUT:
                                        ; GEBE INHALT VON REGISTER C IM SERIELLEN FORMAT
                                        ; AUF DER SIMPLEX SCHNITTSTELLE AUS

          PUSH      BC                  ; RETTE BC
          PUSH      DE                  ; RETTE DE
          PUSH      HL                  ; RETTE HL
SOFTPRNTOUT4:

          IN        A,(P_IN_LS258_A)    ; WARTE AUF FREIGABE
          AND       MASK_CTSP
          JR        Z,SOFTPRNTOUT4
          LD        A,PAD_RTS OR 1      ; SPERRE EINGABE VON DUPLEX SCHNITTSTELLE
          OUT       (P_LS259),A
          DI                            ; SPERRE INTERRUPTS
          RLC       C                   ; BITS RICHTIG FUER AUSGABE
          LD        D,PAD_TXP           ; ADRESSE DES TXD BITS AM LS259
          XOR       A                   ; STARTBIT IN AKKU
          LD        B,9                 ; GEBE 9 BITS AUS
SOFTPRNTOUT1:
          AND       001H                ; MASKIERE BIT FUER AUSGABE <7>
          OR        D                   ; PACKE ADRESSE DAZU <4>
          OUT       (P_LS259),A         ; GEBE BIT AUS <11>
          LD        HL,(SOFTPRNTVERZ)   ; LADE VERZOEGERUNGSZEIT <16>
SOFTPRNTOUT2:
          DEC       HL                  ; VERZOEGERUNG <6>
          LD        A,H                 ; GLEICH NULL? <4>
          OR        L                   ; <4>
          JP        NZ,SOFTPRNTOUT2     ; <10>

          RRC       C                   ; SCHIEBE C UM EIN BIT NACH RECHTS <8>
          LD        A,C                 ; <4>
          DJNZ      SOFTPRNTOUT1        ; <13>

          LD        A,PAD_TXP OR 1      ; GEBE STOPBIT AUS
          OUT       (P_LS259),A
          LD        HL,(SOFTPRNTVERZ)
          ADD       HL,HL               ; ZWEI STOPBITS
SOFTPRNTOUT3:
          DEC       HL                  ; VERZOEGERUNG FUER
          LD        A,H                 ; STOPBIT
          OR        L
          JP        NZ,SOFTPRNTOUT3

          EI                            ; GEBE INTERRUPTS FREI
          LD        A,PAD_RTS ; GEBE EINGABE FREI DUPLEX
          OUT       (P_LS259),A         ; SCHNITTSTELLE FREI
          POP       HL                  ; RETTE HL
          POP       DE                  ; RETTE DE
          POP       BC                  ; RETTE BC
          LD        A,C                 ; ZEICHEN IN AKKU
          RET



GET_JUMPER:
          LD        HL,PATAB
          LD        BC,PDTAB
          LD        E,P_LS259
          LD        D,P_IN_LS258_B
          CALL      JUMPIN
          LD        (BAUD_JUMPERBYTE),A ; SPEICHERE AB
          LD        A,D
          LD        (IO_JUMPERBYTE),A
          RET



JUMPIN:                                 ; DIESES PROGRAMM LIEST DIE BEIDEN
                                        ; JUMPER AUF DER UNIO- BZW PROF-KARTE
                                        ; EIN. FOLGENDE REGISTER MUESSEN BELEGT SEIN
                                        ; E=PORTADRESSE DES 74 LS259
                                        ; D=PORTADRESSE DES EINGANGS PORTS
                                        ; BC=ADRESSE DER DECODER TABELLE
                                        ; HL=ADRESSE DER AUSGANGS BITS
                                        ; AUSGABE
                                        ; AKKU=JUMPER 1, D=JUMPER2

          PUSH      BC                  ; RETTE DECODER TABELLE
          LD        C,E
          LD        B,3                 ; ERSTES BITMUSTER AUSGEBEN
          OTIR
          LD        A,C                 ; TAUSCHE PORTADRESSE
          LD        C,D
          LD        D,A
          IN        A,(C)                         ; LESE ERSTES BITPAAR EIN
          RRA                           ; SCHIEBE BITS NACH RECHTS
          RRA
          RRA
          RRA
          AND       00000011B ; MASKIERE
          LD        E,A                 ; UND NACH E

          LD        A,C                 ; TAUSCHE PORTADRESSE
          LD        C,D
          LD        D,A
          LD        B,2                 ; ZWEITES BITMUSTER AUSGEBEN
          OTIR
          LD        A,C                 ; TAUSCHE PORTADRESE
          LD        C,D
          LD        D,A
          IN        A,(C)                         ; LESE ZWEITES BITPAAR EIN EIN
          RRA                           ; EINMAL NACH RECHTS SCHIEBEN
          RRA
          AND       00001100B ; MASKIEREN
          OR        E                   ; UND ZU E PACKEN
          LD        E,A

          LD        A,C                 ; TAUSCHE PORTADRESSE
          LD        C,D
          LD        D,A
          LD        B,2                 ; DRITTES BITMUSTER AUSGEBEN
          OTIR
          LD        A,C                 ; TAUSCHE PORTADRESSE
          LD        C,D
          LD        D,A
          IN        A,(C)                         ; LESE DRITTES BITPAAR EIN
          AND       00110000B ; MASKIEREN UND ZU E PACKEN
          OR        E
          LD        B,3                 ; TRENNE BEIDE JUMPERFELDER
JUMPI1:   RRA
          RL        D
          RRA
          RL        E
          DJNZ      JUMPI1
          POP       HL                  ; HOLE DECODER TABELLE
          PUSH      HL
          LD        B,0
          LD        A,D
          AND       00000111B
          LD        C,A
          ADD       HL,BC
          LD        D,(HL)
          POP       HL                  ; HOLE DECODER TABELLE
          LD        A,E
          AND       00000111B
          LD        C,A
          ADD       HL,BC
          LD        A,(HL)
          RET

UDTAB:    DEFB      6,8,12,14 ; DECODIER TABELLE FUER UNIO JUMPER
          DEFB      10,14,14,14

PDTAB:    DEFB      0,0,0,2             ; DECODIER TABELLE FUER PROF JUMPER
          DEFB      0,3,4,1

UATAB:    DEFB      0BH,0CH,0EH
          DEFB      0AH,0DH
          DEFB      0CH,0FH

PATAB:    DEFB      080H,010H,020H
          DEFB      000H,090H
          DEFB      010H,0A0H

; ES FOLGEN UNIO TREIBER-ROUTINEN

UNIOINIT:
                                        ; DIESE ROUTINE WIRD BEI INITIALISIERUNG DES MONITORS
                                        ; AUFGERUFEN. STROBE UND INIT FUER UNIO-CENTRONICS
                                        ; WURDEN VON INIT SCHON AUF HIGH GESETZT.
                                        ; UNIOINIT LIEST DIE BEIDEN SIO-BAUDRATEN-JUMPER EIN
                                        ; UND INITIALISIERT BEIDE SIO- UND DEN STI KANAL.

          LD        HL,UATAB  ; LESE UNIO BAUD JUMPER
          LD        BC,UDTAB
          LD        E,CONTR
          LD        D,STAT
          CALL      JUMPIN
          LD        (SIOBBAUD),A
          LD        A,D
          LD        (SIOABAUD),A

          LD        A,(STIBAUD)         ; INITIALISIERE STI
          CALL      STINIT
          LD        A,(SIOABAUD)
          CALL      SAINIT
          LD        A,(SIOBBAUD)
          CALL      SBINIT
          RET



; STI INITIALISIEREN, IN AKKU STEHT NUMMER FUER BAUDRATE
; FALLS OBERE 4 BIT VON AKKU .NE. 0 DANN WIRD BAUDRATE FUER
; RECEIVER UND TRANSMITTER GETRENNT EINGESTELLT

STINIT:
          PUSH      AF                  ; RETTE AKKU
          AND       0FH                 ; NUR TRANSMITTER BAUDRATE
          CALL      STITINIT
          POP       AF                  ; JETZT RECEIVER BAUDRATE
          LD        B,A
          AND       0F0H                ; WENN OBERES HALBBYTE = 0
          JR        Z,STINIT1           ; DANN GLEICHE BAUDRATE
          LD        A,B
          AND       0FH                 ; 38400 BAUD NUR AUF BEIDEN KANAELEN
          JR        Z,STINIT2           ; GLEICHZEITIG MOEGLICH
          LD        A,B
          RRA
          RRA
          RRA
          RRA
STINIT3:AND         0FH
          CALL      STIRINIT
          RET
STINIT1:LD          A,B
          JR STINIT3                    ; BEIDE KANAELE GLEICHE BAUDRATE
STINIT2:XOR         A
          JR STINIT3                    ; BEIDE KANAELE 38400 BAUD

STITINIT:
          LD        HL,SERTAB ; ZEIGER FUER TABELLE BERECHNEN
          LD        C,A
          LD        B,0
          ADD       HL,BC
          ADD       HL,BC
          LD        A,2                 ; POINTER AUF TIMER C DATA
          OUT       (STI8),A
          LD        A,(HL)              ; TIMER C DATA
          OUT       (STI0),A
          INC       HL
          LD        A,7                 ; TIMER C UND D CONTROL
          OUT       (STI8),A
          LD        A,(HL)              ; PRESCALE
          AND       0F0H                ; NUR OBERES HALBBYTE
          LD        B,A
          IN        A,(STI0)  ; TIMER C CONTROL LOESCHEN
          AND       0FH
          OR        B
          OUT       (STI0),A
          RET

STIRINIT:
          LD        HL,SERTAB
          LD        C,A
          LD        B,0                 ; ZEIGER FUER TABELLE BERRECHNEN
          ADD       HL,BC               ; 2 EINTRAEGE PRO WERT
          ADD       HL,BC
          LD        A,1                 ; POINTER AUF TIMER D DATA
          OUT       (STI8),A
          LD        A,(HL)              ; TIMER D DATA
          OUT       (STI0),A
          INC       HL
          LD        A,7                 ; TIMER C UND D CONTROL
          OUT       (STI8),A
          LD        A,(HL)              ; PRESCALE
          AND       0FH                 ; NUR UNTERES HALBBYTE
          LD        B,A
          IN        A,(STI0)  ; ALTE TIMER C UND D CONTROL DATEN
          AND       0F0H                ; TIMER D CONTROL LOESCHEN
          OR        B                   ; NEUES TIMER D CONTROL EINTRAGEN
          OUT       (STI0),A
          LD        A,C
          OR        A
          LD        A,10001000B         ; USART CONTROL: 8 DATA BIT, NO PAR, 1 STOP
          JR        NZ,STINIT4
          AND       01111111B ; SCALE/1 BEI 38.4 BAUD
STINIT4:OUT         (STIC),A
          LD        A,1
          OUT       (STID),A  ; RECEIVER ENABLE
          LD        A,95H
          OUT       (STIE),A  ; TRANSMITTER ENABLE
          RET



; SIO A INITIALISIERUNG, IN AKKU STEHT NUMMER FUER BAUDRATE

SAINIT:
          LD        HL,SERTAB
          LD        E,A
          LD        D,0                 ; ZEIGER FUER TABELLE BERRECHNEN
          ADD       HL,DE               ; 2 EINTRAEGE PRO WERT
          ADD       HL,DE
          LD        A,(HL)              ; TIMER B DATA
          OUT       (STIA),A
          INC       HL
          LD        A,(HL)              ; PRESCALE
          AND       0FH                 ; NUR UNTERES HALBBYTE
          LD        B,A
          IN        A,(STI9)  ; ALTE TIMER A UND B CONTROL DATEN
          AND       0F0H                ; TIMER B CONTROL LOESCHEN
          OR        B                   ; NEUE TIMER B CONTROL DATEN
          OUT       (STI9),A
          LD        HL,SIOTAB ; TABELLE FUER SIO INITIALISIERUNG
          LD        B,(HL)              ; TABELLEN LAENGE
          INC       HL
          LD        C,SIOAC
          OTIR                         ; TABELLE AN SIO UEBERGEBEN
          LD        A,E
          OR        A
          LD        A,01000100B         ; SIO WR-REG.4: CLOCK/16, 1 STOP, NO PAR.
          JR        NZ,SAINIT1
          AND       10111111B ; CLOCK/1 BEI 38.4 BAUD
SAINIT1:OUT         (SIOAC),A
          RET



; SIO B INITIALISIERUNG, IN AKKU STEHT NUMMER FUER BAUDRATE

SBINIT:
          LD        HL,SERTAB
          LD        E,A
          LD        D,0                 ; ZEIGER FUER TABELLE BERRECHNEN
          ADD       HL,DE               ; 2 EINTRAEGE PRO WERT
          ADD       HL,DE
          LD        A,(HL)              ; TIMER A DATA
          OUT       (STIB),A
          INC       HL
          LD        A,(HL)              ; PRESCALE
          AND       0F0H                ; NUR OBERES HALBBYTE
          LD        B,A
          IN        A,(STI9)  ; ALTE TIMER A UND B CONTROL DATEN
          AND       0FH                 ; TIMER A CONTROL LOESCHEN
          OR        B                   ; NEUE TIMER A CONTROL DATEN
          OUT       (STI9),A
          LD        HL,SIOTAB ; TABELLE FUER SIO INITIALISIERUNG
          LD        B,(HL)              ; TABELLEN LAENGE
          INC       HL
          LD        C,SIOBC
          OTIR                         ; TABELLE AN SIO UEBERGEBEN
          LD        A,E
          OR        A
          LD        A,01000100B         ; SIO WR-REG.4: CLOCK/16, 1 STOP, NO PAR.
          JR        NZ,SBINIT1
          AND       10111111B ; CLOCK/1 BEI 38.4 BAUD
SBINIT1:OUT         (SIOBC),A
          RET



; STI OUT

STOUT:    CALL      STOST               ; BEREIT ?
          JR        Z,STOUT
          LD        A,C
          OUT       (STIF),A
          RET



; STI OUT STATUS

STOST:    IN        A,(STIE)
          AND       10000000B
          RET       Z
          OR        0FFH
          RET



; STI IN

STIN:     CALL      STIST
          JR        Z,STIN
          IN        A,(STIF)
          RET



; STI INPUT STATUS

STIST:    IN        A,(STID)
          AND       10000000B
          RET       Z
          OR        0FFH
          RET



; SIO A OUT

SAOUT:    CALL      SAOST
          JR        Z,SAOUT             ; NOCH NICHT BEREIT
          LD        A,C
          OUT       (SIOAD),A ; ZEICHEN SENDEN
          RET



; SIO A OUT STATUS

SAOST:    IN        A,(SIOAC) ; LESE STATUS
          AND       00000100B
          RET       Z
          OR        0FFH
          RET



; SIO A IN

SAIN:     CALL      SAIST
          JR        Z,SAIN              ; NOCH KEIN ZEICHEN EMPFANGEN
          IN        A,(SIOAD)
          RET



; SIO A IN STATUS

SAIST:    IN        A,(SIOAC) ; LESE STATUS
          AND       00000001B
          RET       Z
          OR        0FFH
          RET



; SIO B OUT

SBOUT:    CALL      SBOST
          JR        Z,SBOUT             ; NOCH NICHT BEREIT
          LD        A,C
          OUT       (SIOBD),A ; ZEICHEN SENDEN
          RET



; SIO B OUT STATUS

SBOST:    IN        A,(SIOBC) ; LESE STATUS
          AND       00000100B
          RET       Z
          OR        0FFH
          RET



; SIO B IN

SBIN:     CALL      SBIST
          JR        Z,SBIN              ; NOCH KEIN ZEICHEN EMPFANGEN
          IN        A,(SIOBD)
          RET



; SIO B IN STATUS

SBIST:    IN        A,(SIOBC) ; LESE STATUS
          AND       00000001B
          RET       Z
          OR        0FFH
          RET



; CENTRONICS 1 OUT

C1OUT:    CALL      C1OST               ; BEREIT FUER NAECHSTES ZEICHEN?
          JR        Z,C1OUT
          LD        A,C
          OUT       (CENT1),A
          LD        A,4                 ; /STB1 = LOW
          OUT       (CONTR),A
          LD        A,5                 ; /STB1 = HIGH
          OUT       (CONTR),A
          LD        A,C                 ; GESENDETES ZEICHEN IN A
          RET



; CENTRONICS 1 OUT STATUS

C1OST:    IN        A,(STAT)  ; CENTRONICS 1 STATUS
          CPL
          AND       01000000B
          RET       Z
          OR        0FFH
          RET



; CENTRONICS 2 OUT

C2OUT:    CALL      C2OST               ; BEREIT FUER NAECHSTES ZEICHEN?
          JR        Z,C2OUT
          LD        A,C
          OUT       (CENT2),A
          LD        A,6                 ; /STB2 = LOW
          OUT       (CONTR),A
          LD        A,7                 ; /STB2 = HIGH
          OUT       (CONTR),A
          LD        A,C                 ; GESENDETES ZEICHEN IN A
          RET



; CENTRONICS 2 OUT STATUS

C2OST:    IN        A,(STAT)  ; CENTRONICS 2 STATUS
          CPL
          AND       10000000B
          RET       Z
          OR        0FFH
          RET




SERTAB:
          DEFB      8,11H               ; 38400    BAUD
          DEFB      96,33H              ;   50   BAUD
          DEFB      64,33H              ;   75   BAUD
          DEFB      175,11H             ;  110   BAUD
          DEFB      143,11H             ;  134.5 BAUD
          DEFB      128,11H             ;  150   BAUD
          DEFB      64,11H              ;  300   BAUD
          DEFB      32,11H              ;  600     BAUD
          DEFB      16,11H              ; 1200   BAUD
          DEFB      11,11H              ; 1745   BAUD
          DEFB      8,11H               ; 2400   BAUD
          DEFB      5,11H               ; 3840   BAUD
          DEFB      4,11H               ; 4800     BAUD
          DEFB      3,11H               ; 6400   BAUD
          DEFB      2,11H               ; 9600   BAUD
          DEFB      1,11H               ; 19200   BAUD



SIOTAB:
          DEFB      SIOTAL-SIOTAB-1
          DEFB      1,0
          DEFB      3,11100001B
          DEFB      5,11101010B
          DEFB      4

SIOTAL:   EQU       $



;-------------------------------------------------ENDE DER E/A-ROUTINEN-----



CONST:
                                        ; VERTEILER FUER CONSOLEN STATUS
                                        ; DIE ROUTINEN MUESSEN A=FF UND KEIN ZERO-FLAG SETZEN
                                        ; FALLS EIN ZEICHEN DA IST SONST AKKU= 0 UND ZERO-FLAG

          LD        A,(IO_JUMPERBYTE) ; LESE JUMPERBYTE EIN
          CALL      VERTEILER
          DEFW      GRAFIST
          DEFW      SOFTIST
          DEFW      USER1IST
          DEFW      USER2IST
          DEFW      DUMMYIST



CONIN:
                                        ; VERTEILER FUER CONSOLEN EINGABE
                                        ; DIE ROUTINE MUSSEN AUF EIN ZEICHEN VON DER KONSOLE WARTEN
                                        ; UND DIESES IM AKKU UEBERGEBEN
                                        ; ALLE ANDEREN REGISTER BLEIBEN UNVERAENDERT

          LD        A,(IO_JUMPERBYTE)
          CALL      VERTEILER
          DEFW      GRAFIN
          DEFW      SOFTIN
          DEFW      USER1IN
          DEFW      USER2IN
          DEFW      DUMMYIN



CONOUT:
                                        ; VERTEILER FUER CONSOLEN AUSGABE
                                        ; DAS ZEICHEN IN REG C. WIRD VON DEN ROUTINEN AUSGEGEBEN
                                        ; UND IN AKKU KOPIERT, ALLE ANDEREN REGISTER BLEIBEN UNVERAENDERT

          LD        A,(IO_JUMPERBYTE)
          CALL      VERTEILER
          DEFW      GRAFOUT
          DEFW      SOFTOUT
          DEFW      USER1OUT
          DEFW      USER2OUT
          DEFW      DUMMYOUT



VERTEILER:
                                        ; VERZEIGT AUF EINE DER ADRESSEN DIE DER RETURNADRESSE FOLGEN

          EX        (SP),HL             ; LEGE RETURNADRESSE IN HL
VERTEILER1:
          DEC       A                   ; WAR AKKU NULL?
          JP        M,VERTEILER2        ; DANN ZEIGT HL AUF DIE RICHTIGE RETURN ADR.
          INC       HL                  ; ANSONSTEN EINE ADRESSE WEITER
          INC       HL
          JR VERTEILER1
VERTEILER2:
          LD        A,(HL)              ; LADE ADRESSE DER ROUTINE IN HL
          INC       HL
          LD        H,(HL)
          LD        L,A
          EX        (SP),HL             ; LADE ALTES HL UND LEGE ADRESSE DER ROUTINE
                                        ; AUF DEN STACK
          RET                           ; SPRINGE IN DIE RICHTIGE ROUTINE



DUMMYIST:
          LD        A,0FFH
          OR        A
          RET



DUMMYIN:
          LD        A,'7'
          RET



DUMMYOUT:
          LD        A,C
          RET



BREAK:
                                        ; PRUEFT OB EIN ZEICHEN EINGELESEN WURDE

          CALL      CS
          JP        Z,FRET
          CALL      CI                  ; LESE ZEICHEN
          AND       7FH
          CP        1BH                 ; GLEICH ESCAPE
          JP        Z,SRET              ; JA ENDE
BREAK1:   CALL      CS                  ; WARTE AUF NEUES ZEICHEN
          JR        Z,BREAK1
          CALL      CI                  ; LESE NEUES ZEICHEN
          AND       7FH
          CP        1BH
          JP        Z,SRET              ; WAR BREAK
          JP        FRET                ; WAR ETWAS ANDERES



CNVBN:
          LD        A,C
          SUB       '0'
          CP        0AH
          RET       M
          SUB       7
          RET



SOUT:                                   ; GEBE STRING AUS
                                        ; ANFANG IN HL, ENDE DURCH 24HEX
          LD        A,(HL)              ; LESE ZEICHEN
          CP        '$'                 ; STRING ENDE
          RET       Z                   ; RETURN WENN
          LD        C,A                 ; IN C FUER AUSGABE
          CALL      CO                  ; GEBE ZEICHEN AUF CONSOLE
          INC       HL                  ; ZEIGER AUF NAECHSTES ZEICHEN
          JR SOUT                       ; WIEDERHOLE



CROUT:
          PUSH      BC
          LD        C,0DH
          CALL      CECHO
          POP       BC
          RET

CECHO:     PUSH      BC
          LD        B,C
          LD        A,1BH
          CP        B
          JR        NZ,ECH05
          LD        C,'$'
ECH05:    CALL      CO
          LD        A,0DH
          CP        B
          JR        NZ,ECH10
          LD        C,0AH
          CALL      CO
ECH10:    POP       BC
          LD        A,C
          RET



CERROR:
          LD        HL,SYNERRTXT
          CALL      SOUT
          JP        GETCM

SYNERRTXT:
          DEFM      " What?",BELL,0DH,0AH,'$'

FRET:
          SCF
          CCF
          RET

GETCH1:                                 ; LESE EIN ZEICHEN VON KONSOLE, UND WANDLE IN GROSSBUCHSTABEN
          CALL      CI
          AND       7FH
          LD        C,A
          CP        'a'
          RET       C
          SUB       'a'-'A'
          LD        C,A
          RET



GETCH:
          CALL      CI
          AND       7FH
          LD        C,A
          RET



GETHX:
          PUSH      HL
          LD        HL,0
          LD        E,0
L0228:
          CALL      GETCH1
          LD        C,A
          CALL      VALDL
          JP        NC,L0241
          CALL      CECHO
          LD        D,C
          PUSH      HL
          POP       BC
          POP       HL
          LD        A,E
          OR        A
          JP        NZ,SRET
          JP        Z,FRET
L0241:
          CALL      VALDG
          JP        NC,L0228
          CALL      CECHO
          CALL      CNVBN
          LD        E,0FFH
          ADD       HL,HL
          ADD       HL,HL
          ADD       HL,HL
          ADD       HL,HL
          LD        B,0
          LD        C,A
          ADD       HL,BC
          JP        L0228



GETDEZ:
                                        ; LESE DEZIMALZAHLEN NACH HL
                                        ; ALS TRENNZEICHEN WERDEN '/',':' UND <CR> ERKANNT
                                        ; TRENNZEICHEN WIRD IN AKKU UEBERGEBEN

          LD        B,0
          LD        HL,0                ; LOESCHE AKKU
GETDEZ1:CALL        GETCH1              ; LESE ZEICHEN
          CP        '/'
          JR        Z,GETDEZ2
          CP        ':'
          JR        Z,GETDEZ2
          CP        0DH
          JR        Z,GETDEZ2
          SUB       '0'                 ; ZAHL ?
          JR        C,GETDEZ1
          CP        0AH
          JR        NC,GETDEZ1
          LD        C,A
          ADD       HL,HL
          ADD       HL,HL
          ADD       HL,HL
          ADD       HL,HL
          ADD       HL,BC
          LD        A,'0'               ; GEBE ZAHL AUS
          ADD       A,C
          LD        C,A
          CALL      CECHO
          JR GETDEZ1
GETDEZ2:LD          C,A
          CALL      CECHO
          LD        A,C
          RET



DEZHEX:
                                        ; WANDELT DEZIMAL ZAHL IM AKKU IN HEXWERT UM
          PUSH      BC
          CP        0                   ; IST SCHON 0?
          JR        Z,DEZHEX1
          LD        B,0
DEZHEX2:INC         B
          DEC       A
          DAA
          JP        NZ,DEZHEX2
          LD        A,B
DEZHEX1:POP         BC
          RET



GETNM:
          LD        L,3
          LD        A,C
          AND       3
          RET       Z
          LD        H,A
L025E:
          CALL      GETHX
          JP        NC,CERROR
          PUSH      BC
          DEC       L
          DEC       H
          JP        Z,L0273
          LD        A,D
          CP        0DH
          JP        Z,CERROR
          JP        L025E
L0273:
          LD        A,D
          CP        0DH
          JP        NZ,CERROR
          LD        BC,0FFFFH
          LD        A,L
          OR        A
          JP        Z,L0286
L0281:
          PUSH      BC
          DEC       L
          JP        NZ,L0281
L0286:
          POP       BC
          POP       DE
          POP       HL
          CALL      HILO
          JP        NC,L0291
          LD        D,H
          LD        E,L
L0291:
          EX        (SP),HL
          PUSH      DE
          PUSH      BC
          PUSH      HL
L0295:
          DEC       A
          RET       M
          POP       HL
          EX        (SP),HL
          JP        L0295
HILO:
          PUSH      BC
          LD        B,A
          PUSH      HL
          LD        A,D
          OR        E
          JP        Z,L02BD
          INC       HL
          LD        A,H
          OR        L
          JP        Z,L02BD             ; 02BDH
          POP       HL
          PUSH      DE
          LD        A,0FFH
          XOR       D
          LD        D,A
          LD        A,0FFH
          XOR       E
          LD        E,A
          INC       DE
          LD        A,L
          ADD       A,E
          LD        A,H
          ADC       A,D
          POP       DE
          LD        A,B
          POP       BC
          RET
L02BD:
          POP       HL
          LD        A,B
          POP       BC
          JP        SRET



PDEC:
                                        ; GEBE HL REGISTER AL DEZIMALZAHL AUS
          LD        BC,TABLE10
          LD        DE,-10000
PNEXT:    LD        A,'0'-1
PDECL:    PUSH      HL
          INC       A
          ADD       HL,DE
          JR        NC,STOPLOOP
          INC       SP
          INC       SP
          JR PDECL
STOPLOOP:
          PUSH      DE
          PUSH      BC
          LD        C,A
          CALL      CECHO
          POP       BC
          POP       DE
NEXTDIGIT:
          POP       HL
          LD        A,(BC)
          LD        E,A
          INC       BC
          LD        A,(BC)
          LD        D,A
          INC       BC
          LD        A,E
          OR        D
          JR        NZ,PNEXT
          RET

TABLE10:
          DEFW      -1000,-100,-10,-1,0



DEZOUT:                                 ; WANDLE AKKU IN DEZIMALZAHL UND GEBE AKKU AUS
          OR        A                   ; AKKU NULL
          JR        Z,DEZOUT2           ; DANN IST SCHON ALLES OK
          LD        B,A
          XOR       A
DEZOUT1:
          INC       A
          DAA
          DJNZ      DEZOUT1
DEZOUT2:
          CALL      NMOUT
          RET


HLOUT:
          LD        A,H
          CALL      NMOUT
          LD        A,L

NMOUT:
          PUSH      HL
          PUSH      BC
          PUSH      AF
          RRCA
          RRCA
          RRCA
          RRCA
          AND       0FH
          LD        C,A
          CALL      PRVAL
          CALL      CECHO
          POP       AF
          AND       0FH
          LD        C,A
          CALL      PRVAL
          CALL      CECHO
          POP       BC
          POP       HL
          RET



SET_SOFT_BAUD:
                                        ; SETZE DIE BAUDRATE DER SOFT-SCHNITTSTELLE
                                        ; ENTSPRECHEND DER STELLUNG VON BAUD_JUMPERBYTE
                                        ; NEHME DAZU DEN ENTSPRECHENDEN WERT AUS
                                        ; SOFT_BAUD_TAB UND KORRIGIERE  IHN MIT DER
                                        ; SYSTEMFREQUENZ

          LD        A,(BAUD_JUMPERBYTE) ; STELLUNG VON BAUD_JUMPER
SET_DUPLEX_BAUD:
                                        ; EINSPRUNG ZUM NEU SETZEN
          LD        H,0                 ; SOFT_BAUD_TAB EINTRAG
          LD        L,A
          LD        DE,SOFT_BAUD_TAB
          ADD       HL,HL               ; MAL ZWEI
          ADD       HL,DE
          LD        E,(HL)              ; SOFT_BAUD_TAB-EINTRAG IN DE
          INC       HL
          LD        D,(HL)
          LD        BC,(SYSTEMTAKT)     ; SYSTEMTAKT IN BC
          CALL      MULTIP              ; MULTIPLIZIERE
          LD        (SOFTVERZ),HL       ; UND TEILE DURCH 65536
                                        ; DA NUR DIE OBEREN 16 BITS GENUTZT WERDEN
          RET



SET_SIMPLEX_BAUD:
                                        ; BERRECHNE DIE VERZOEGERUNGSZEIT FUER DIE SIMPLEX SCHNITTSTELLE
                                        ; DER WERT IM AKKU GIBT DEN LISTEN-EINTRAG DER SOFT_BAUD_TAB AN

          LD        H,0                 ; SOFT_BAUD_TAB EINTRAG
          LD        L,A
          LD        DE,SOFT_BAUD_TAB
          ADD       HL,HL               ; MAL ZWEI
          ADD       HL,DE
          LD        E,(HL)              ; TABELLEN EINTRAG IN DE
          INC       HL
          LD        D,(HL)
          LD        BC,(SYSTEMTAKT)     ; KORRIGIERE MIT SYSTEMTAKT
          CALL      MULTIP              ; MULTIPLIZIERE
          LD        (SOFTPRNTVERZ),HL   ; TEILE DURCH 65536 UND LEGE AB
          RET



MULTIP:
                                        ; MULTIPLIZIERT BC*DE 32BIT ERGEBNIS IN HLDE
          LD        HL,0                ; INITIALISIERE HL
          LD        A,-16               ; SCHLEIFENZ[HLER
MUL7:     ADD       HL,HL               ; SCHIEBE DEHL UM 1BIT
          EX        DE,HL               ; NACH LINKS
          ADC       HL,HL               ; LSB=0
          EX        DE,HL
          JR        NC,MUL2             ; 1AUS DE
          ADD       HL,BC               ; DANN ADDIERE BC
          JR        NC,MUL2             ; ]BERTRAG ENTSTANDEN?
          INC       DE                  ; DANN DE EINS HOEHER
MUL2:     INC       A                   ; 16 DURCHLAEUFE?
          JP        M,MUL7              ; SPRUNG WENN NEIN
          EX        DE,HL               ; DIE HOEHEREN BITS IN HL
          RET



PRVAL:
          PUSH      AF
          LD        A,C
          OR        0F0H
          DAA
          ADD       A,0A0H
          ADC       A,040H
          LD        C,A
          POP       AF
          RET



RWINP:
                                        ; LIEST DMA ADRESSE UND ANZAHL DER SEKTOREN EIN
          CALL      GETHX               ; LESE DMA ADRESSE
          JP        NC,CERROR
          LD        A,D                 ; KEIN CR
          CP        0DH
          JP        Z,CERROR             ; SPRUNG WENN DOCH
          LD        (DMAADR), BC                   ; ABSPEICHERN
          CALL      GETHX               ; LESE ANZAHL DER SEKTOREN
          JP        NC,CERROR
          LD        A,D
          CP        0DH                 ; MUSS CR SEIN
          JP        NZ,CERROR
          LD        A,C
          LD        (SECTCNT),A         ; ABSPEICHERN
          RET



PRINT_DRIVE:
                                        ; GIBT DEN LAUFWERK BUCHSTABEN UND EIN BLANK AUF DER
                                        ; KONSOLE AUS
          LD        A,(UNIT)  ; WELCHES LAUFWERK?
          AND       03H                 ; MASKIERE OBER 6 BITS
          ADD       A,'A'               ; WANDLE IN ASCII
          LD        C,A
          CALL      CO
          LD        C,' '
          CALL      CO
          RET



REGDS:
          LD        HL,RTAB
L02E9:
          LD        C,(HL)
          LD        A,C
          OR        A
          JP        NZ,L02F3
          CALL      CROUT
          RET
L02F3:
          CP        'a'                 ; SOLL NEUE ZEILE ANFANGEN?
          JR        NZ,REGDS1           ; SPRUNG WENN NEIN
          PUSH      AF
          PUSH      BC
          CALL      CROUT
          POP       BC
          POP       AF
REGDS1:
          CALL      CECHO
          LD        C,'='
          CALL      CECHO
          INC       HL
          LD        E,(HL)
          LD        D,(REGS AND 0FF00H) SHR 8
          INC       HL
          LD        A,(DE)
          CALL      NMOUT
          LD        A,(HL)
          OR        A
          JP        Z,L030E
          DEC       DE
          LD        A,(DE)
          CALL      NMOUT
L030E:
          LD        C,' '
          CALL      CECHO
          INC       HL
          JP        L02E9



RGADR:
          LD        HL,RTAB
          LD        DE,3                ; LAENGE DER TABELLEN EINTRAEGE
L031D:
          LD        A,(HL)
          OR        A
          JP        Z,CERROR
          CP        C
          JP        Z,L032A
          ADD       HL,DE
          JP        L031D
L032A:
          INC       HL
          LD        B,H
          LD        C,L
          RET

;-----------------------------------------------REGISTER ZURUECKLADEN------

RSTTF:
          DI
          LD        SP,MSTAK
          POP       BC                  ; LADE I UND R REGISTER
          LD        A,C
          LD        R,A
          LD        A,B
          LD        I,A
          EXX
          EX        AF,AF'              ; ERST ZWEITREGISTERSATZ LADEN
          POP       HL
          POP       DE
          POP       BC
          POP       AF
          EX        AF,AF'
          EXX                           ; JETZT NORMALER REGISTERSATZ
          POP       IY
          POP       IX
          POP       DE
          POP       BC
          POP       AF
          LD        SP,(SSAVE)
          LD        HL,(PSAVE)
          PUSH      HL
          LD        HL,(LSAVE)
          EI
;----------------------------------------ENDE REGISTER ZURUECKLADEN--------
          RET



SETCMDT:
                                        ; NEHME WERTE AUS TEST_TYPE UND TEST_MSEK
                                        ; UND TRAGE SIE IN CMDTAB EIN

          LD        A,(TEST_MSEK)       ; ANZAHL DER SEKTOREN/SPUR
          LD        (EOT),A
          LD        A,(TEST_TYPE)       ; LADE TEST_TYPE
          LD        C,A                 ; UND RETTE IN C
          AND       40H                 ; MASKIERE UND
          LD        (CMDTAB),A          ; SETZE MFM BIT IN CMDTAB
          LD        A,C
          AND       0FH                 ; SETZE SEKTORGROESSE
          LD        (SECSZ),A
          OR        A
          LD        A,0FFH              ; SETZE DTL AUF 80 BEI 128 BYTES/SEKTOR
          JR        NZ,CMDS1            ; SONST AUF 0FFH
          LD        A,80H
CMDS1:    LD        (DTLL),A
          LD        A,C                 ; SETZE GAP-LAENGE IN ABHAENGIGKEIT
          AND       0FH                 ; VON DER SEKTORGROESSE
          LD        C,A
          LD        B,0
          LD        HL,GAPTAB
          ADD       HL,BC
          LD        A,(HL)
          LD        (GAPLL),A
          RET

GAPTAB:                                 ; DIESE TABELLE GIBT DIE GAPLAENGE FUER JEDE
                                        ; SEKTORGROESE AN
          DEFB      007H                ; GAPLAENGE FUER  128 BYTES/SEKTOR
          DEFB      00EH                ; GAPLAENGE FUER  256 BYTES/SEKTOR
          DEFB      01BH                ; GAPLAENGE FUER  512 BYTES/SEKTOR
          DEFB      035H                ; GAPLAENGE FUER 1024 BYTES/SEKTOR



SRET:
          SCF
          RET



VALDG:
          LD        A,C
          CP        '0'
          JP        M,FRET
          CP        '9'
          JP        M,SRET
          JP        Z,SRET
          CP        'A'
          JP        M,FRET
          CP        'G'
          JP        P,FRET
          JP        SRET



VALDL:
          LD        A,C
          CP        ','
          JP        Z,SRET
          CP        0DH
          JP        Z,SRET
          CP        ' '
          JP        Z,SRET
          JP        FRET



DISP_TIME:
                                        ; GEBE UHRZEIT UND DATUM AUF DEN BILDSCHIRM
          CALL      READ_PHYS_TIME      ; LESE ZEIT AUS UHR
          LD        HL,TIMTXT1          ; DATUM TEXT AUS
          CALL      SOUT
          LD        A,(PHYS_TIME+4)     ; MONAT
          RRCA
          RRCA
          RRCA
          RRCA
          AND       0FH
          DEC       A
          CP        12                  ; MONAT UNGUELTIG
          JR        C,DISP_TIME1
          XOR       A                   ; DANN LOESCHE AKKU
DISP_TIME1:
          LD        L,A
          LD        H,0
          ADD       HL,HL
          ADD       HL,HL
          LD        BC,MONTXT
          ADD       HL,BC
          CALL      SOUT
          LD        C,' '
          CALL      CECHO
          LD        A,(PHYS_TIME+3)     ; TAG
          CALL      NMOUT
          LD        C,' '               ; GEBE 19 AUS
          CALL      CECHO
          LD        A,19H
          CALL      NMOUT
          LD        A,(SHIFT_CONT+4) ; JAHRESZAHL
          AND       1FH                 ; NUR DIE UNTEREN 5 BIT
          LD        B,80                ; ADDIERE 80 DAZU
          ADD       A,B
          CALL      DEZOUT              ; GEBE AUS

          LD        HL,TIMTXT2          ; GEBE TIME AUS
          CALL      SOUT
          LD        A,(PHYS_TIME+2)     ; STUNDE
          CALL      NMOUT
          LD        C,':'
          CALL      CECHO
          LD        A,(PHYS_TIME+1)     ; MINUTE
          CALL      NMOUT
          LD        C,':'
          CALL      CECHO
          LD        A,(PHYS_TIME)       ; SEKUNDE
          CALL      NMOUT
          CALL      CROUT
          LD        A,(IO_JUMPERBYTE) ; IST GRIP ALS KONSOLE DEFINIERT?
          OR        A
          RET       NZ                  ; RETURN WENN NICHT
          LD        HL,SETTT  ; SONST, SETZE GRIP-UHR
          CALL      SOUT
          LD        A,(PHYS_TIME+2)
          ADD       A,20H
          LD        C,A
          CALL      CECHO
          LD        A,(PHYS_TIME+1)
          ADD       A,20H
          LD        C,A
          CALL      CECHO
          LD        A,(PHYS_TIME)
          ADD       A,20H
          LD        C,A
          CALL      CECHO
          RET

SETTT:    DEFM      27,27,'U$'
TIMTXT1:  DEFM      0DH,0AH,'              Date  $'
TIMTXT2:  DEFM      0DH,0AH,'              Time  $'
MONTXT:   DEFM      'Jan$'
          DEFM      'Feb$'
          DEFM      'Mar$'
          DEFM      'Apr$'
          DEFM      'May$'
          DEFM      'Jun$'
          DEFM      'Jul$'
          DEFM      'Aug$'
          DEFM      'Sep$'
          DEFM      'Oct$'
          DEFM      'Nov$'
          DEFM      'Dec$'



;************************************************************

;ES FOLGEN NUN SERVICE ROUTINE FUER BOOT ROUTINE

;************************************************************



SETSEC_CNT:
                                        ; SETZE ANZAHL DER ZU UEBERTRAGENDEN SEKTOREN
          LD        A,C
          LD        (SECTCNT),A
          RET

SELDSK:
                                        ; SETZT UNIT BYTE
          LD        A,C
          LD        (UNIT),A
          RET

SETTRK:
                                        ; SETZT TRACK BYTE
          LD        A,C
          LD        (TRACK),A
          RET
SETSEC:
                                        ; SETZT SECTOR BYTE
          LD        A,C
          LD        (SECTOR),A
          RET

SETDMA:
          LD        (DMAADR), BC
          RET

GETMINIMAX:
                                        ; WENN AKKU=0 DANN MAXI
                                        ; WENN AKKU=0FFH DANN MINI
          LD        A,(TEST_TYPE)
          AND       20H
          RET       Z
          LD        A,0FFH
          RET



;************************************************************

;ES FOLGEN NUN DISK ROUTINEN FUER UPD 765

;************************************************************



BOOTERR:
                                        ; GEBE FEHLERMELDUNG BEI BOOT AUS
                                        ; UND GEHE ZUM MONITOR ZURUECK
          LD        HL,BERMSG
          CALL      SOUT
          JP        CRGETCM

BERMSG:   DEFM      ' Can not boot',24H



SPECD:
                                        ; SETZT DISK PARAMETER FUER NON DMA BETRIEB
          LD        HL,(UNIT)
          PUSH      HL                  ; RETTE CMDTAB
          LD        HL,(SPECD_WORD)
          LD        A,1
          OR        H
          LD        H,A
          LD        BC,0303H
          LD        (UNIT),HL
          CALL      CMFD
          POP       HL
          LD        (UNIT),HL
          RET



FLOPPY_RESET:
                                        ; GEBE HARDWARE-RESET
                                        ; AUF FLOPPY-CONTROLER
          PUSH      BC
          LD        A,PAD_RESF OR 1
          OUT       (P_LS259),A
          LD        B,20
FLOPPY_RESET1:
          DJNZ      FLOPPY_RESET1
          LD        A,PAD_RESF
          OUT       (P_LS259),A
          POP       BC
          RET



INIFDC:
                                        ; SOFT RESET DES UPD 765
                                        ; FALS KEIN FLOPPY CONTROLLER VORHANDEN IST,
                                        ; WIRD DISKFLG AUF 00H GESETZT, SONST AUF FFH
          LD        A,0FFH              ; DEFAULT FUER FLOPPY-C DA
          LD        (DISKFLG),A
          LD        HL,0000H  ; SETZE ZAEHLER
INIFDC1:DEC         H                   ; ERNIEDRIGE ZAEHLER
          IN        A,(FDC)
          CP        80H                 ; REQUEST FOR MASTER
          RET       Z                   ; OK CONTROLLER DA
          IN        A,(FDD)             ; LESE DATEN
          LD        A,H                 ; IST ZAEHLER NULL
          OR        L
          JR        NZ,INIFDC1                    ; NEIN, NEUER VERSUCH
          LD        (DISKFLG),A         ; KEIN FLOPPYCONTROLLER DA, DISKFLG=00H
          RET



RECAL:
          XOR       A                   ; AKKU=0
          LD        (ALT_TRACK),A       ; VORSICHTSHALBER SPUR AUF NULL
          LD        B,4                 ; VIER VERSUCHE
RECAL2:   PUSH      BC
          CALL      RECAL1
          CALL      SENSD
          AND       10H                 ; TRACK NULL ERREICHT?
          POP       BC
          RET       NZ                  ; RUECKSPRUNG WENN EREICHT
          DJNZ      RECAL2
          RET



RECAL1:
          LD        BC,0207H
          CALL      MOTO
          JP        SENS



NODISK:   DEFM      0DH,0AH,BELL
          DEFM      ' Drive access not possible$'



DISKDA:
                                        ; GIBT MELDUNG AUS, WENN DISKZUGRIF OHNE KONTROLLER VERSUCHT WIRD
                                        ; UND KEHRT AUF DIE EINGABEEBENE ZURUECK
          LD        A,(DISKFLG)         ; LADE FLAG
          OR        A                   ; =NULL?
          RET       NZ                  ; ZURUECK ZUM RUFENDEN PROGRAMM
          LD        HL,NODISK ; GEBE MELDUNG AUS
          CALL      SOUT
          JP        CRGETCM             ; AUF KOMMANDOEBENE ZURUECK



READY_MASK:
                                        ; HOLT AUS READY_BYTE DIE WERTE FUER LW
                                        ; SCHON AUF READY GETESTET UND LW KANN READY LIEFERN
                                        ; ODER NICHT
          CALL      UNIT_MASK ; HOLE MASKE FUER EINGELOGGTES LW
          LD        A,(READY_BYTE)      ; UND MASKIERE READY_BYTE
          AND       B
          RET



UNIT_MASK:
                                        ; ERZEUGE AUS EINGELOGGTEM LW MASKE FUER OBER UND UNTERE 4 BIT
          LD        A,(UNIT)
          AND       00000011B
          INC       A
          LD        B,A
          LD        A,88H
UNIMASK:RLCA
          DJNZ      UNIMASK
          LD        B,A
          RET



SEEK3:
          CALL      UNIT_MASK
          LD        A,(SEEKNR)
          AND       B
          AND       0FH
          RET

SEEK:
          LD        HL,(UNIT)           ; LADE NEUES LAUFWERK UND NEUER TRACK
          LD        BC,(ALT_UNIT)       ; LADE ALTES LAUFWERK UND ALTER TRACK
          LD        A,B                 ; VERGLEICHE
          CP        H
          JR        NZ,SEEK4            ; SPRUNG WENN UNGLEICH
          LD        A,C
          CP        L
          RET       Z                   ; RETURN WENN KEIN SEEK NOTWENDIG
SEEK4:    LD        (ALT_UNIT),HL       ; ALTES:=NEUES
          IN        A,(P_IN_LS258_B)
          AND       MASK_MOT
          LD        A,PAD_MOTOR         ; AUFJEDEN FALL MOTOR JETZT EINSCHALTEN
          OUT       (P_LS259),A
          JR        Z,SEEK5             ; WENN MOTOR SCHON LIEF, DANN KEIN WARTEN
          LD        A,(STEP_WAIT)       ; LADE WARTEZEIT
SEEK6:    OR        A                   ; WENN WARTEZEIT NULL, DANN WEITER
          JR        Z,SEEK5
          DEC       A
          PUSH      AF
          LD        HL,2300
SEEK7:    DEC       HL
          LD        A,H
          OR        L
          JR        NZ,SEEK7
          POP       AF
          JR SEEK6
SEEK5:    CALL      SEEK3
          JR        Z,SEEK1
          LD        A,(TRACK)
          PUSH      AF
          ADD       A,A
          LD        (TRACK),A
SEEK1:
          LD        BC,030FH  ; SEEK TRACK
          CALL      MOTO
          CALL      SEEK3
          JR        Z,SEEK2
          POP       AF
          LD        (TRACK),A
SEEK2:
                                        ; SEEK FINISHD ?
SENS:     LD        BC,0108H  ; SENS DRIVE
          CALL      CMFD
          CALL      NEXT
          PUSH      AF                  ; SAVE RESULT
          CP        080H                ; INVALID COMMAND ?
          CALL      NZ,NEXT             ; NO => NEXT RESULT
          POP       AF                  ; FIRST RESULT
          AND       020H                ; ISOLIERE BIT 5
          JP        Z,SENS
          LD        A,PAD_MOTOR OR 80H ; SCHALTE MOTOR AUF JEDEN
          OUT       (P_LS259),A         ; FALL AB
          RET



RESULT:                                 ; FETCH RESULT OF READ WRITE OPERATION
                                        ; AND CHECK THEM FOR R/W ERRORS
                                        ; Z+A=00 IF NO ERRORS
                                        ; NZ,A=? IF ERRORS
          LD        B,006H              ; 7RESULTS
          CALL      NEXT
          LD        HL,REST             ; RESULT TABLE
          LD        (HL),A              ; STORE RESULT
          AND       0C0H                ; ERROR ?
          LD        C,A                 ; SAVE
RESLOP:   CALL      NEXT
          INC       HL
          LD        (HL),A              ; STORE RESULT
          DJNZ      RESLOP

          LD        A,PAD_READY         ; SCHALTE READY AUF JEDEN FALL WEG
          OUT       (P_LS259),A
          LD        A,PAD_MOTOR OR 80H ; SCHALTE MOTOR NACH DELAY AB
          OUT       (P_LS259),A

          LD        A,C                 ; RESTORE RESULT 0
          OR        A                   ; IN AKKU
          RET



READY_TEST:
                                        ; ERMITTELT, OB EIN LAUFWERK DAS READY-SIGNAL LIEFERN
                                        ; KANN UND SETZT ENTSPRECHEND DAS READY-BYTE

          CALL      SPEED_CONST         ; WARTE BIS DREHZAHL KONSTANT
          JR        NZ,RTST1            ; SPRUNG WENN DREHZAHL KONSTANT
          CALL      NRDYERR             ; GEBE FEHLERMELDUNG AUS UND LESE ZEICHEN
          JR        NZ,READY_TEST                 ; NOCH EIN VERSUCH
          JP        UMLEIT_GETCM        ; SONST ZURUECK
RTST1:    CALL      SENSD               ; LIEFERT LW READY?
          AND       20H
          PUSH      AF                  ; RETTE ZERO-FLAG
          CALL      UNIT_MASK ; TRAGE IN READY_BYTE EIN
          CPL
          LD        B,A                 ; RETTE MASKE
          POP       AF                  ; HOLE ZERO-FLAG
          LD        A,0FH               ; KEIN READY
          JR        Z,RTST2             ; SPRUNG WENN KEIN READY
          LD        A,0
RTST2:    OR        B
          LD        B,A                 ; SETZE READY_BYTE
          LD        A,(READY_BYTE)
          AND       B
          LD        (READY_BYTE),A
          RET



SPEED_CONST:
                                        ; WARTE BIS DREHZAHL KONSTANT, DANN RETURN MIT ZERO-FLAG=0
                                        ; WENN DREHZAHL NICHT KONSTANT WIRD DANN ZERO-FLAG=1

TOLERANZ: EQU        64                  ; TOLERANZ FUER DREHZAHL KONSTANT

          LD        BC,0204H  ; SELEKTIERE LAUFWERK
          CALL      CMFD
          LD        A,PAD_MOTOR         ; SCHALTE MOTOR EIN
          OUT       (P_LS259),A
          LD        DE,0                ; BESETZE VOR
          LD        B,10                ; ZEHN VERSUCHE
SPEEDC1:  EX          DE,HL               ; ADDIERE ZU DE TOLERANZ
          LD        DE,TOLERANZ
          ADD       HL,DE
          EX        DE,HL
          CALL      CDRIVE_SPEED        ; MESSE DREHZAHL
          JR        Z,SPEEDC3           ; ZURUECK WENN LAUFWERK STEHT
          EX        DE,HL               ; BILDE DIVERENZ ZU VORHER
          SBC       HL,DE
          LD        A,H
          CP        0                   ; IM TOLERANZBEREICH?
          JR        NZ,SPEEDC2                    ; SPRUNG WENN NEIN
          LD        A,L
          CP        TOLERANZ*2
          JR        NC,SPEEDC2                    ; SPRUNG WENN DREHZAHL NOCH NICHT KONSTANT
          CALL      CDRIVE_SPEED        ; WARTE NOCH ZWEI UMDREHUNGEN
          CALL      CDRIVE_SPEED

          CALL      NEXT                ; DESELEKTIERE LAUFWERK
          LD        A,PAD_MOTOR OR 80H
          OUT       (P_LS259),A
          LD        A,0FFH              ; ZURUECK MIT ZERO = 0
          OR        A
          RET

SPEEDC2:DJNZ        SPEEDC1             ; MAXIMAL 10 VERSUCHE
SPEEDC3:CALL        NEXT                ; DESELEKTIERE LAUFWERK
          LD        A,PAD_MOTOR OR 80H
          OUT       (P_LS259),A
          XOR       A                   ; SONST ZURUECK MIT ZERO=1
          RET



CDRIVE_SPEED:
                                        ; MESSE GESCHWINDIGKEIT DES LAUFWERKS
                                        ; WENN SICH DISKETTE NICHT DREHT IST DAS ZERO-FLAG GESETZT
                                        ; SONST ZERO-FLAG=0 UND GESCHWINDIGKEIT IN HL

          IN        A,(P_IN_LS258_A) ; LESE INDEX-SIGNAL
          AND       MASK_INDEX          ; UND MASKIERE
          JR        Z,DSPEED1           ; WENN INDEX DA, ERSTE SCHLEIFE
                                        ; UEBERSPRINGEN

          LD        HL,0                ; WARTE BIS INDEX KOMMT
DSPEED2:INC         HL                  ; ERHOEHE HL
          LD        A,H                 ; OUT OF TIME?
          OR        L
          RET       Z                   ; DANN RETURN
          IN        A,(P_IN_LS258_A) ; LESE INDEX-SIGNAL
          AND       MASK_INDEX          ; UND MASKIERE
          JR        NZ,DSPEED2                    ; WARTE BIS LOW

DSPEED1:LD          HL,0                ; WARTE BIS INDEX WEGGEHT
DSPEED3:INC         HL                  ; ERHOEHE HL
          LD        A,H                 ; OUT OF TIME?
          OR        L
          RET       Z                   ; DANN RETURN
          IN        A,(P_IN_LS258_A) ; LESE INDEX-SIGNAL
          AND       MASK_INDEX          ; UND MASKIERE
          JR        Z,DSPEED3           ; WARTE BIS HIGH

          LD        HL,0                ; EIGENTLICHER ZAEHLER
DSPEED4:INC         HL                  ; ERHOEHE HL
          LD        A,H                 ; OUT OF TIME?
          OR        L
          RET       Z
          IN        A,(P_IN_LS258_A) ; LESE INDEX UND WARTE
          AND       MASK_INDEX          ; BIS WIEDER LOW
          JR        NZ,DSPEED4
          LD        A,0FFH              ; RESET ZERO-FLAG
          OR        A

          RET                           ; ZURUECK MIT DRIVE-SPEED



NOREADY_MOTO:
          IN        A,(P_IN_LS258_B) ; LAEUFT MOTOR SCHON ?
          AND       MASK_MOT
          JR        Z,NREDY1            ; SPRUNG WENN MOTOR SCHON LAEUFT
NREDY2:   CALL      SPEED_CONST         ; WARTE BIS LW AUF TOUREN
          JR        NZ,NREDY1           ; SPRUNG WENN DREHZAHL KONSTANT
          CALL      NRDYERR             ; GEBE ERROR-TEXT AUS
          JR        NZ,NREDY2           ; WIEDERHOLUNG
          JP        UMLEIT_GETCM
NREDY1:   LD        A,PAD_MOTOR         ; NEUER MOTOR TRIGGER
          OUT       (P_LS259),A
          LD        A,PAD_READY OR 80H ; SETZE READY_LEITUNG
          OUT       (P_LS259),A
          JP        MOTO1



MOTO:                                   ; WAITS UNTIL DISK READY AND THEN
                                        ; TRANSMITS COMMAND TO FDC

          PUSH      BC                  ; SAVE COMMAND
          CALL      READY_MASK          ; LW SCHON GETESTET?
          AND       0F0H                ; STEHT IN DEN OBEREN 4 BITS
          CALL      NZ,READY_TEST       ; WENN NOCH NICHT, DANN TESTE AUF READY
          CALL      READY_MASK          ; KANN READY GELIEFERT WERDEN?
          AND       0FH                 ; STEHT IN DEN UNTEREN 4 BITS
          JP        NZ,NOREADY_MOTO     ; WENN NICHT SPRUNG
                                        ; SONST WEITER WIE GEHABT

          LD        A,PAD_MOTOR         ; SCHALTE MOTOR EIN
          OUT       (P_LS259),A

MOTO2:    LD        HL,00FFFH ; SET TIMER
MOTO3:    PUSH      HL                  ; SAVE TIMER
          LD        BC,0204H  ; SENSE DRIVE
          CALL      CMFD
          CALL      NEXT                ; FETCH RESULT
          POP       HL                  ; GET TIMER VALUE
          AND       20H                 ; DISK READY ?
          JR        NZ,MOTO1            ; OK, READY
          DEC       HL                  ; TIMER=TIMER-1
          LD        A,H                 ; = ZERO?
          OR        L
          JR        NZ,MOTO3            ; NO, TRY AGAIN
          CALL      NRDYERR             ; DRIVE NOT READY TEXT
          JR        NZ,MOTO2            ; NO, AGAIN
          LD        A,PAD_MOTOR OR 80H
          OUT       (P_LS259),A
          JP        UMLEIT_GETCM        ; ENTWEDER MONITOR ODER WARM-BOOT


NRDYERR:
                                        ; GEBE FEHLERMELDUNG FUER DRIVE NOT READY AUS
                                        ; UND VERGLEICHE EINGEGEBENES ZEICHEN MIT N

          LD        HL,NREADY1          ; PRINT ERROR TEXT
          CALL      SOUT
          CALL      PRINT_DRIVE         ; GEBE LW BUCHSTABE AUS
          LD        HL,NREADY2          ; GEBE REST TEXT AUS
          CALL      SOUT
          CALL      GETCH1              ; AGAIN?
          LD        C,A                 ; ECHO
          CALL      CECHO
          CALL      CROUT               ; LINE FEED
          LD        A,C
          CP        'N'
          RET

NREADY1:DEFM        0DH,0AH,BELL,' Drive $'
NREADY2:DEFM        'not ready, retry (Y/N) ? $'


MOTO1:    POP       BC


CMFD:                                   ; TRANSMIT COMMAND TO FDC
                                        ; IN B STEHT ANZAHL DER BYTES
                                        ; IN C STEHT BEFEHL

          LD        HL,CMDTAB
CMFD1:    LD        A,30                ; WAIT FOR MASTER
CMFD2:    DEC       A
          JR        NZ,CMFD2
          IN        A,(FDC)             ; REQUEST FOR MASTER
          AND       0C0H
          CP        080H
          JR        NZ,CMFD1            ; NO => WAIT
          LD        A,C                 ; YES =>
          OUT       (FDD),A             ; SEND BYTE
          INC       HL                  ; POINT TO NEXT BYTE
          LD        C,(HL)
          DJNZ      CMFD1               ; SEND NEXT BYTE
          RET                           ; ALL BYTES TRANSFERRED



NEXT:                                   ; READ NEXT RESULT FROM FDC

          LD        A,6                 ; WAIT FOR MASTER READY
NEXT1:    DEC       A
          JR        NZ,NEXT1
          IN        A,(FDC)             ; REQUEST FOR MASTER
          AND       0C0H                ; TRANSFER TO MASTER
          CP        0C0H
          JP        NZ,NEXT             ; NO =>WAIT
          IN        A,(FDD)             ; YES => FETCH RESULT
          RET



WRITE:
          LD        A,5                 ; WRITE COMMANDO
          LD        HL,TXTWR  ; WRITE ERROR TEXT
          JP        RWCOM



READ:
          LD        A,06H               ; READ COMMANDO
          LD        HL,TXTRD  ; READ ERROR TEXT
          JP        RWCOM



RWCOM:
                                        ; VOR EINTRITT IN DIESE ROUTINE MUESSEN CMDTAB
                                        ; SECTCNT UND DMAADR GESETZT SEIN.
                                        ; IN A MUSS READ ODER WRITE COMMANDO STEHEN,
                                        ; IN HL MUSS DIE ADRESSE DER ERROR MSSG. STEHEN.
                                        ; ES WERDEN DIE ANGEGEBENE ANZAHL SECTCNT
                                        ; VON/NACH DMAADR UEBERTRAGEN.
                                        ; HD BIT WIRD ENTSPRECHEND DEM H BIT GESETZT.
                                        ; DAS IN CMDTAB STEHENDE MFM BIT WIRD UEBERNOMMEN.
                                        ; ES WIRD DIE PRECOMPENSATION ZEIT AUS WRITE_PRECOM
                                        ; UEBERNOMMEN.


          LD        (RWCMD),A ; LEGE COMMANDO AB
          LD        (ERMSG),HL          ; LEGE ADR FUR ERR.TEXT AB
          LD        A,(SECTCNT)         ; WIEVIEL SECTOREN SOLLEN UEBERTRAGEN WERDEN?
          DEC       A                   ; EINS WENIGER FUER ADDITION
          CP        0FFH
          RET       Z                   ; RETURN WENN NULL GEWESEN
          LD        C,A                 ; RETTE AKKU
          LD        A,(EOT)             ; RETTE EOT
          LD        (EOTSAVE),A
          LD        B,A
          LD        A,(SECTOR)          ; BERRECHNE NEUES EOT
          ADD       A,C
          LD        (EOT),A
          LD        C,A                 ; SOLL UEBER SPUR ENDE UEBERTRAGEN WERDEN?
          LD        A,B
          LD        B,0
          SUB       C
          JR        NC,RW5
          LD        B,080H
          LD        A,(EOTSAVE)         ; WENN UEBER SPUR ENDE UEBERTRAGEB WERDEN SOLL
          LD        (EOT),A             ; DANN EOT GLEICH ALTES EOT
RW5:      LD        A,B                 ; SAVE FLAG
          LD        (EOTFLG),A          ; FUER FEHLERMELDUNG
          LD        A,PAD_RTS OR 1      ; SPERRE TASTATUR INTERRUPT
          OUT       (P_LS259),A
          DI
          CALL      SEEK                ; POSITIONIERE
          CALL      SETHEAD             ; TRAGE HEAD BIT IN UNIT EIN
          LD        A,(WRITE_PRECOM) ; SETZE PRECOMPENSATION
          CALL      SEND_PRECOM
          LD        A,(RWRETRY)         ; LADE
          LD        B,A                 ; ANZAHL DER VERSUCHE NACH B
RW4:      PUSH      BC                  ; SAVE RETRY
          LD        B,9                 ; 9 BYTES ZU UEBERTRAGEN
          LD        A,(RWCMD) ; LADE COMMANDO
          LD        C,A                 ; NACH C
          LD        A,(CMDTAB)          ; TRAGE MFM BIT EIN
          AND       040H                ; ISOLIERE MFM BIT
          OR        C                   ; COMMAND DAZU
          LD        C,A                 ; ZURUECK INC
          CALL      MOTO                ; SEND COMMAND TO UPD 765
                                        ; BEREITE REGISTER VOR
          EXX                           ; LADE DMA ADRESSE IN ZWEITREGISTER SATZ
          LD        HL,(DMAADR)
          LD        C,FDD               ; UEBERTRAGUNGSADRESSE
          EXX
          LD        HL,SYSTEMPAGE       ; PAGE DER MASTER ABHNG. SPRUENGE
          LD        C,FDC

          CALL      RWPOLL              ; UEBERTRAGE VON/ZU DISK

          CALL      RESULT              ; HOLE ERGEBNIS
          LD        A,(REST+1)          ; BLENDE END OF TRACK BIT AUS
          AND       7FH
          LD        (REST+1),A
          LD        C,A
          LD        A,(REST+2)
          OR        C                   ; SONSTIGES FEHLER BIT GESETZT
          POP       BC                  ; RESTORE RETRY COUNTER
          JR        Z,RW7                         ; KEINE FEHLER
          DJNZ      RW4                 ; NOCH VERSUCHE FREI?
RW7:
          LD        A,(EOTFLG)          ; WURDE WIRKLICH UEBER SPURGRENZE GELESEN?
          LD        C,A
          LD        A,(REST+1)
          OR        C
          LD        (REST+1),A
          LD        C,A
          LD        A,(REST+2)
          OR        C                   ; SET ZERO FLAG
          PUSH      AF                  ; RETTE FLAGS UND AKKU FUER FEHLERMELDUNG
          CALL      NZ,DISKERR          ; DRUCKE FEHLER
          LD        A,(EOTSAVE)         ; LADE ORG EOT
          LD        (EOT),A             ; ZURUECK
          EI
          LD        A,(IO_JUMPERBYTE) ; MUSS EINGABE FREIGEGEBEN WERDEN?
          DEC       A
          JR        NZ,RW1
          LD        A,PAD_RTS ; GEBE EINGABE FREI
          OUT       (P_LS259),A
RW1:
          LD        A,(RWCMD) ; WAR DISK WRITE ?
          CP        06H
          JR        Z,RW2                         ; SPRUNG WENN NEIN
          LD        A,(TE_TIME)         ; SONST VERZOEGERUNG
          OR        A                   ; WENN NULL DANN ENDE
          JR        Z,RW2
          LD        B,A
RW3:      LD        HL,22               ; <10>
RW6:      DEC       HL                  ; <6>
          LD        A,H                 ; <4>
          OR        L                   ; <4>
          JR        NZ,RW6              ; <12/7>
          DJNZ      RW3                 ; <13/8>
RW2:
          POP       AF                  ; LADE AKKU FUER FEHLERMELDUNG
          RET



SETHEAD:
                                        ; SETZE HEAD BYTE AUF 00H ODER 01H
                                        ; SETZE HEAD BIT IN UNIT BYTE

                                        ; FOLGENDE KOMBINATIONEN SIND MOEGLICH:
                                        ; X BEDEUTET UNBESTIMMT, - BEDEUTET KEINE AENDERUNG ZU VORHER

                                        ; HEAD VORHER=>     UNIT NACHHER,       HEAD NACHHER
                                        ; XXXXXX00          000000--  00000000
                                        ; XXXXXX01          000001--  00000001
                                        ; XXXXXX10          000001--  00000000
                                        ; XXXXXX11          000000--  00000001

          LD        A,(HEAD)  ; LADE HEAD BIT
          LD        C,A                 ; RETTE IN C
          AND       1
          LD        (HEAD),A
          LD        A,C
          RLCA                          ; EIN BIT NACH LINKS
          LD        C,A
          RLCA                          ; ZWEI BIT NACH LINKS
          XOR       C                   ; ERZEUGE UNIT BIT
          AND       04H                 ; BLENDE ANDERE BITS AUS
          LD        C,A                 ; SAVE
          LD        A,(UNIT)  ; LADE DRIVE NR.
          AND       03H                 ; BLENDE OBERE BITS AUS
          OR        C                   ; HEAD DAZU
          LD        (UNIT),A  ; ZURUECK
          RET



TEST:
                                        ; DIESE ROUTINE ERMITTELT DIE DATEN DER PLATTE, DIE SICH IM VON
                                        ; UNIT SPEZIFIZIERTEN LAUFWERK BEFINDET
                                        ; GETESTET WIRD DIE SPUR, DIE IN TEST_TRACK STEHT
                                        ; ALS ERGEBNIS WERDEN TEST_TYPE UND TEST_MSEK GESETZT
                                        ; KANN DER PLATTEN-TYP NICHT ERMITTELT WERDEN IST DER AKKU AUF FFH
                                        ; WENN PLATTEN-TYP ERKANNT WURDE IST AKKU=00H

          CALL      RECAL               ; RECALIBRIERE
          LD        A,(UNIT)  ; SEITE 0 WAEHLEN
          AND       03H
          LD        (UNIT),A
          LD        A,(TEST_TRACK)      ; POSITIONIERE AUF DIE SPUR
          LD        (TRACK),A ; DEREN FORMAT ERKANNT WERDEN SOLL
          CALL      SEEK

          LD        A,00                ; TESTE OB SD,MAXI
          LD        (TEST_TYPE),A
          CALL      MAXI_SET
          CALL      READ_ID              ; VERSUCHE ID-FELD ZU LESEN
          JP        Z,TEST1             ; SPRUNG WENN SD,MAXI

          LD        A,40H               ; TESTE OB DD,MAXI
          LD        (TEST_TYPE),A
          CALL      READ_ID
          JP        Z,TEST1             ; SPRUNG WENN DD,MAXI

          LD        A,20H               ; TESTE OB SD,MINI
          LD        (TEST_TYPE),A
          CALL      MINI_SET
          CALL      READ_ID
          JP        Z,TEST1             ; SPRUNG WENN SD,MINI

          LD        A,60H               ; TESTE OB DD,MINI
          LD        (TEST_TYPE),A
          CALL      READ_ID
          JP        Z,TEST1             ; SPRUNG WENN DD,MINI

TEST2:    LD        A,0FFH              ; BLEIBT NICHTS MEHR  UEBRIG
          RET                           ; RUECKSPRUNG MIT FEHLER

TEST1:                                  ; OK, MINI ODER MAXI, FM ODER MFM
                                        ; ERKANNT
                                        ; ZAEHLE JETZT DIE ANZAHL DER SEKTOREN
                                        ; AUF DER SPUR
          CALL      READ_ID             ; LESE ERSTES ID-FELD
          JR        NZ,TEST2            ; SPRUNG WENN NICHT MOEGLICH
          LD        A,(REST+5)          ; LADE SEKTORNUMMER
          LD        D,A                 ; NACH D UM EINE UMDREHUNG ABZUWARTEN
          LD        C,A                 ; NACH C UM GROESSTEN SEKTOR ZU ERMITTELN
          LD        B,52                ; MAXIMAL 52 LESEVERSUCHE, DANN FEHLER
TEST3:    PUSH      BC                  ; RETTE REGISTER
          PUSH      DE
          CALL      READ_ID             ; LESE NAECHSTES ID-FELD
          POP       DE                  ; RESTORE REGISTER
          POP       BC
          JR        NZ,TEST2            ; SPRUNG WENN FEHLER
          LD        A,(REST+5)          ; LADE SEKTORNUMMER
          CP        D                   ; EINE UMDREHUNG ?
          JR        Z,TEST4             ; DANN ENDE (MAX-SEKTOR IN C)
          CP        C                   ; NEUE SEKTORNUMMER GROESSER ALS ALLE ANDEREN?
          JR        C,TEST5             ; SPRUNG WENN NEIN
          LD        C,A                 ; SONST NEUER SEKTOR DER GROESSTE
TEST5:    DJNZ      TEST3               ; LESE NEUEN SEKTOR EIN
          JR TEST2            ; WENN ZAEHLER ABLAEUFT, DANN FEHLER

TEST4:    LD        A,C                 ; LEGE GROSSTE SEKTORNUMMER AB
          LD        (TEST_MSEK),A

          LD        A,(REST+6)          ; PACKE SEKTORGROESSE ZU TEST_TYPE
          AND       0FH
          LD        C,A
          LD        A,(TEST_TYPE)
          OR        C
          LD        (TEST_TYPE),A

          LD        A,(UNIT)  ; SOLL TWO-SIDED-BIT IMMER AUF HIGH SEIN?
          CPL                           ; (NAEMLICH DANN, WENN ENTSPRECHENDES
          AND       00000011B ; BIT IM OBEREN NIPPLE VON SEEKNR AUF HIGH)
          LD        B,A
          OR        A
          LD        A,(SEEKNR)
          JR        Z,TEST6             ; KEIN SCHIEBEN NOTWENDIG
TEST7:    RLCA
          DJNZ      TEST7
TEST6:    AND       80H                 ; WENN OBERSTES BIT 1, DANN TS-BIT AUCH EINS
          JR        NZ,TEST8            ; SONST TS-BIT WIE TS-LEITUNG
          CALL      SENSD               ; LESE TWO-SIDED SIGNAL EIN
          RLCA                          ; VERSCHIEBE IN OBEERSTES BIT
          RLCA
          RLCA
          RLCA
          AND       80H                 ; BLENDE REST AUS
TEST8:    LD        C,A                 ; PACKE ZU TEST_TYPE
          LD        A,(TEST_TYPE)
          OR        C
          LD        (TEST_TYPE),A
                                        ; OK, ALLES GEPRUEFT
          LD        A,0                 ; FEHLERFREIE RUECKKEHR
          RET



READ_ID:
                                        ; LESE NAECHSTES ID FELD
                                        ; IN TEST_TYPE BIT 6 SEHT OB FM ODER MFM
                                        ; KONNTE KEIN ID-FELD GELESEN WERDEN, DANN IST AKKU<>0
                                        ; UND ZERO-FLAG NICHT GESETZT

          LD        BC,020AH  ; READ ID KOMMANDO
          LD        A,(TEST_TYPE)       ; PACKE MFM BIT DAZU
          AND       040H
          OR        C
          LD        C,A
          CALL      MOTO                ; LESE ID-FELD
          CALL      RESULT              ; WAR LESEVERSUCH ERFOLGREICH?
          OR        A
          RET



MAXI_SET:
                                        ; SETZT FLOPPY KONTROLER AUF MAXI-LAUFWERKE
          PUSH      AF
          LD        A,PAD_MINI
          OUT       (P_LS259),A
          POP       AF
          RET



MINI_SET:
                                        ; SETZT FLOPPY-KONTROLER AUF MINI-LAUFWERKE
          PUSH      AF
          LD        A,PAD_MINI OR 1
          OUT       (P_LS259),A
          POP       AF
          RET



SENSD:    LD        BC,0204H
          CALL      CMFD
          CALL      NEXT
          RET



DISKERR:
                                        ; GIBT DISK FEHLERMELDUNG AUS
                                        ; BENUTZT DAZU DIE RESULT TABELLE
                                        ; UND DIE ERMSG EINTRAGUNG

          LD        A,(DERMSG)          ; SOLL FEHLERMELDUNG
          INC       A                   ; UNTERDRUECKT WERDEN ?
          RET       Z                   ; WENN JA, RUECKSPRUNG
          LD        HL,(ERMSG)          ; LADE READ BZW WRITE TEXT
          CALL      SOUT                ; UND GEBE IHN AUS
          LD        A,(REST)  ; LADE LAUFWERK NUMMER
          AND       03H                 ; ISOLIERE LE NR
          ADD       A,41H               ; WANDLE IN ASCCI
          LD        C,A                 ; GEBE LAUFWERK BUCHSTABE AUS
          CALL      CECHO

          LD        HL,TXT1             ; GEBE TRACK AUS
          CALL      SOUT
          LD        A,(REST+3)
          CALL      DEZOUT

          LD        HL,TXT2             ; GEBE HEAD AUS
          CALL      SOUT
          LD        A,(REST+4)
          ADD       A,30H               ; WANDLE IN ASCII
          LD        C,A
          CALL      CECHO

          LD        HL,TXT3             ; GEBE SECTOR AUS
          CALL      SOUT
          LD        A,(REST+5)
          CALL      DEZOUT

                                        ; GEBE FEHLER IM KLARTEXT AUS

          LD        DE,ERROR_TABLE
          LD        A,(REST+1)          ; LESE STATUS1
          LD        H,A
          LD        A,(REST+2)          ; LESE STATUS2
          LD        L,A
ERRLOP:
          ADD       HL,HL               ; TESTE OB FEHLERBIT GESETZT
          PUSH      HL
          LD        A,(DE)
          LD        L,A
          INC       DE
          LD        A,(DE)
          LD        H,A
          CALL      C,SOUT              ; WENN JA GEBE TEXT AUS
          POP       HL
          INC       DE                  ; ZEIGE AUF NAECHSTE MELDUNG
          LD        A,H                 ; KEIN FEHLER MEHR DA?
          OR        L
          JR        NZ,ERRLOP

          CALL      CROUT

          RET                           ; OK, ENDE



;**************************************************************************
;***                                                                                      ***
;***  ES FOLGT NUN DIE ROUTINE ZUM BOOTEN VON DER HARDDISK            ***
;***                                                                                      ***
;**************************************************************************



; PORTADRESSEN FUER OMTI-CONTROLLER AUF ECB-BUS (MIT ECPC VON CONITEC)

ODATA:    EQU       0E0H
OSTATUS:  EQU         0E1H
OCONFIG:  EQU         0E2H
OMASK:    EQU       0E3H
ORESET:   EQU       0E1H
OSELECT:  EQU         0E2H

HDADR:    EQU       0FC00H              ; LADEADRESSE FUER BOOTSTRAP-LOADER



HCMD:                                   ; READ FIRST SECTOR
          CALL      WAIT_HD_READY
          JP        NZ,CRGETCM

          CALL      SELECT

          LD        HL,READ_BOOT_CMD ; POINT TO CMDFIELD
          CALL      SCMD2

          LD        HL,HDADR  ; LOAD DMA ADDRESS

READBUFFER:
                                        ; READ OMTI DATABUFFER TO (HL)
          IN        A,(OSTATUS)         ; WAIT FOR DATA READ TRANSFER
          AND       00111111B
          CP        00001111B
          RET       Z                   ; NO TRANSFER IN ERROR CASE
          CP        00001011B
          JR        NZ,READBUFFER
          LD        BC,ODATA  ; CLEAR B AND SET C TO DATAPORT
          INIR                          ; READ 256 BYTE
          INIR                          ; READ THE NEXT 256 BYTE

          CALL      READSTATUS

          JP        NZ,CRGETCM

          LD        (HD_BOOT),A

          JP        HDADR



SELECT:                                 ; SELECT OMTI CONTROLLER
          OUT       (OSELECT),A
SELECT1:IN          A,(OSTATUS)         ; WAIT FOR CONTROLLER SELECTED
          AND       00111111B
          CP        00001101B ; WAIT UNTIL COMMANDTRANSFER IS READY
          JR        NZ,SELECT1
          RET

SCMD2:    LD        B,6                 ; BYTE COUNTER
          LD        C,ODATA             ; POINTER TO OMTI DATAPORT
SCMD1:    IN        A,(OSTATUS)         ; READ STATUSBYTE
          AND       00111111B
          CP        00001101B ; READY FOR WRITE COMMAND BYTE ?
          JR        NZ,SCMD1            ; NO, WAIT UNTIL READY
          OUTI                          ; WRITE COMMANDBYTE TO OMTI
          JR        NZ,SCMD1            ; UNTIL ALL DONE
          RET


READSTATUS:
                                        ; READ STATUSBYTE AND SET ZEROFLAG AND
                                        ; ERRFLAG IF ANY ERROR
          IN        A,(OSTATUS)         ; READ CONTOLLER STATUSBYTE
          AND       00111111B
          CP        00001111B ; READY FOR STATUS READ ?
          JR        NZ,READSTATUS                 ; NO, WAIT UNTIL READY
          IN        A,(ODATA) ; OK, READ STATUSBYTE
          OR        A                   ; AND SET ZEROFLAG
          RET


WAIT_HD_READY:
                                        ; WARTE BIS WINCHESTER READY ODER TIMEOUT
          CALL      CHECK_HD_READY
          RET       Z                   ; ALLES OK WINCHESTER BEIM ERSTEN MAL READY
          LD        HL,WHRTXT ; GEBE WARTEMELDUNG AUS
          CALL      SOUT
          LD        HL,0FFFFH ; LADE TIMEOUT ZAEHLER
WHR1:     PUSH      HL
          CALL      CHECK_HD_READY
          POP       HL
          RET       Z
          DEC       HL
          LD        A,H
          OR        L
          JR        NZ,WHR1
          LD        A,0FFH
          OR        A
          RET

WHRTXT:   DEFM      0DH,0AH,'waiting for Harddisk ready $'

CHECK_HD_READY:
                                        ; PRUEFE OB WINCHESTERLAUFWERK READY
          CALL      SELECT
          LD        HL,READYCMDFIELD
          CALL      SCMD2
          CALL      READSTATUS
          RET

READYCMDFIELD:
          DEFB      0,0,0,0,0,0




READ_BOOT_CMD:

          DEFB      008H,000H,000H,000H,001H,000H



;**************************************************************************
;***                                                                                      ***
;***  ENDE DER ROUTINEN FUER DEN HARDDISK CONTROLLER                    ***
;***                                                                    ***
;**************************************************************************



;**********************************************************
;***                                                                  ***
;***  ROUTINEN ZUM EIN UND AUSLESEN DER UHRZEIT             ***
;***   FUER DEN UPD 1990                                    ***
;***                                                                  ***
;**********************************************************



SEND_TIME_COM:
                                        ; SENDE DIE UNTEREN 3BITS DES AKKU ALS KOMMANDO
                                        ; ZUM UPD 1990

          CALL      SEND_PRECOM
          CALL      SEND_STB
          RET



SEND_PRECOM:
                                        ; SENDE GEBE DIE UNTEREN 3 BITS DES AKKU
                                        ; AUF DEN LEITUNGEN C0-C2 AUS
                                        ; DIENT FUER UHREN KOMMANDO,
                                        ; DISK PRECOMPENSATION UND JUMPER EINLESEN

          PUSH      BC                  ; RETTE BC
          LD        C,PAD_C0  ; ADRESSE DES BITS
          LD        B,3                 ; ZAEHLER
SEND_TIME_COM_1:
          RRCA                          ; ZYKLISCH VERSCHIEBEN
          PUSH      AF                  ; RETTE AKKU
          AND       80H                 ; MASKIERE BIT
          OR        C
          OUT       (P_TIME_OUT),A
          LD        A,16                ; EINE ADRESSE HOEHER
          ADD       A,C
          LD        C,A
          POP       AF
          DJNZ      SEND_TIME_COM_1     ; GEBE ALLE DREI BITS AUS
          POP       BC
          RET



SEND_STB:
                                        ; SENDE STROBE ZUM UPD1990

          LD        A,PAD_STB OR 1
          OUT       (P_TIME_OUT),A
          LD        A,10
SSTB:     DEC       A
          JR        NZ,SSTB
          LD        A,PAD_STB
          OUT       (P_TIME_OUT),A
          RET



SEND_CLK:
                                        ; SENDE SHIFT TAKT ZUM UPD1990
          LD        A,PAD_CLK OR 80H
          OUT       (P_TIME_OUT),A
          LD        A,10
SCKL:     DEC       A
          JR        NZ,SCKL
          LD        A,PAD_CLK
          OUT       (P_TIME_OUT),A
          RET



TIME_ENABLE:
          RET



TIME_DISABLE:
                                        ; SETZE CS DES UPD 1990 AUF OFF
          RET



READ_SHIFT:
                                        ; DIE 40 BITS DES SHIFTREGISTERS DES UPD 1990
                                        ; WERDEN IN DIE NACHFOLGENDEN 5 BYTES VON (HL)
                                        ; ABGELEGT. NACH DIESER AKTION IST DAS SCHIFFTREGISTER
                                        ; GELOESCHT

          LD        A,1                 ; READ SCHIF REGISTER
          CALL      SEND_TIME_COM
          LD        B,5                 ; LESE 5 BYTES AUS
READ_SHIFT_1:
          LD        C,8                 ; JEDES BYTE ENTHAELT 8 BIT
READ_SHIFT_2:
          IN        A,(P_TIME_IN)       ; LESE EIN BIT AUS
          CPL                           ; 74LS258 NEGIERT
          RLA
          LD        A,D                 ; SETZE UNTERSTES BIT IN D
          RRA                           ; ENTSPRECHEND CARRY
          LD        D,A
          CALL      SEND_CLK  ; SHIFTE NAECHSTES BIT
          DEC       C                   ; LESE PRO BYTE 8 BIT AUS
          JR        NZ,READ_SHIFT_2     ; IST BYTE FERTIG?
          LD        (HL),D              ; LEGE BYTE NACH (HL)
          INC       HL                  ; ZEIGER AUF NAECHSTES BYTE
          DJNZ      READ_SHIFT_1        ; LESE FUENF BYTES AUS
          LD        A,0                 ; GEHE IN HOLD MODE
          CALL      SEND_TIME_COM
          RET

WRITE_SHIFT:
                                        ; SCHREIBT SHIFTREGISTER MIT DEN 5 BYTES, AUF DIE
                                        ; (HL) ZEIGT

          LD        D,(HL)              ; LESE ERSTES BYTE EIN
          LD        A,1                 ; GEHE IN SHIFT MODE
          CALL      SEND_TIME_COM
          LD        B,5                 ; SCHREIBE FUENF BYTES EIN
WRITE_SHIFT_1:
          LD        C,8                 ; JEDES BYTE ENTHAELT ACHT BIT
WRITE_SHIFT_2:
          LD        A,D                 ; AUSGABE BYTE IN AKKU
          RRCA
          AND       80H
          OR        PAD_C0
          OUT       (P_TIME_OUT),A
          LD        A,D                 ; SCHIEBE UM EINE POS. NACH RECHTS
          RRA
          LD        D,A                 ; ZURUECK IN D
          CALL      SEND_CLK  ; TAKTE BIT EIN
          DEC       C                   ; SCHON 8 BIT AUSGEGEBEN?
          JR        NZ,WRITE_SHIFT_2
          INC       HL                  ; LESE NAECHSTES BYTE
          LD        D,(HL)              ; NACH D
          DJNZ      WRITE_SHIFT_1       ; SCHREIBE INSGESAMT FUENF BYTES
          LD        A,0                 ; SETZE UPD 1990 AUF HOLD
          CALL      SEND_TIME_COM
          RET

SET_PHYS_TIME:
                                        ; SETZE ZEIT IM UPD 1990 MIT DEN FUENF BYTES DIE
                                        ; IN PHYS_TIME STEHEN

          CALL      TIME_ENABLE         ; AKTIVIERE UPD 1990
          LD        HL,SHIFT_CONT       ; RETTE SHIFTREGISTER INHALT
          CALL      READ_SHIFT
          LD        HL,PHYS_TIME        ; SCHREIBE ZEIT IN SHIFTREGISTER
          CALL      WRITE_SHIFT
          LD        A,2                 ; SETZE ZAEHLER
          CALL      SEND_TIME_COM
          LD        HL,SHIFT_CONT       ; LADE ALTEN SHIFTREGISTER INHALT
          CALL      WRITE_SHIFT
          CALL      TIME_DISABLE        ; DEAKTIVIERE UPD 1990
          RET

READ_PHYS_TIME:
                                        ; LESE ZEIT AUS UPD 1990 IN DIE FUENF BYTES
                                        ; VON PHYS_TIME

          CALL      TIME_ENABLE         ; AKTIVIERE UPD 1990
          LD        HL,SHIFT_CONT       ; RETTE SHIFTREGISTER INHALT
          CALL      READ_SHIFT
          LD        A,3                 ; SETZE SHIFTREGISTER MIT ZEIT
          CALL      SEND_TIME_COM
          LD        B,0FFH              ; WARTE ETWAS
READ_PHYS_TIME_1:
          DJNZ      READ_PHYS_TIME_1
          LD        HL,PHYS_TIME        ; LESE ZEIT AUS
          CALL      READ_SHIFT
          LD        HL,SHIFT_CONT       ; LADE SHIFTREGISTER INHALT ZURUECK
          CALL      WRITE_SHIFT
          CALL      TIME_DISABLE        ; DEAKTIVIERE UPD 1990
          RET

SET_SHIFT:
                                        ; SETZE SHIFTREGISTER MIT FUENF BYTES
                                        ; SHIFT_CONT

          CALL      TIME_ENABLE         ; AKTIVIERE UPD 1990
          LD        HL,SHIFT_CONT       ; LADE SHIFT REG.
          CALL      WRITE_SHIFT
          CALL      TIME_DISABLE
          RET



GET_SPEED:
                                        ; TESTE OB UHR IN ORDNUNG
                                        ; WENN OK, A=FF, WENN NICHT IN ORDNUNG, A=00
                                        ; WENN UHR OK, DANN IN HL TAKTFREQUENZ
          CALL      TIME_ENABLE         ; SELECT UPD 1990
          LD        A,0                 ; IN HOLD MODE
          CALL      SEND_TIME_COM
                                        ; WARTE AUF AENDERUNG AM DATENAUSGANG
          LD        HL,0
          LD        DE,0FFFFH ; TIME OUT
          IN        A,(P_TIME_IN)       ; LESE AUSGANG
          AND       TIME_DATA_MASK
          LD        B,A                 ; NACH B
GET_SPEED1:
          IN        A,(P_TIME_IN)       ; LESE AUSGANG BIS AENDERUNG ODER TIME OUT
          AND       TIME_DATA_MASK      ; MASKIERE
          CP        B
          JR        NZ,GET_SPEED2                 ; VERAENDERUNG, WEITER
          LD        C,A                 ; RETTE AKKU
          DEC       DE                  ; TIME OUT ZAEHLER EINS RUNTER
          LD        A,D
          OR        E                   ; TIME OUT
          JR        NZ,GET_SPEED1                 ; UHR NICHT OK?
          CALL      TIME_DISABLE
          XOR       A                   ; FEHLER MELDUNG
          RET
GET_SPEED2:
                                        ; TESTE TAKT FREQUENZ
          LD        B,A                 ; WIEDER IN B FUER VERAENDERUNG
          LD        C,TIME_DATA_MASK ; MASKE
GET_SPEED3:
                                        ; ERMITTLE TAKT, LOOP MUSS 50 ZYKLEN DAUERN
          IN        A,(P_TIME_IN)       ; 11 ZYKLEN
          AND       C                   ; MASKIERE, 4 ZYKLEN
          CP        B                   ; GLEICH ?, 4 ZYKLEN
          JR        NZ,GET_SPEED4                 ; ENDE,   7 ZYKLEN
          INC       HL                  ; 6 ZYKLEN
          NOP                           ; DIENT NUR ZUR VERZOEGERUNG, 4 ZYKLEN
          NOP                           ; 4 ZYKLEN
          JP        GET_SPEED3          ; 10 ZYKLEN
GET_SPEED4:
          CALL      TIME_DISABLE
          LD        A,0FFH
          RET



;*************************************************************
;*
;*      ENDE DES MASCHINEN CODES, ES FOLGEN NUN TABELLEN
;*
;*************************************************************



TXT1:     DEFM      ", track #"
          DEFB      24H
TXT2:     DEFM      ", head #"
          DEFB      24H
TXT3:     DEFM      ", sector #"
          DEFB      24H

ERROR_TABLE:
          DEFW      B15MSG              ; FEHLERMELDUNGEN FUER ST1
          DEFW      NOBMSG
          DEFW      B13MSG
          DEFW      B12MSG
          DEFW      NOBMSG
          DEFW      B10MSG
          DEFW      B9MSG
          DEFW      B8MSG

          DEFW      NOBMSG              ; FEHLERMELDUNGEN FUER ST2
          DEFW      B6MSG
          DEFW      B5MSG
          DEFW      B4MSG
          DEFW      NOBMSG
          DEFW      NOBMSG
          DEFW      B1MSG
          DEFW      B0MSG

NOBMSG:   DEFB      24H
B15MSG:   DEFM      10,13,' end of cylinder',24H
B13MSG:   DEFM      10,13,' data error',24H
B12MSG:   DEFM      10,13,' over run',24H
B10MSG:   DEFM      10,13,' no data',24H
B9MSG:    DEFM      10,13,' not writable',24H
B8MSG:    DEFM      10,13,' missing address mark',24H
B6MSG:    DEFM      10,13,' control mark',24H
B5MSG:    DEFM      10,13,' data error in data field',24H
B4MSG:    DEFM      10,13,' wrong cylinder',24H
B1MSG:    DEFM      10,13,' bad cylinder',24H
B0MSG:    DEFM      10,13,' missing address mark in data field',24H

TXTRD:
          DEFM      BELL,0DH,0AH,' Read error on $'
TXTWR:
          DEFM      BELL,0DH,0AH,' Write error on $'


SOFT_BAUD_TAB:
                                        ; BAUDRATEN FAKTOR FUER DIE SOFTSCHNITTSTELLE
                                        ; BERRECHNUNG ERFOLGT SO:
                                        ; EINTRAG:=((1000000/BAUDRATE)-12,5)*65536/240000


           IF       ACHTMHZ

          DEFW      50                  ; 9600   BAUD
          DEFW      106                 ; 4800   BAUD
          DEFW      221                 ; 2400   BAUD
          DEFW      448                 ; 1200   BAUD
          DEFW      1814                ;  300   BAUD
          DEFW      4054                ;  134.5 BAUD
          DEFW      7275                ;   75   BAUD
          DEFW      50                  ; 9600   BAUD
          DEFW      22                  ; 19200   BAUD
          DEFW      69                  ; 7200   BAUD
          DEFW      145                 ; 3600   BAUD
          DEFW      297                 ; 1800   BAUD
          DEFW      903                 ;  600   BAUD
          DEFW      3634                ;  150   BAUD
          DEFW      4958                ;  110   BAUD
          DEFW      10916               ;   50   BAUD

           ELSE

          DEFW      25                  ; 9600   BAUD
          DEFW      53                  ; 4800   BAUD
          DEFW      110                 ; 2400   BAUD
          DEFW      224                 ; 1200   BAUD
          DEFW      907                 ;  300   BAUD
          DEFW      2027                ;  134.5 BAUD
          DEFW      3637                ;   75   BAUD
          DEFW      25                  ; 9600   BAUD
          DEFW      11                  ; 19200   BAUD
          DEFW      35                  ; 7200   BAUD
          DEFW      72                  ; 3600   BAUD
          DEFW      148                 ; 1800   BAUD
          DEFW      452                 ;  600   BAUD
          DEFW      1817                ;  150   BAUD
          DEFW      2479                ;  110   BAUD
          DEFW      5458                ;   50   BAUD

           ENDIF


SGNON:
          DEFB      0DH,0AH
          DEFM      'Monitor'
          DEFB      0DH,0AH
          DEFB      '$'



KENNUNGSTEXT:
          DEFM      'PROF-80' ; WIRD VON INIT INS RAM KOPIERT



CMDMSG:                                 ; NACH EINGABE EINES ZEICHENS WIRD TEXT AUSGEGEBEN

          DEFM      'Address for read (write) from (to) drive $'
          DEFM      'Boot$'
          DEFM      'Check drive $'
          DEFM      'Display memory $'
          DEFM      'Fill memory $'
          DEFM      'Go to $'
          DEFM      'Harddisk boot$'
          DEFM      'Keyboard mode$'
          DEFM      'In port $'
          DEFM      'List time$'
          DEFM      'Move memory $'
          DEFM      'New date and time set$'
          DEFM      'Out port $'
          DEFM      'Read from drive $'
          DEFM      'Substitute memory $'
          DEFM      'Test memory $'
          DEFM      'User defined disk timing$'
          DEFM      'Verify memory $'
          DEFM      'Write to drive $'
          DEFM      'X Register $'
          DEFB      0                   ; ENDE DER COMMAND TEXTE

CADR:
          DEFW      0
          DEFW      UCMD
          DEFW      KCMD
          DEFW      LCMD
          DEFW      GCMD
          DEFW      WCMD
          DEFW      ACMD
          DEFW      RCMD
          DEFW      OCMD
          DEFW      CCMD
          DEFW      TCMD
          DEFW      VCMD
          DEFW      FCMD
          DEFW      BCMD
          DEFW      XCMD
          DEFW      SCMD
          DEFW      MCMD
          DEFW      ICMD
          DEFW      DCMD
          DEFW      NCMD
          DEFW      HCMD



CTAB:
          DEFB      'H'
          DEFB      'N'
          DEFB      'D'
          DEFB      'I'
          DEFB      'M'
          DEFB      'S'
          DEFB      'X'
          DEFB      'B'
          DEFB      'F'
          DEFB      'V'
          DEFB      'T'
          DEFB      'C'
          DEFB      'O'
          DEFB      'R'
          DEFB      'A'
          DEFB      'W'
          DEFB      'G'
          DEFB      'L'
          DEFB      'K'
          DEFB      'U'
NCMDS:    EQU       $-CTAB



RTAB:
          DEFB      'A'
          DEFB      ASAVE AND 0FFH
          DEFB      0
          DEFB      'B'
          DEFB      BSAVE AND 0FFH
          DEFB      0
          DEFB      'C'
          DEFB      CSAVE AND 0FFH
          DEFB      0
          DEFB      'D'
          DEFB      DSAVE AND 0FFH
          DEFB      0
          DEFB      'E'
          DEFB      ESAVE AND 0FFH
          DEFB      0
          DEFB      'F'
          DEFB      FSAVE AND 0FFH
          DEFB      0
          DEFB      'H'
          DEFB      HSAVE AND 0FFH
          DEFB      0
          DEFB      'L'
          DEFB      LSAVE AND 0FFH
          DEFB      0
          DEFB      'M'
          DEFB      HSAVE AND 0FFH
          DEFB      1
          DEFB      'P'
          DEFB      PSAVE+1 AND 0FFH
          DEFB      1
          DEFB      'S'
          DEFB      SSAVE+1 AND 0FFH
          DEFB      1
          DEFB      'a'
          DEFB      AASAVE AND 0FFH
          DEFB      0
          DEFB      'b'
          DEFB      BBSAVE AND 0FFH
          DEFB      0
          DEFB      'c'
          DEFB      CCSAVE AND 0FFH
          DEFB      0
          DEFB      'd'
          DEFB      DDSAVE AND 0FFH
          DEFB      0
          DEFB      'e'
          DEFB      EESAVE AND 0FFH
          DEFB      0
          DEFB      'f'
          DEFB      FFSAVE AND 0FFH
          DEFB      0
          DEFB      'h'
          DEFB      HHSAVE AND 0FFH
          DEFB      0
          DEFB      'l'
          DEFB      LLSAVE AND 0FFH
          DEFB      0
          DEFB      'm'
          DEFB      HHSAVE AND 0FFH
          DEFB      1
          DEFB      'X'
          DEFB      XSAVE+1 AND 0FFH
          DEFB      1
          DEFB      'Y'
          DEFB      YSAVE+1 AND 0FFH
          DEFB      1
          DEFB      'I'
          DEFB      ISAVE AND 0FFH
          DEFB      0
          DEFB      'R'
          DEFB      RSAVE AND 0FFH
          DEFB      0
          DEFB      0,0                 ; ENDE KENNUNG DER TABELLE



DISKPAGE:
                                        ; DIE DISKPAGE WIRD DER SYSTEMPAGE UEBERLAGERT

          IN        L,(C)
          JP        (HL)
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          IN        L,(C)
          JP        (HL)
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          IN        L,(C)
          JP        (HL)
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          IN        L,(C)
          JP        (HL)
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          IN        L,(C)
          JP        (HL)
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          IN        L,(C)
          JP        (HL)
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          IN        L,(C)
          JP        (HL)
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          IN        L,(C)
          JP        (HL)
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          RET
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          RET
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          RET
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          EXX
          OUTI
          EXX
          IN        L,(C)
          JP        (HL)
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1

          RET
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          RET
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          RET
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

          EXX
          INI
          EXX
          IN        L,(C)
          JP        (HL)
          DEFB      -1,-1,-1,-1,-1,-1,-1,-1,-1

LASTADD:  EQU         $-1                 ; LETZTE BENUTZTE ADRESSE IM EPROM



;************************************* BEGINN DES RAM-BEREICHES ******

          SEGMENT "DSEG"

          ORG       SYSTEMPAGE-1024-256

BOOTADR:                                ; HIERHER WIRD ERSTER SEKTOR GELADEN

          DEFS      1024                ; PLATZ FUER ERSTEN SEKTOR

          DEFS      256-26              ; PLATZ FUER STACK

REGS:
MSTAK:

                                        ; REGISTER INHALTE

RSAVE:    DEFS      1
ISAVE:    DEFS      1
LLSAVE:   DEFS      1
HHSAVE:   DEFS      1
EESAVE:   DEFS      1
DDSAVE:   DEFS      1
CCSAVE:   DEFS      1
BBSAVE:   DEFS      1
FFSAVE:   DEFS      1
AASAVE:   DEFS      1
YSAVE:    DEFS      2
XSAVE:    DEFS      2
ESAVE:    DEFS      1
DSAVE:    DEFS      1
CSAVE:    DEFS      1
BSAVE:    DEFS      1
FSAVE:    DEFS      1
ASAVE:    DEFS      1
LSAVE:    DEFS      1
HSAVE:    DEFS      1
PSAVE:    DEFS      2
SSAVE:    DEFS      2

                                        ; DIE NACHFOLGENDEN SPEICHERZELLEN MUESSEN
                                        ; MIT DER DISKPAGE GEMISCHT WERDEN KOENNEN

; SYSTEMPAGE:

RWPOLL:                                 ; NACHDEM DIE SYSTEMPAGE VON DER DISKPAGE
                                        ; UEBERLAGERT WURDE, ERLEDIGT EIN CALL VON
                                        ; RWPOLL DIE DISK-UEBERTRAGUNG.

                                        ; *** ERSTE 16 BYTE ***
          DEFS      3                   ; FREI FUER FLOPPY BEDIENUNG
TEMP:     DEFS      1                   ; ALLGEMEINER ZWISCHENSPEICHER
BAUD_JUMPERBYTE:
          DEFS      1                   ; STELLUNG DES JUMPERS J5: 0=KEIN JUMPER
                                        ; 1=1-3,2=2-4,3=3-5,4=4-6
CLKFLG:   DEFS      1                   ; "0": UHR NICHT OK, "FF": UHR OK
DISKFLG:DEFS        1                   ; "0": UPD 765 NICHT OK, "FF": UPD 765 OK
SYSTEMTAKT:
          DEFS      2                   ; SYSTEMFREQUENZ * 100 HZ
DISPADR:DEFS        2                   ; LETZTER ZAEHLERSTAND DES D-BEFEHLS
EOTSAVE:DEFS        1                   ; WIRKLICHES ENDE EINER SPUR
EOTFLG:   DEFS      1                   ; FEHLERFLAG FUER DISK R/W UEBER SPUR ENDE
RWCMD:    DEFS      1                   ; COMMANDO FUER RWCOM
ERMSG:    DEFS      2                   ; MEASSAGE FUR RWCOM


                                        ; *** ZWEITE 16 BYTE ***
          DEFS      3                   ; FREI FUER FLOPPY BEDIENUNG
IO_JUMPERBYTE:
          DEFS      1                   ; STELLUNG DES JUMPERS J4: 0=KEIN JUMPER
                                        ; 1=1-3,2=2-4,3=3-5,4=4-6. DIRIGIERT KONSOLE
PHYS_TIME:
          DEFS      5                   ; ZWISCHENSPEICHER FUER UPD 1990 ZAEHLER INHALT
SHIFT_CONT:
          DEFS      5                   ; ZWISCHENSPEICHER FUER UPD 1990 SHIFTREGISTER
SOFTVERZ:
          DEFS      2                   ; VERZOGERUNGSZEIT FUER DUPLEX-SCHNITTSTELLE


                                        ; *** DRITTE 16 BYTE ***
          DEFS      3                   ; FREI FUER FLOPPY BEDIENUNG
TEST_TYPE:
          DEFS      1                   ; WIRD BEI TEST GESETZT (FORMATERKENNUNG FLOPPY)
                                        ; BIT 7: 0=SS, 1=DS
                                        ; BIT 6: 0=SD, 1=DD
                                        ; BIT 5: 0=MAXI, 1=MINI
                                        ; BIT 4: IMMER 0
                                        ; BIT 0-3: SEKTORGROESSE

TEST_MSEK:
          DEFS      1                   ; ANZAHL DER SEKTOREN/SPUR, DIE TEST ERMITTELTE
TEST_TRACK:
          DEFS      1                   ; AUF DIESER SPUR WIRD DAS FLOPPY-
                                        ; FORMAT GETESTET (DEFAULT=1)
UMLEIT_NMI:
          DEFS      3                   ; EIN NMI GEHT UEBER DIESEN SPRUNG

BANK_ERR_BYTE:
          DEFS      1                   ; BELEGUNG DER ZWEI RAM BANKS
                                        ; 0: BANK 0 UND BANK 1 OK
                                        ; 1: BANK 0 FEHLER
                                        ; 2: BANK 1 FEHLER

DMAADR:   DEFS      2                   ; DMA ADRESSE FUER FLOPPY READ UND WRITE
SECTCNT:DEFS        1                   ; ANZAHL DER SEKTOREN FUER FLOPPY READ UND WRITE
UMLEIT_GETCM:
          DEFS      3                   ; ROUTINEN, DIE VON CP/M BENUTZT WERDEN, MUESSEN
                                        ; UEBER DIESEN SPRUNG AUF BEFEHLS-EINGABE-EBENE
                                        ; ZURUECKKEHREN. CP/M BIOS SETZT DIESEN SPRUNG
                                        ; DANN AUF WBOOT


                                        ; *** VIERTE 16 BYTE
          DEFS      3                   ; FREI FUER FLOPPY BEDIENUNG
                                        ; KOMMANDO-TABELLE FUER FLOPY-CONTROLER
CMDTAB:   DEFS      1
UNIT:     DEFS      1                   ; WIRD VON C-BEFEHL GESETZT
TRACK:    DEFS      1                   ; WIRD VON A-BEFEHL GESETZT
HEAD:     DEFS      1                   ; WIRD VON A-BEFEHL GESETZT
SECTOR:   DEFS      1                   ; WIRD VON A-BEFEHL GESETZT
SECSZ:    DEFS      1                   ; WIRD VON C-BEFEHL GESETZT
EOT:      DEFS      1                   ; WIRD VON C-BEFEHL GESETZT
GAPLL:    DEFS      1                   ; WIRD VON C-BEFEHL GESETZT
DTLL:     DEFS      1                   ; WIRD VON C-BEFEHL GESETZT
UMLEIT_CONST:
          DEFS      3                   ; KONSOLEN STATUS GEHT UEBER DIESEN SPRUNG
SEEKNR:   DEFS      1                   ; EINIGE LAUFWERKE BENOETIGEN ZWEI STEPIMPULSE
                                        ; DIE UNTEREN 4 BIT GEBEN FUER JEDES LW
                                        ; AN, OB ES EIN ('0') ODER ZWEI ('1') IMPULSE
                                        ; PRO SPURWECHSEL BRAUCHT, LAUFWERK 0 IST LSB.
                                        ; DIE OBEREN 4 BIT DIESES BYTES GEBEN AN, OB
                                        ; TEST DAS TWO-SIDED-BIT IMMER AUF 1 ODER
                                        ; ENTSPRECHEND DER TWO-SIDED-LEITUNG SETZTEN
                                        ; SOLL. DURCH DIESE ERWEITERUNG SPART MAN SICH
                                        ; DEN HARDWARE-ZUSATZ (SIEHE CP/M ANPASSUNS-
                                        ; BESCHREIBUNG) FUER GEMISCHTEN BETRIEB MIT
                                        ; 80 TRACK LAUFWERKEN.
                                        ; DEFAULTMAESSIG WIRD SEEKNR MIT XSEEKNR
                                        ; INITIALISIERT. SEEKNR KANN ABER AUCH MIT DEM
                                        ; U-BEFEHL GESETZT WERDEN.

                                        ; *** FUENFTE 16 BYTES ***
          DEFS      3                   ; FREI FUER FLOPPY BEDIENUNG
REST:     DEFS      7                   ; ERGEBNISSTABELLE DES FLOPY-CONTROLERS
UMLEIT_CONIN:
          DEFS      3                   ; KONSOLEN EINGABE GEHT UEBER DIESEN SPRUNG
UMLEIT_CONOUT:
          DEFS      3                   ; KONSOLEN AUSGABE GEHT UEBER DIESEN SPRUNG


                                        ; *** SECHSTE 16 BYTES ***
          DEFS      3                   ; FREI FUER FLOPPY BEDIENUNG
IN_BUFF_END:
          DEFS      11                  ; FIFO ZEICHEN BUFFER FUER DUPLEX EINGABE
                                        ; IM INTERRUPTBETRIEB (J-51-A GESETZT)
IN_BUFF_ZEIG:
          DEFS      2                   ; ZEIGER FUER ZEICHEN BUFFER


                                        ; *** SIEBTE 16 BYTES ***
          DEFS      3                   ; FREI FUER FLOPPY BEDIENUNG
DERMSG:   DEFS      1                   ; "0":AUSGABE VON FLOPPY-FEHLER
                                        ; "FF": AUSGABE VON FLOPPY-FEHLER UNTERDRUECKEN
RWRETRY:DEFS        1                   ; ANZAHL DER LESE/SCHREIB-VERSUCHE MIT FLOPPY
WRITE_PRECOM:
          DEFS      1                   ; WRITE PRECOMPENSATION FUER RWCOM ROUTINE
KENNUNG:DEFS        7                   ; DER MONITOR SCHREIBT HIER PROF-80 KENNUNG EIN
MON_VERS:
          DEFS      1                   ; MONITOR VERSIONSNUMMER
COMMON_PAGE:
          DEFS      1                   ; PAGEGRENZE FUER COMMON BEREICH (SETZT BIOS)
CURRENT_BANK:
          DEFS      1                   ; GEWAEHLTE BANK UNTER COMMON (SETZT BIOS)


                                        ; *** ACHTE 16 BYTES ***
          DEFS      3                   ; FREI FUER FLOPPY BEDIENUNG
SOFTPRNTVERZ:
          DEFS      2                   ; VERZOEGERUNGSZEIT FUER SIMPLEX SCHNITTSTELLE
READY_BYTE:
          DEFS      1                   ; DIE UNTEREN 4 BITS GEBEN AN, OB EIN LW
                                        ; EIN READY SIGNAL LIEFERN KANN ('0') ODER OB
                                        ; ES KEIN READY LIEFERT ('1').
                                        ; DIE OBEREN 4 BITS GEBEN AN, OB BEI DEM
                                        ; BETREFFENDEN LW UEBERHAUPT SCHON GETESTET
                                        ; WURDE OB ES READY LIEFERT
                                        ; '0'= SCHON GETESTET, '1'= NOCH NICHT GETESTET
                                        ; LAUFWERK 0 IST LSB
EPROMZ:   DEFS      1                   ; WIEVIEL MAL WURDE EPROM EINGESCHALTET?
                                        ; (WIRD VOM BIOS GESETZT)
TYPELIST:
          DEFS      2                   ; ZEIGER AUF DISK_TYPE_LIST (WIRD VOM BIOS
                                        ; GESETZT)
SPECD_WORD:
          DEFS      2                   ; DER INHALT DIESER ZWEI BYTE BESTIMMT DIE
                                        ; STEP-RATE, DIE HEAD-LOAD-TIME UND DIE HEAD-
                                        ; UNLOAD-TIME. SPECD_WORD WIRD NACH EINEM RESET
                                        ; VOREINGESTELLT. NACH JEDEM CHECK DRIVE WERDEN
                                        ; DIE DRIVE-ZEITEN NEU GESETZT.
                                        ; DIE 16 BIT VON SPECD_WORD SIND FOLGENDERMASSEN
                                        ; AUFGEBAUT:
                                        ;            SSSSUUUU LLLLLLLX

                                        ; SSSS:   STEPRATE 0000=16MS
                                        ;                    0001=15MS
                                        ;                    .........
                                        ;                    1111=1MS

                                        ; UUUU: HEADUNLOADTIME IN 16 MS SCHRITTEN
                                        ;         0000=0MS, 0001=16MS, .. ,1111=240MS

                                        ; LLLLLLL: HEADLOADTIME IN 2 MS SCHRITTEN

                                        ; X: IMMER 1

                                        ; DEFAULTMAESSIG WIRD SPECD_WORD MIT
                                        ; XSPECD_WORD INITIALISIERT, ES KANN ABER
                                        ; AUCH MIT DEM U-BEFEHL GESETZT WERDEN.

TE_TIME:DEFS        1                   ; WARTEZEIT NACH DISK-WRITE IN 100US (BEI 6MHZ)
SIOABAUD:
          DEFS      1                   ; JUMPERSTELLUNG UNIO J2-A
SIOBBAUD:
          DEFS      1                   ; JUMPERSTELLUNG UNIO J2-B
STEP_WAIT:
          DEFS      1                   ; WARTEZEIT VOR SEEK WENN MOTOR VORHER AUS WAR
                                        ; IST BEI EPSON 3,5 ZOLL LAUFWERKEN NOTWENDIG.
                                        ; ZEIT: MAL 10 MS (BEI 6 MHZ)
          DEFS      1                   ; NOCH FREI


                                        ; ***  NEUNTE 16 BYTE ***
          DEFS      1                   ; FREI FUER FLOPPY BEDIENUNG
ALT_UNIT:
          DEFS      1                   ; LAUFWERK UND TRACK BEI LETZTEM
ALT_TRACK:
          DEFS      1                   ; SEEK AUFRUF
HD_BOOT:DEFS        1                   ; FUER CP/M 0FFH => FLOPPY-BOOT, 000H => HARDDISK-BOOT
BOOT_FLG:
          DEFS      1                   ; FUER MONITOR 0 => HARDDISK-BOOT, SONST FLOPPY-BOOT
          DEFS      11                  ; NOCH FREI


          DEFS      7*16                ; FREIHALTEN FUER ERWEITERUNGEN UND
                                        ; FLOPPY BEDIENUNG

          END

