	title 'CFDISK - Treiber fuer	 PROF-80' 
    
;       CP/M 3.0         --       Modular BIOS
;       ______________________________________
;
;	Riner Rietscher 20.07.2007	Dienstag, 14. August 2007
;
	maclib	z80

	maclib	cdef			; System definitionen

	maclib	syspage		        ;   

	maclib	cpm3			; cpm3 disk macros verwenden
   
	if	cfdisk			; nur assemblieren, wenn Compact-Flash-disk 

noskew	equ	0 

dri$code  equ 05		; Nummer der ersten CF-Drive hier eintragen  
				; nach dem Muster A:=1 , B:=2 , ..... , G:=7
   
;       Einbindung der XDPHs in DRVTBL.ASM :
	public	cfsd0
	public	cfsd1 
	public	cfsd2 
	public	cfsd3
;*        public  cfsd4
;*        public  cfsd5
;       Parameter vom BDOS :
	extrn	@dma,@trk,@sect         ; Systemvariablen
	extrn	@dbnk,@cbnk 
	extrn	@rdrv			; relative Drive Nummer
	extrn	?bank			; Bank einschalten
	extrn	@ermde			; SCB BDOS Error mode
	extrn	?pderr,?pmsg		; BIOS
	extrn	?conin,?cono
   
	dseg  ;dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd
    
;       eXtended Disk Parameter Header (XDPH)
   
	dw	cf$write 
	dw	cf$read	
	dw	cf$login 
	dw	cf$init0 
	db	dri$code,0			 ; relative drive G:
cfsd0:	dph	noskew,cf$dpb$sys,0,     ; den Rest macht GENCPM
    
	dw	cf$write 
	dw	cf$read	
	dw	cf$login 
	dw	cf$init1 
	db	dri$code+1,0			 ; relative drive H:
cfsd1:	dph	noskew,cf$dpb$nor,0,     ; den Rest macht GENCPM
    
	dw	cf$write 
	dw	cf$read	
	dw	cf$login 
	dw	cf$init1 
	db	dri$code+2,0			 ; relative drive I:
cfsd2:	dph	noskew,cf$dpb$last,0,    ; den Rest macht GENCPM
    
;	dw	cf$write 
;	dw	cf$read	
;	dw	cf$login 
;	dw	cf$init1 
;	db	dri$code+3,0			 ; relative drive J:
;cfsd3:	dph	noskew,cf$dpb$last,0,    ; den Rest macht GENCPM

cfsd3   equ     0                        ; erweiterbar
    
    
;       Disk Parameter Block ( DPB ) :
;       ------------------------------
	cseg				 ; DPB ist in der Common-Bank	ccccccccccccccccccccccc

	; dpb	physical$sector$size,	- disk parameter block
	;	physical$sectors$per$track,
	;	number$tracks,
	;	block$size,
	;	number$dir$entries,
	;	track$offset,
	;	checksum$vec$size		(optional)

cf$dpb$sys:	dpb	cf$sec$size,cf$sec$nmb*cf$head,cf$cylinder,2048,1024,1,8000h 
   
cf$dpb$nor:	dpb	cf$sec$size,cf$sec$nmb*cf$head,cf$cylinder,2048,1024,cf$spare,8000h 
   
cf$dpb$last:	dpb	cf$sec$size,cf$sec$nmb*cf$head,cf$cylinder,2048,1024,cf$spare,8000h 
   
	dseg  ;dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd
   
;       Initialisierung der CFdisk :
;       ------------------------------
cf$init0:   			; feststellen ob CF ueberhaupt da ist und bereit ist

if not cfdiskboot

        lxi     h,cfmsgs	; Startmeldung
        call    ?pmsg

	in	cf$status	; CF Status adresse
	bit	1,a		; CF vorhanden ? - Bit 1 ist grundsaetzlich 0 im CF-STATUS 
	lxi	h,nocfmsg
	jrnz	nocf		; wenn Bit 1 = 1 , dann CF nicht vorhanden
	

	mvi	d,80
cfin2:	in	cf$status
	bit	7,a		; busy flag der CF = 1 wenn CF busy 
	jz	cferrcheck	; normaler Ausgang wenn CF ready ist
	

	lxi	b,-1		; aeussere delay Schleife
cfdelay:	dcx	b
	mov	a,c
	ora	b
	jrnz	cfdelay		;innere delay Schleife fortsetzem 

	mvi	c,'C'		;Kennung CP/M BIOS
	call	?cono
	dcr	d
	jrz	timeout	
	jr	cfin2		; kein timeout - dann wieder nachsehen ob CF ready

nocfmsg:
	db	' CF nicht vorhanden',0DH,0AH,0   

toutmsg:
	db	' CF timeout',0DH,0AH,0

timeout:
	lxi	h,toutmsg
nocf:	call	?pmsg
	mvi	a,1		; mit Fehler flag zurueck

endif          			; if not cfdiskboot

cf$init1:			; fuer Drive F: G: nicht noetig
cf$login:
	ret  

cfrdy:				; warten bis CF bereit
	in	cf$status
	cpi	50H		; busy flag abfragen
	jrnz	cfrdy
	ret        

cfdrq:
	in	cf$status
	cpi	58H		; datarequest flag abfragen
	jrnz	cfdrq
	ret

command:    
	lda	cfb$com		; letztes commando laden
	out	cf$comand	; und ausgeben
	call	cfdrq		; warten auf data request
	ret   

cf$read:
	mvi	a,20h		;read command
	lxi	h,readmsg 
	jr	cfrwcom	
   
cf$write:
	mvi	a,30h		;write command
	lxi	h,writemsg 
	
			   	; ab hier gemeinsamer  Code
cfrwcom:    
	shld	operation	;Textkonserve fuer Fehlermeldung
	sta	cfb$com		;Comand ablegen
cfrwrtry:
	call	cfrdy
	lhld	@trk		; get track number
  ; Tracknr. 5 mal links schieben = multi. mit 32 Sec per Track
	slar	  L		; mal 2
	ralr	  H
	slar	  L		; mal 4
	ralr	  H
	slar	  L		; mal 8
	ralr	  H
	slar	  L		; mal 16
	ralr	  H
	slar	  L		; mal 32
	ralr	  H
  ;  zu bearbeitender Sector dazu rechnen
	lda	@sect		;
	ora	L   		; Akku mit den restlichen 3 Bit der Tracknr auffuellen	
	mov     L,A 		; und zurueck nach L

  ; jetzt noch den Offset fuer das CF-Laufwerk dazu addieren
	lda	@rdrv			; drive	number 
	sui	dri$code		; Ergebnis = 0 bei erstem CF-Drive
	jrz   cf$lba$set    		; kein Offset noetig  da erste CF-Drive
	lxi d,cf$cylinder*cf$sec$nmb 	; Driveoffset nach DE

cf$dri$offset:
	stc
	cmc			; CY loeschen
	dad d   		; offset zu HL addieren
	dcr a  
	jrnz  cf$dri$offset 	; naechste Drive ?

cf$lba$set:
	mov	a,l
	out	cf$lba$0	; und nach LBA0 schreiben
	mov	a,h
	out	cf$lba$1	; LBA1 jetzt auch geladen
	xra	a
	out	cf$lba$2	; 0 nach LBA2
	ori	0e0h		; LBA-Kennung dazu oderieren
	out	cf$lba$3	; und nach LBA3 laden
	mvi	a,1		;
	out	cf$count	; ein Sector bearbeiten
	
cfrw$reached:
	call	command		; kommando geben
	jmp	cfrwc		; und lesen oder schreiben
    	
	cseg  ;cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
   
cfrwc:	
	bit	0,a		; beim Aufruf ist CF Status im Akku
	jrnz	cferrcheck	; Fehler wenn Bit 0 = 1 ist	
	lhld	@dma		; DMA Adresse
	lda	@dbnk
	mov	e,a		; Destination bank
	lda	@cbnk		; CPU bank
	cmp	e		; gleich?
	push	psw		; Flag und CPU bank retten
	mov	a,e 
	cnz	?bank		; Bank switch
				; hier Daten lesen / schreiben je nach cfb$com
	mvi	b,0		; Zaehler fuer 256 Byte
	mvi	c,cf$data	; Daten Adresse der CF
	lda	cfb$com		; Comand aus dem Puffer holen
	cpi	20h		; lesen ?
	jrnz	cfwrsec		; Sprung wenn nicht lesen
cfrdsec:
	ini
	jrnz	cfrdsec
cfrdsec1:
	ini
	jrnz	cfrdsec1
;	inir
;	inir
	jr	cfrwcompl
cfwrsec:
	outi
	jrnz	cfwrsec
cfwrsec1:
	outi
	jrnz	cfwrsec1
;	outir
;	outir
cfrwcompl:
	pop	psw 
	cnz	?bank		; evtl CPU bank wieder ein
cferrcheck:	   
	call	cfrdy		; kommt mit CF Status im Akku zurueck
	ani	01h
	bit	0,a		; CF zeigt auf Bit 0 mit 1 einen Error an
	rz			; ***Normal Ausgang***  -  kein Error vorhanden -
	jmp	reqsense 
	;	jmp	 cferrexit	; reqsense hab ich uebersprungen 
	   
	dseg  ;dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd
   


reqsense:    
        in	cf$error	; Error Informationen holen
	sta	cfb$error	; in Systempage zur Auswertung sichern
	
	

req2:	lda	@ermde		; Fehlermeldung
	ora	a		; zugelassen?
	jrnz	cferrexit 
	call	?pderr		; BIOS Error Meldung
	lhld	operation 
	call	?pmsg 
	lxi	h,errmsg 
	call	?pmsg 
	call	cfconin	
	cpi	'Y'	 
	jz	cfrwrtry	; retry

cferrexit:   
	mvi	a,1 		; mit Errorflag im Akku zurueck
	ret   
    
cfconin:   
	call	?conin
	push	psw 
	mov	c,a 
	call	?cono
	pop	psw 
	cpi	'a'	 
	rc	 
	sui	'a'-'A'	
	ret  
   
operation:   
	ds	2 
readmsg:	 
	db	', CF-Read',0 
writemsg:   
	db	', CF-Write',0 
errmsg:	  
	db	' Retry (Y/N) ?',0

cfmsgs	db	'  Beginn CF-Initialisierung',13,10,0
cfmsge	db	'  Ende   CF-Initialisierung',13,10,0

;----------------------------------------------------------------------------------------------
;       in SYSPAGE.LIB eingefuegt
;
;	CFB$COM		EQU	0FF93H	; CF Command ( RD  WR )	1 Byte
;	CFB$SECTOR	EQU	0FF94H	; CF Sector		1 Byte
;	CFB$CYLINDER	EQU	0FF95H	; CF Cylinder		2 Byte
;	CFB$COUNT	EQU	0FF97H	; CF Count		1 Byte
;	CFB$ERROR	EQU	0FF98H	; Inhalt CF-Errorregister 1 Byte
;
;**********************************************************************************************
;	in CDEF.LIB eingefuegt 
;
;	CFDISK		EQU	ja		; ja, wenn CFdisk da
;	cfdiskboot	equ	NEIN		; ja, wenn Boot des CCP von CF (bioskrnl)
;	                                        ; ausserdem wird Initialisierung der CF
;	                                        ; unterlassen, da bereits vom Bootlader
;	                                        ; erledigt     
;	CF$BASE		EQU	70h		; CF-Basisadresse
;	CF$DATA		EQU	CF$BASE
;	CF$ERROR	EQU	CF$BASE+1
;	CF$COUNT	EQU	CF$BASE+2
;	CF$LBA$0	EQU	CF$BASE+3	
;	CF$LBA$1	EQU	CF$BASE+4
;	CF$LBA$2	EQU	CF$BASE+5
;	CF$LBA$3	EQU	CF$BASE+6
;	CF$STATUS	EQU	CF$BASE+7
;	CF$COMAND	EQU	CF$BASE+7
;
;	cf$cylinder	EQU	511		; Cylinder
;	cf$head		EQU	1		; Koepfe
;	cf$sec$size	EQU	512		; Sektorgroesse
;	cf$sec$nmb	EQU	32		; Anzahl der Sektoren
;
;	cf$spare	EQU	1		; Anzahl Systemtracks zur Verwendung
;						; als alternate track 
;						; fuer jedes logische HD-Laufwerk
;						; ausser 0 im dpb definieren
;
;**********************************************************************************************
;	in DRVTBL.ASM eingefuegt
;
;	dw cfsd0,cfsd1,cfsd2			; 3 Laufwerke CF-Disk

	endif		 			; of IF CFDISK

	end

