	title 'Character I/O handler for PROF-80'

; Character I/O for the Modular CP/M 3 BIOS
;
; letzte Aenderung am: 13.11.1984 (Joachim)



	extrn	@cbnk

	public	?cinit,?ci,?co,?cist,?cost
	public	@ctbl
	public	monon,monoff,intser

	maclib	z80
	maclib	cdef

	maclib	syspage
	maclib	modebaud
	maclib	monvec


max$devices	equ	5	; anzahl der phys. treiber minus 1

	cseg

?cinit:
	mov	b,c		; device nummer in b
	mov	l,c		; lade baudrate der device
	mvi	h,0		; nach c
	dad	h		;
	dad	h		;
	dad	h		;
	lxi	d,@ctbl+7	;
	dad	d		;
	mov	a,m		;
	mov	c,a		;
	lxi	d,cinit$list	; zeige auf liste
	jr	verteiler	; verzweige auf entsprechende routine

?ci:
	lxi	d,ci$list ! mvi h,1ah
	jr	verteiler

?co:
	lxi	d,co$list
	jr	verteiler

?cist:
	lxi	d,cist$list ! mvi h,0
	jr	verteiler

?cost:
	lxi	d,cost$list ! mvi h,0

verteiler:
	mvi	a,max$devices	; unzulaessiger treiber?
	cmp	b		; dann return
	mov	a,h		; in a steht returncode
	rc			;
				; treiber vorhanden => weiter
	call	monon		; schalte EPROM ein ( die meisten Treiber
	mov	l,b		; befinden sich im EPROM)
	mvi	h,0		;
	dad	h		;
	dad	d		; hl zeigt auf treiber adresse
	lxi	d,callr+1	; trage adresse in call ein
	mov	a,m ! stax d	;
	inx 	h ! inx d	;
	mov	a,m ! stax d	;
callr	call	0		;
	call	monoff		; EPROM wieder aus
	ret			; alles ok return zum BDOS

cinit$list:
	dw	softinit
	dw	softinit
	dw	null$init
	dw	null$init
	dw	null$init
	dw	null$init

ci$list:
	dw	duplxin
	dw	null$in
	dw	user1in
	dw	user2in
	dw	grafin
	dw	null$in

co$list
	dw	duplxout
	dw	splxout
	dw	user1out
	dw	user2out
	dw	grafout
	dw	spoolerout

cist$list:
	dw	duplxist
	dw	null$status
	dw	user1ist
	dw	user2ist
	dw	grafist
	dw	null$status

cost$list:
	dw	duplxost
	dw	splxost
	dw	user1ost
	dw	user2ost
	dw	grafost
	dw	grafost

softinit:
	mov	a,c	; wandle cpm 3 baudraten nummer
	xri	0ffh	; in EPROM baudraten nummer
	rar
	ani	07h
	mov	d,a
	mov	a,c
	ani	1
	ral ! ral ! ral
	ora	d
	mov	d,a	; ok, in d steht EPROM bautraten nr.
	mov	a,b	; duplex oder simplex ?
	ora	a
	mov	a,d
	jz	mduplxbaud
	jmp	msplxbaud	

duplxin		jmp	mduplxin
user1in		jmp	muser1in
user2in		jmp	muser2in
grafin		jmp	mgrafin

duplxout	jmp	mduplxout
splxout		jmp	msplxout
user1out	jmp	muser1out
user2out	jmp	muser1out
grafout		mov	a,c ! ani 7fh ! mov c,a ! jmp mgrafout
spoolerout	mov	a,c ! ori 80h ! mov c,a ! jmp mgrafout

duplxist	jmp	mduplxist
user1ist	jmp	muser1ist
user2ist	jmp	muser2ist
grafist		jmp	mgrafist

duplxost	jmp	mduplxost
splxost		jmp	msplxost
user1ost	jmp	muser1ost
user2ost	jmp	muser2ost
grafost		jmp	mgrafost

null$init	ret
null$status	xra a ! ret
null$in		mvi a,1ah ! ret

@ctbl:
	db 'DUPLEX'	; Duplex-Schnittstelle auf PROF
	db mb$in$out+mb$serial+mb$softbaud
	db baud$none	; Baudrate haengt von J5 ab

	db 'SIMPLX'	; Simplex-Schnittstelle auf PROF
	db mb$output+mb$softbaud
	db baud$1200

	db 'USER1 '	; user1 im EPROM
	db mb$in$out
	db baud$none

	db 'USER2 '	; user2 im EPROM
	db mb$in$out
	db baud$none

	db 'GRIP  '	; Grafik-Karte
	db mb$in$out
	db baud$none

	db 'SPOLER'	; GRIP-Spooler
	db mb$output
	db baud$none

	db 0			; table terminator

;
; Hilfsroutinen, die im Common-Bereich liegen muessen
;

monon:		; schalte Monitor-EPROM ein und Stack um

	push	psw		; rette akku
	lda	epromz		; ist EPROM schon eingeschaltet?
	ora	a		; wenn ja Sprung
	jrnz	monon1		;
	inr	a		; 
	sta	epromz		; neue EPROM-Einschalttiefe
	pop	psw		;
	shld	temp2		;
	pop	h		;
	sspd	userstack	; rette userstack
	lxi	sp,monstack	;
	push	h		;
	lhld	temp2		;
				;
	push	psw		; schalte jetzt EPROM ein
	push	b		;
	mvi	b,0		;
	mvi	c,p$ram$table	;
	mvi	a,0		;
	outp	a		;
	mvi	b,10h		;
	outp	a		;
	pop	b		;
	pop	psw		;
	ret			;

monon1	inr	a		;
	sta	epromz		;
	pop	psw		;
	ret			;



monoff:		; schalte Monitor-EPROM aus

	push	psw		;
	lda	epromz		; 
	dcr	a		;
	sta	epromz		;
	jrnz	monoff1		;

	push	b		;
	mvi	b,0		;
	mvi	c,p$ram$table	;
	lda	@cbnk		; setze selektiete
	adi	2		; bank
	outp	a		;
	mvi	b,10h		;
	outp	a		;
	pop	b		;
	pop	psw		;

	shld	temp2		;
	pop	h		;
	lspd	userstack	;
	push	h		;
	lhld	temp2		;
	ret			;

monoff1	pop	psw		;
	ret			;



INTSER:
	;NACH EINEM INTERRUPT UND WENN DIE SOFTSCHNITTSTELLE DIE KONSOLE
	;BEDIENT, WIRD DIESE INTERRUPT-SERVIE-ROUTINE ANGESPROCHEN.
	;SIE LIEST EIN ZEICHEN IN DIE SPEICHER ZELLE UNTER DIE IN$BUFF$ZEIG
	;ZEIGT. IST DER BUFFER VOLL (11 BYTES), WIRD KEIN ZEICHEN
	;MEHR EINGELESEN.
	;
	PUSH	PSW		;
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
	CALL	SOFTIN2		;LESE ZEICHEN EIN
	MOV	C,A		;RETTE ZEICHEN IN C
	LHLD	IN$BUFF$ZEIG	;LADE BUFFER-ZEIGER
	MVI	A,IN$BUFF$END AND 0FFH
	CMP	L		;ZEIGER SCHON AM ENDE?
	JRZ	INT$SERVICE1	;DANN GEHT ZEICHEN VERLOREN
	DCX	H		;SONST LEGE ZEICHEN IN BUFFER
	MOV	M,C		;
	SHLD	IN$BUFF$ZEIG	;UND SETZE ZEIGER NEU
INT$SERVICE1:			;
	POP	H		;
	POP	D		;
	POP	B		;
	POP	PSW		;
	EI			;GEBE INT. FREI
	RETI			;
;
;
;
SOFTIN2:			;
	LHLD	SOFTVERZ	;LADE VERZOEGERUNG
	SRLR	H		;TEILE DURCH ZWEI
	RARR	L		;UM IN DER BIT MITTE ABZUTASTEN
SOFTIN5	DCX	H		;VERZOEGERUNGSSCHLEIFE
	MOV	A,H		;FUER EIN HALBES BIT
	ORA	L		;
	JNZ	SOFTIN5		;
				;
	MVI	B,8		;LESE 8 BITS EIN
SOFTIN3:
	LHLD	SOFTVERZ	;ERST EIN BIT VERZOEGERN <16>
SOFTIN4	DCX	H		;VERZOEGERUNGSSCHLEIFE
	MOV	A,H		;
	ORA	L		;
	JNZ	SOFTIN4		;
				;
	IN	P$IN$LS258$A	;LESE BIT EIN <11>
	ANI	MASK$RX		; <7>
	ADI	0FFH		;SETZE CARRY WENN EINS <7>
	RARR	C		;UND LEGE IN CHARPUF. <8>
	DJNZ	SOFTIN3		;LESE 8 BITS EIN <13>
				;
	MOV	A,C		;ERGEBNISS IN AKKU
	CMA			;NEGIERE, DA LS258 AUCH NEGIERT
SOFTIN7	ANI	7FH		;STRIPP OF PARITY
				;
	PUSH	PSW		;
	LHLD	SOFTVERZ	;WARTE STOP BIT AB
SOFTIN10:
	DCX	H		;
	MOV	A,H		;
	ORA	L		;
	JNZ	SOFTIN10	;
	POP	PSW		;
				;
	RET


userstack	ds	2	;
temp2		ds	2	;
		ds	64	;
monstack:

	end
