{ ========================================================================= }
{ !                   ** FORMATIER-PROGRAMM **                            ! }
{ !                                                                       ! }
{ !  Version 2.0                                                          ! }
{ !  Fuer PROF-180X ,CONITEC-Darmstadt. Von Manfred Oheimer .             ! }
{ !  Letzte Aenderung : 13.6.86                                           ! }
{ ========================================================================= }



procedure formatiere;
var cmdtab     :byte absolute $ff18;
    unit       :byte absolute $ff19;
    track      :byte absolute $ff1a;
    head       :byte absolute $ff1b;
    sektor     :byte absolute $ff1c;
    sektsize   :byte absolute $ff1d;
    eot        :byte absolute $ff1e;
    gapll      :byte absolute $ff1f;
    dtl        :byte absolute $ff20;
    dermsg     :byte absolute $ff2d;
    byps       :byte absolute $2000;
    spt        :byte absolute $2001;
    gpl        :byte absolute $2002;
    densi      :byte absolute $2003;
    cylindernr :byte absolute $2004;
    headid     :byte absolute $2005;
    fillerbyte :byte absolute $2006;
    headfdc    :byte absolute $2007;
    erstsnr    :byte absolute $212c;
    rwstat     :byte absolute $212d;
    scmdtab    :byte absolute $2120;
    sunit      :byte absolute $2121;
    strack     :byte absolute $2122;
    shead      :byte absolute $2123;
    ssektor    :byte absolute $2124;
    ssektsize  :byte absolute $2125;
    seot       :byte absolute $2126;
    sgapll     :byte absolute $2127;
    sdtl       :byte absolute $2128;
    ssectcnt   :byte absolute $2129;
    sdmaadr    :integer absolute $212a;
    sectcnt    :byte absolute $ff46;
    dmaadr     :integer absolute $ff44;
    SEEKPOINTER    :integer absolute $0027;
    RECALPOINTER   :integer absolute $0012;
    MOTOPOINTER    :integer absolute $001e;
    NEXTPOINTER    :integer absolute $002a;
    RESULTPOINTER  :integer absolute $0024;
    CMFDPOINTER    :integer absolute $0021;
    READPOINTER    :integer absolute $0015;
    MINISETPOINTER :integer absolute $008a;
    MAXISETPOINTER :integer absolute $0087;
    POINTOFBIOSCALL:integer;
    JMPTABLEPOINTER:INTEGER;
    skewfakt,sektanz:byte;
    ein,sein  :char;
    headinvers,verifizieren,ok,abbruch,noverify :boolean;


procedure bioscall;
var biospb :byte absolute $212f;     { Belegt aber 8 Byte      }
    biospb2:byte absolute $2131;
    biospb6:byte absolute $2135;
begin
   inline($08/                     { EXAF                    }
          $d9/                     { EXX                     }
          $2a/JMPTABLEPOINTER/     { LD     HL,(JMPTABLEPTR) }
          $22/biospb6/             { SHLD   BIOSPB+6         }
          $3e/$1e/                 { MVI    A,30             }
          $32/biospb/              { STA    BIOSPB           }
          $3e/$02/                 { MVI    A,2              }
          $32/biospb2/             { STA    BIOSPB+2         }
          $0e/$32/                 { MVI    C,50             }
          $11/biospb/              { LXI    D,BIOSPB         }
          $cd/$05/$00/             { CALL   BDOS             }
          $d9/                     { EXX                     }
          $08                      { EXAF                    });
end;

procedure recalibrate;
begin
   jmptablepointer:=addr(recalpointer);
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5            { PUSH ALL } );
   inline($21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9                     { JMP    HL                   } );
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1            { POP ALL  } );
end;


procedure seek(dest:integer);
begin
   track:=dest;   { track:byte nur das lower-byte von dest uebergeben }
   jmptablepointer:=addr(seekpointer);
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5            { PUSH ALL } );
   inline($21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9                     { JMP    HL                   } );
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1            { POP ALL  } );
end;

procedure miniset;
begin
   jmptablepointer:=addr(minisetpointer);
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5            { PUSH ALL } );
   inline($21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9                     { JMP    HL                   } );
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1            { POP ALL  } );
end;
procedure maxiset;
begin
   jmptablepointer:=addr(maxisetpointer);
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5            { PUSH ALL } );
   inline($21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9                     { JMP    HL                   } );
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1            { POP ALL  } );
end;

procedure sendprecomp(compwert:byte);
begin
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5            { PUSH ALL } );
   inline($3a/compwert/           { LDA    COMPWERT             }
          $4f/                    { MOV    C,A                  }
          $e6/$01/                { ANI    01h                  }
          $f6/$02/                { ORI    PAD$M0               }
          $d3/$d8/                { OUT    P$LS259              }
          $79/                    { MOV    A,C                  }
          $0f/                    { RRC                         }
          $e6/$01/                { ANI    01h                  }
          $f6/$04/                { ORI    PAD$M1               }
          $D3/$D8/                { OUT    P$LS259              }
          $79/                    { MOV    A,C                  }
          $0f/                    { RRC                         }
          $0f/                    { RRC                         }
          $e6/$01/                { ANI    01h                  }
          $f6/$00/                { ORI    PAD$DATA             }
          $d3/$d8                 { OUT    P$LS259              } );
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1            { POP ALL  } );
end;

procedure spcdnondma;
var biospb :byte absolute $212f;     { Belegt aber 8 Byte      }
    biospb2:byte absolute $2131;
    biospb6:byte absolute $2135;
begin
   JMPTABLEPOINTER:=addr(CMFDPOINTER);
   inline($2a/$19/$ff/            { RETTEN CMDTAB (2-BYTES )    }
          $e5/                    { PUSH HL                     }
          $21/$00/$01/            { NON-DMA--> HL               }
          $01/$03/$03/            { FDD-OPCODE + ANZ-BYTE       }
          $22/$19/$ff/            { HL --> CMDTAB               }
          $08/                     { EXAF    anfang bioscall }
          $d9/                     { EXX                     }
          $2a/JMPTABLEPOINTER/     { LD     HL,(JMPTABLEPTR) }
          $22/biospb6/             { SHLD   BIOSPB+6         }
          $3e/$1e/                 { MVI    A,30             }
          $32/biospb/              { STA    BIOSPB           }
          $3e/$02/                 { MVI    A,2              }
          $32/biospb2/             { STA    BIOSPB+2         }
          $0e/$32/                 { MVI    C,50             }
          $11/biospb/              { LXI    D,BIOSPB         }
          $cd/$05/$00/             { CALL   BDOS             }
          $d9/                     { EXX                     }
          $08/                     { EXAF   ende bioscall    }
          $e1/                    { POP HL                      }
          $22/$19/$ff);           { RESTORE CMDTAB              }
end;



procedure gencomdat;
var temp,i,found:integer;
    wert:byte;
    mm:mima;
begin
   with formdat[aktformnr] do
      begin
         sektanz:=wandel(sektoranz);spt:=sektanz;
         skewfakt:=wandel(skew);
         temp:=wandel(bps);
         case temp of
         128  : byps:=0;
         256  : byps:=1;
         512  : byps:=2;
         1024 : byps:=3;
         end;
         gpl:=wandel(formgap);
         fillerbyte:=hwandel(fillbyte);
         erstsnr:=wandel(sektnam);
         if skewfakt=0 then for i:=0 to (sektanz-1) do
                       begin
                          if idtable[i]='  ' then idtable[i]:=' 0';
                          bidtable[i]:=wandel(idtable[i])
                       end
                 else genidtable(skewfakt,sektanz,wandel(sektnam));
         if minimaxi='MAXI' then maxiset
                            else miniset;
         if minimaxi='MAXI' then mm:=maxi else mm:=mini;
         sendprecomp(1);
   end;
end;

procedure testwriteprot;
var wrprot:byte absolute $212e;
    once:boolean;
    ein:char;
begin
 once:=false;
 repeat
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5/    { PUSH ALL }
          $01/$04/$02/
          $21/motopointer/        { ADRESSE DER MON-ROUTINE     }
          $22/jmptablepointer/    { IN JMPTABLEPOINTER          }
          $21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9/                    { JMP    HL                   }
          $21/nextpointer/        { ADRESSE DER MON-ROUTINE     }
          $22/jmptablepointer/    { IN JMPTABLEPOINTER          }
          $21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9/                    { JMP    HL                   }
          $cb/$77/$ca/*+10/
          $3e/$ff/$32/wrprot/$c3/*+7/$3e/$00/$32/wrprot);
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1);
       { wenn WRPROT=FF dann ist diskette schreibgeschuetzt }
   if not(wrprot=0) then begin
                feldaendern(20,14,35,'SCHREIBSCHUTZ ENTFERNT? (J\N) :');
                      read(kbd,ein);ein:=upcase(ein);write(ein);
                      if ein='J' then once:=true
                                 else begin abbruch:=true;once:=false end;
                         end
                   else once:=false;
 until not(once);
end;


procedure fat;    (* Format a Track *)
begin
   { epromon }
   inline($f5/$c5/$d5/$e5/$dd/$e5/$fd/$e5/ { PUSH ALL }
          $2a/$35/$ff/                     { LHLD    track      }
          $e5/                             { PUSH    H          }
          $2a/$37/$ff/                     { LHLD    sektor     }
          $e5/                             { PUSH    H          }
          $21/byps/                        { LXI     H,byps     }
          $4e/                             { LD      C,(HL)     }
          $21/spt/                         { LXI     H,spt      }
          $46/                             { LD      B,(HL)     }
          $21/track/$71/$21/head/$70/      { SBCD    track      }
          $21/gpl/                         { LXI     H,gpl      }
          $4e/                             { LD      C,(HL)     }
          $21/fillerbyte/                  { LXI     H,fillerby }
          $46/                             { LD      B,(HL)     }
          $21/sektor/$71/$21/sektsize/$70/ { SBCD    sektor     }
          $3a/densi/                       { LDA     densi      }
          $0e/$0d/                         { MVI     C,0dh      }
          $b1/                             { ORA     C          }
          $4f/                             { MOV     C,A        }
          $06/$06/                         { MVI     B,06h      }

          (* formatieren *)

          $21/motopointer/        { ADRESSE DER MON-ROUTINE     }
          $22/jmptablepointer/    { IN JMPTABLEPOINTER          }
          $21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9/                    { JMP    HL                   }
          $3a/spt/                         { LDA     spt        }
          $57/                             { MOV     d,a        }
          $21/bidtable/                    { LXI     H,bidtable }
          $db/$dc/$07/$d2/*-4/             { LOOP    WFR        }
          $3a/cylindernr/                  { LDA     cylindernr }
          $d3/$dd/                         { OUT     FDD        }
          $db/$dc/$07/$d2/*-4/             {   WFR              }
          $3a/headid/                      { LDA     headid     }
          $d3/$dd/                         { OUT     FDD        }
          $db/$dc/$07/$d2/*-4/             {   WFR              }
          $7e/                             { MOV     A,M        }
          $d3/$dd/                         { OUT     FDD        }
          $db/$dc/$07/$d2/*-4/             {   WFR              }
          $3a/byps/                        { LDA     byps       }
          $d3/$dd/                         { OUT     FDD        }
          $23/                             { INX     H          }
          $15/                             { DCR     D          }
          $c2/*-45/                        { JNZ     LOOP       }
          $21/resultpointer/      { ADRESSE DER MON-ROUTINE     }
          $22/jmptablepointer/    { IN JMPTABLEPOINTER          }
          $21/*+7/                { LD     HL,*+7               }
          $e5/                    { PUSH   HL                   }
          $2a/pointofbioscall/    { LD     HL,(POINTOFBIOSCALL) }
          $e9/                    { JMP    HL                   }
          $e1/                             { POP     H          }
          $22/$37/$ff/                     { SHLD    sektor     }
          $e1/                             { POP     H          }
          $22/$35/$ff                      { SHLD    track      });

   { epromoff }
   inline($fd/$e1/$dd/$e1/$e1/$d1/$c1/$f1);
end;