	title 'Character I/O handler for PROF-180X'

; Character I/O for the Modular PROF-180 CP/M 3 BIOS
;
; letzte Aenderung am: 05.11.1986 (Joachim)

	cseg

	extrn	@cbnk

	public	?cinit,?ci,?co,?cist,?cost
	public	@ctbl
	public	monon,monoff

	maclib	hd64180

	maclib	pdef

	maclib	psys

	maclib	modebaud

	maclib	pvec

	maclib	pkonfig


max$devices	equ	6	; anzahl der phys. treiber minus 1

	cseg

?cinit:
	mov	b,c		; device nummer in b
	mov	l,c		; lade baudrate der device
	mvi	h,0		; nach c
	dad	h		;
	dad	h		;
	dad	h		;
	lxi	d,@ctbl+7	;
	dad	d		;
	mov	a,m		;
	mov	c,a		;
	lxi	d,cinit$list	; zeige auf liste
	jr	verteiler	; verzweige auf entsprechende routine

?ci:
	lxi	d,ci$list ! mvi h,1ah
	jr	verteiler

?co:
	lxi	d,co$list
	jr	verteiler

?cist:
	lxi	d,cist$list ! mvi h,0
	jr	verteiler

?cost:
	lxi	d,cost$list ! mvi h,0

verteiler:
	mvi	a,max$devices	; unzulaessiger treiber?
	cmp	b		; dann return
	mov	a,h		; in a steht returncode
	rc			;
				; treiber vorhanden => weiter
	call	monon		; schalte EPROM ein ( die meisten Treiber
	mov	l,b		; befinden sich im EPROM)
	mvi	h,0		;
	dad	h		;
	dad	d		; hl zeigt auf treiber adresse
	lxi	d,callr+1	; trage adresse in call ein
	mov	a,m ! stax d	;
	inx 	h ! inx d	;
	mov	a,m ! stax d	;
callr	call	0		;
	call	monoff		; EPROM wieder aus
	ret			; alles ok return zum BDOS



@ctbl:
	db 'V-24-A'	; Haupt V-24 auf PROF-180X
	db mb$in$out+mb$serial+mb$softbaud
	db baud$none	; Baudrate haengt von Monitor ab

	db 'V-24-B'	; zweite V-24 auf PROF-180X
	db mb$in$out+mb$serial+mb$softbaud
	db baud$none	; Baudrate haengt von Monitor ab

	db 'CENT  '	; Centronix-Schnittstelle auf PROF-180X
	db mb$output+mb$softbaud
	db baud$none

	db 'RESERV'	; grade im EPROM
	db mb$in$out
	db baud$none

	db 'USER  '	; user im EPROM
	db mb$in$out
	db baud$none

	db 'GRIP  '	; Grafik-Karte
	db mb$in$out
	db baud$none

	db 'SPOLER'	; GRIP-Spooler
	db mb$output
	db baud$none

	db 0			; table terminator

;
; Hilfsroutinen, die im Common-Bereich liegen muessen
;

monon:		; schalte Monitor-EPROM ein und Stack um

	push	psw		; rette akku
	lda	epromz		; ist EPROM schon eingeschaltet?
	ora	a		; wenn ja Sprung
	jrnz	monon1		;
	inr	a		; 
	sta	epromz		; neue EPROM-Einschalttiefe
	pop	psw		;
	shld	temp2		;
	pop	h		;
	sspd	userstack	; rette userstack
	lxi	sp,monstack	;
	push	h		;
	lhld	temp2		;
				;
	push	psw		; schalte jetzt EPROM ein
	xra	a		;
	out0	bbr,a		;
	pop	psw		;
	ret			;

monon1	inr	a		;
	sta	epromz		;
	pop	psw		;
	ret			;



monoff:		; schalte Monitor-EPROM aus

	push	psw		;
	lda	epromz		; 
	dcr	a		;
	sta	epromz		;
	jrnz	monoff1		;

	lda	@cbnk		; setze selektiete Bank
	rrc ! rrc		; ****  ACHTUNG ****
	ani	40h		;
	out0	bbr,a		;
	pop	psw		;

	shld	temp2		;
	pop	h		;
	lspd	userstack	;
	push	h		;
	lhld	temp2		;
	ret			;

monoff1	pop	psw		;
	ret			;


userstack	ds	2	;
temp2		ds	2	;
		ds	64	;
monstack:

	dseg

	; chracter treiber koennen im
	; gebankten teil liegen, da mit
	; verteiler umgeschalten wurde

cinit$list:
	dw	ser1init
	dw	ser2init
	dw	null$init
	dw	null$init
	dw	null$init
	dw	null$init
	dw	null$init

ci$list:
	dw	mduplxin
	dw	ser2in
	dw	null$in
	dw	mgradein
	dw	muserin
	if	ginmask
	dw	grafin
	else
	dw	mgrafin
	endif
	dw	null$in

co$list
	dw	mduplxout
	dw	ser2out
	dw	centout
	dw	mgradeout
	dw	muserout
	if	goutmask
	dw	grafout
	else
	dw	mgrafout
	endif
	dw	spoolerout

cist$list:
	dw	mduplxist
	dw	ser2ist
	dw	null$status
	dw	mgradeist
	dw	muserist
	dw	mgrafist
	dw	null$status

cost$list:
	dw	mduplxost
	dw	ser2ost
	dw	centost
	dw	mgradeost
	dw	muserost
	dw	mgrafost
	dw	mgrafost


		if	ginmask
grafin:		call	mgrafin
		ani	07fh
		ret
		endif

		if	goutmask
grafout:	mov	a,c
		ani	07fh
		mov	c,a
		jmp	mgrafout
		endif

ser1init	mov	a,c ! jmp mser1init
ser2init	mov	a,c ! jmp mser2init

spoolerout	mov	a,c ! ori 80h ! mov c,a ! jmp mgrafout


null$init	ret
null$status	xra a ! ret
null$in		mvi a,1ah ! ret


ser2in:		in0	a,stat1
		ani	80h
		jrz	ser2in
		in0	a,rdr1
		ret

ser2ist:	in0	a,stat1
		ani	80h
		rz
		ori	0ffh
		ret

ser2out:	in0	a,stat1
		ani	02h
		jrz	ser2out
		mov	a,c
		out0	tdr1,a
		ret

ser2ost:	in0	a,stat1
		ani	02h
		rz
		ori	0ffh
		ret

centout:	xra	a
		in	p$in$ls258
		ani	01h
		jrz	centout
		mov	a,c
		out	centronics
		ret

centost:	xra	a
		in	p$in$ls258
		ani	01h
		rz
		ori	0ffh
		ret

	end
