	title 'bank & move module for PROF-180 CP/M 3 linked BIOS'

	; letzte Aenderung am:
	; 23.11.1985 (Joachim)	

	cseg

	public	?move,?xmove,?bank
	public	dmatrans,adrtab,ibtab
	extrn	@cbnk

	maclib	hd64180

	maclib	pdef

	maclib	psys

	maclib	pkonfig

?xmove:
	sbcd	sbank		; lege source und dest. bank ab
	mvi	a,0ffh		; setze flag fuer xmove
	sta	x$flg		;
	ret

sbank	db	0		; source bank fuer xmove
dbank	db	0		; destination bank fuer xmove
x$flg	db	0		; flag fuer xmove aktiv
sadrs	dw	0		; zwischenspeicher fuer xmove
dadrs	dw	0		;
length	dw	0		;

?move:
	xchg			; we are passed source in DE and dest in HL
	lda	x$flg		; xmove aktiv?
	inr	a		;
	jrz	xmv		; sprung wenn ja
	ldir			; use Z80 block move instruction
	xchg			; need next addresses in same regs
	ret

xmv:	sded	dadrs		; save destination
	sbcd	length		; save length
	lda	sbank		; switch to source bank
	call	?bank		;
	lxi	d,xmv$buff	; ziel ist buffer
	ldir			; uebertrage
	shld	sadrs		;
	lda	dbank		; switch to dest. bank
	call	?bank		;
	lded	dadrs		;
	lbcd	length		;
	lxi	h,xmv$buff	;
	ldir			;
	lda	@cbnk		; orginal bank ein
	call	?bank		;
	xchg			;
	lded	sadrs		;
	xra	a		;
	sta	x$flg		;
	ret

xmv$buff:	ds	128

?bank:
	sta	current$bank	;
	if	tpages ne 0	; 
	cpi	ibno		;
	jrnc	ex$bank		; sprung wenn bank in Turbo RAM liegt
	endif			;
	push	h		; rette hl
	push	d		; rette de
	mov	e,a		; lade basisadresse der bank in akku
	mvi	d,0		;
	lxi	h,ibtab		;
	dad	d		;
	mov	a,m		;
	pop	d		; alter inhalt von hl und de 
	pop	h		;
	out0	bbr,a		; setze mmu
	mvi	a,pad$mm1	; schalte auf jeden Fall
	out	p$ls259		; Turbo RAM aus
	ret			;
				;
	if	tpages ne 0	;
ex$bank:			;
	adi	40h-ibno	;
	push	psw		; rette bankbeschreiber
	ani	01110000b	; maskiere hd64180 mmu daten
	out0	bbr,a		; setze hd64180 mmu
	pop	psw		; lade bankbeschreiber
	ani	00001111b	; maskiere Turbo RAM mmu daten
	push	d		; rette register
	push	b		;
	mvi	c,tram$mem	; lade c mit mmuport
	mvi	d,10h		; lade increment nach d
	mov	e,a		; lade mmudaten nach e
	mvi	a,0f0h		; lade mmukachel in akku
exbl:	add	d		; erhoehe akku um 10h
	mov	b,a		; lade mmukachel nach b
	outp	e		; lade mmukachel mit mmudaten
	cpi	070h		; ende erreicht ?
	jrnz	exbl		; sprung wenn nein
	pop	b		; alter register inhalt
	pop	d		;
	mvi	a,pad$mm1 or 1	; schalte Turbo RAM ein
	out	p$ls259		;
	in	tram$dma	;
	ret			;
	endif			;

ibtab:				; ibtab gibt die Basisadressen der
				; internen Banks an. Die physikalische
				; Anfangsadresse der internen Bank
				; ergibt sich, wenn man den ibtab
				; Eintrag mit 1000h multipliziert.
				;
	db	00h,40h,10h,18h	;
	db	20h,28h,30h,38h	;
	db	50h,58h,60h,68h	;
	db	70h,78h		;

ibno:	equ	$-ibtab		; anzahl der internen banks

dmatrans:			; dma transfer, source und destination
				; daten stehen in @adrtab.
	lxi	h,adrtab	; zeiger auf datenliste.
	lxi	b,sar0l+(8*256)	; port und laenge angeben.
	otimr			; spezial ausgabe hd64180
	mov	a,m		; dcntl byte in akku
	out0	dmode,a		; und ausgeben.
	mvi	a,01100000b	; starte dma transfer
	out0	dstat,a		;
	ret			;
				;
adrtab:				;
	db	0,0,0,0,0,0,0,0	; datenliste
	db	000000010b	;

	end
