	title	 'PROF-180X Multi density diskette handler'

;
;	Disk I/O Module fuer PROF-180X
;
;		Letzte Aenderung am 03.03.1987 (Joachim)
;

	maclib pdef
;
	maclib cpm3
;
	maclib hd64180
;
	maclib pvec
;
	maclib psys
;
	maclib pkonfig

	dseg


    ; Disk drive dispatching tables for linked BIOS

	public	fdsd0,fdsd1,fdsd2,fdsd3
	if kdrive$switch
	public	fdsdk
	endif


    ; Variables containing parameters passed by BDOS

	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect
	extrn	@dbnk,@cbnk

    ; System Control Block variables

	extrn	@ermde		; BDOS error mode

    ; Utility routines in standard BIOS

	extrn	?pmsg		; print message @<HL> up to 00, saves <BC> & <DE>
	extrn	?conin,?cono	; con in and out
	extrn	?const		; get console status
	extrn	ibtab		; Bank Anfangsadressen Tabelle
	extrn	ciecho		; lese zeichen ein
	extrn	?bank		; Bankumschaltung


     ; Disk Type Block

	extrn	dtypeb		; die disketten format definitionen
				; befinden sich in PD.ASM

dpb$off	equ	08h		; bytes bis zum dph
dpblng	equ	11h		; laenge dph
l$dtyl	equ	30h		; laenge eines eintrags

;	common control characters

cr	equ 13
lf	equ 10
bell	equ 7

dummy	equ 9999h

    ; Extended Disk Parameter Headers (XPDHs)

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init
	db	0,0		; relative drive zero, may be changed
fdsd0	dph     dummy,dpb0,128,180

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	1,0		; relative drive one, may be changed
fdsd1	dph	dummy,dpb1,128,180

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	2,0		; relative drive two, may be changed
fdsd2	dph	dummy,dpb2,128,180

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	3,0		; relative drive three, may be changed
fdsd3	dph	dummy,dpb3,128,180

	if	kdrive$switch
	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	0,0		; relative drive zero, may be changed
fdsdk	dph	dummy,dpbk,128,180
	endif

	cseg	; DPB must be resident

dpb0	dpb 1024,9,160,2048,512,4	; dummy dphs fuer GENCPM
dpb1	dpb 1024,9,160,2048,512,4	; und platzhalter fuer
dpb2	dpb 1024,9,160,2048,512,4	; richtigen dph, der von
dpb3	dpb 1024,9,160,2048,512,4	; fd$login reinkopiert wird
	if	kdrive$switch		;
dpbk	dpb 1024,9,160,2048,512,4	;
	endif				;

COMP$DAT:			;DIESE ROUTINE MUSS IM COMMON-BEREICH
				;LIEGEN. SIE WIRD LEDIGLICH BEIM LESEN
				;UND SCHREIBEN VON DISKETTEN MIT INVERTIERTEN
				;DATEN BENOETIGT.
				;
	PUSH	PSW		;
	LHLD	@DMA		;LOAD DMA - ADDRESS
	PUSH	H		;
	LDA	@DBNK		;SWITCH TO DMA-BANK
	CALL	?BANK		;
	LXI	H,040H		;CALCULATE SECTOR - SIZE
	LDA	SECSZ		;
	INR	A		;
	MOV	B,A		;
CALC	DAD	H		;SECTORSIZE = (2^(SECSZ+1))*040H
	DJNZ	CALC		;
	POP	D		;SECTORSIZE IN HL, DMA IN DE
COMPL	LDAX	D		;COMPLEMENT (HL) BYTES STARTING AT (DE)
	CMA			;
	STAX	D		;
	DCX	H		;
	INX	D		;
	MOV	A,H		;
	ORA	L		;
	JRNZ	COMPL		;
	CALL	?BANK		;SCHALTE ZURUECK AUF BANK 0
	POP	PSW
	RET
;
;


	dseg

; Disk I/O routines for standardized BIOS interface

; Initialization entry point.

;		called for first time initialization.


fd$init:
	lxi	h,dtypeb		; setze Zeiger auf
	shld	typelist		; dtypeb.
	lxi	h,dtblg			; setze laenge der dtypeb
	shld	ldtl			; in der systempage.
					;
	lxi	h,dphtab		; setze die relativen
	if	kdrive$switch		;
	mvi	b,5			; laufwerksnummern entsprechend
	else				;
	mvi	b,4			;
	endif
fd$init1:				; der definition im monitor.
	mov	a,b			; abbildung log. => phys.
	dcr	a			; laufwerk.
	call	mdrive$trans		;
	mov	e,m			; lade zeiger auf dph-2
	inx	h			;
	mov	d,m			;
	inx	h			;
	stax	d			; setze relatives laufwerk.
	djnz	fd$init1		;
fd$init0:				;
	ret				;
					;
dphtab:					;
	if	kdrive$switch		;
	dw	fdsdk-2			;
	endif				;
	dw	fdsd3-2			; tabelle mit zeigern auf
	dw	fdsd2-2			; dph-2 (relative drive).
	dw	fdsd1-2			;
	dw	fdsd0-2			;



fd$login:
		; This entry is called when a logical drive is about to
		; be logged into for the purpose of density determination.

		; It may adjust the parameters contained in the disk
		; parameter header pointed at by <DE>

	pushix			; save index register
	pushiy			;
	push	d		; save pointer to dph
	call	test$format	; test disk format
	popiy			; lade dph pointer in indexregister y
	cpi	0ffh		; disk not correct
	jrz	disk$not$korr	; dann sprung
	sty	a,-1		; setzte disktyp in dph fest
	pushix			; kopiere dph
	pop	h		;
	lxi	d,dpb$off	;
	dad	d		; in hl adresse des richtigen dpb
	ldy	e,12		; lade ziel adresse
	ldy	d,13		;
	lxi	b,dpblng	;
	ldir			; kopiere
				; wegen aufbau von dtypeb
				; zeigt hl jetzt auf sektortranstabelle
	mov	e,m		;
	inx	h		;
	mov	d,m		;
	sty	e,0		; schreibe adresse der sektortranstabelle
	sty	d,1		; in dph

	lda	login		; Teste, ob der Formatname
	ani	001h		; beim login angezeigt werden soll.
	jrz	nologmsg	;
	inx	h		;
	inx	h		;
	inx	h		; HL zeigt jetzt auf Formatnamen
	lxi	d,formtxt	; kopiere Formatnamen in logintxt
	lxi	b,16		;
	ldir			;
	lxi	h,logintxt	; gebe Login Text aus
	call	?pmsg		;
nologmsg:
	popiy			; restore index register
	popix			;
	ret			;

disk$not$korr:			; setze stack so, dass hl=0 
				; wenn seldsk zum bdos zurueckkehrt
	popiy			;
	popix			;
	pop	d		; returnadresse
	pop	h		; dph adresse
	lxi	h,0		; setze dph adresse auf 0 (disk nicht erkennbar)
	push	h		; stack wieder herstellen
	push	d		;
	ret			;

logintxt:	db	0dh,0ah
		db	'login format => '
formtxt:	db	'0123456789ABCDEF'
		db	' ',0dh,0ah,0ah,0

; disk READ and WRITE entry points.

		; these entries are called with the following arguments:

			; relative drive number in @rdrv (8 bits)
			; absolute drive number in @adrv (8 bits)
			; disk transfer address in @dma (16 bits)
			; disk transfer bank	in @dbnk (8 bits)
			; disk track address	in @trk (16 bits)
			; disk sector address	in @sect (16 bits)
			; pointer to XDPH in <DE>

		; they transfer the appropriate data, perform retries
		; if necessary, then return an error code in <A>
fd$write:
	mvi	a,0ffh		;
	jr	rwcom		;


fd$read:
	xra	a		;
rwcom:
	pushix			; save index register
	pushiy			;
	sta	roderw		; read oder write
	xchg			; save dph adress
	shld	current$dph	;
more$retries:			;
	mvi	a,0ffh		; unterdruecke fehlermeldung
	sta	dermsg		;
	mvi	a,5		; fuenf versuche
	sta	rwretry		;
				;
	call	rwcom1		; lesen oder schreiben
				;
	ora	a		; fehler?
	jrz	rwcom3		; sprung wenn nein
	lda	rest+1		; war diskette write protect?
	ani	2		;
	jrnz	rwcom3		; ja, fehlercode 2 (zufall)
	call	test$format	; hat sich das format geaendert?
	lhld	current$dph	;
	dcx	h		;
	cmp	m		; format gleich ?
	mvi	a,0ffh		;
	jrnz	rwcom3		; sprung wenn formatwechsel
	lda	@ermde		; fehlermeldung zugelassen?
	sta	dermsg		;
				;
	call	rwcom1		; zweiter lese-schreib-versuch
				;
	ora	a		;
	jrz	rwcom3		;
	lda	@ermde		;
	ora	a		;
	jrnz	rwcom6		;
	lxi	h,retrymsg	;
	call	?pmsg		;
	call	ciecho		;
	cpi	'Y'		;
	jrz	more$retries	;
rwcom6	mvi	a,1		;
rwcom3	popiy			; restore index register
	popix			;
	ret			;



rwcom1:				; Lese/Schreib-Kern
	if	kdrive$switch	;
	call	chchg		; aufruf nur wenn Pseudo-LW. K vorhanden
	endif			;
	call	setup		; Setze Diskettenparameter / IX
	call	setmem		; 
	lda	roderw		;
				;
	bitx	3,3		; Invertier Flag gesetzt ?
	jrz	rwcom12		; wenn nein, dann nur lesen/schreiben
	lxi	h,comp$dat	; Invertier Routine vor eigentliche
	push	h		; RET-Adresse setzen
	ora	a		;
	cnz	comp$dat	; Falls Schreib-Befehl vorher ebenfalls
rwcom12:			; invertieren
	ora	a		;
				;
	jz	mread		; Alle Daten sind gesetzt, lesen oder
	jmp	mwrite		; schreiben mit Monitor-Routinen




	if	kdrive$switch	;
chchg:				; dieses unterprogramm prueft, ob
				; ein wechsel zwischen laufwerk A
				; und dem dummy laufwerk (K) stattgefunden
				; hat. wenn ja wird zum diskwechsel
				; aufgefordert und eine bestaetigung
				; des bedieners erwartet.
				;
	lda	@adrv		; teste ob aktuelles drive gleich drive A
	cpi	0		;
	jrz	chchg1		; sprung wenn ja.
	cpi	10		; teste ob aktuelles drive gleich drive K
	rnz			; return wenn nein
chchg1: mov	c,a		;
	lda	last$ch$drive	; war vorher laufwerks
	cmp	c		; wechsel ?
	rz			; return wenn nein.
	mov	a,c		;
	sta	last$ch$drive	; fuer naechsten zugriff
	adi	'A'		; ergaenze text
	sta	chtxt2		;
	lxi	h,chtxt1	; gebe text zum
	call	?pmsg		; wechseln der disks aus.
	call	?conin		; warte auf eingabe
	ret			;

chtxt1:	db	0dh,0ah,'insert disk '
chtxt2:	db	0
	db	', then press any key'
	db	0dh,0ah,0

last$ch$drive:
	db	0
	endif


retrymsg:
	db	10,13,' retry (Y/N) ?',0


setup:
				; setze alle parameter in CMDTAB.
				; setze 9229 auf mini/maxi betrieb.
				; setze writeprecompensation byte.
				;
	lhld	current$dph	; zeiger auf plattentyp setzen
	dcx	h		;
	mov	l,m		; rel. eintrag von dtypeb steht in l
	mvi	h,l$dtyl	; laenge eines eintrages nach h
	mult	h		; multipliziere beide werte
	lxi	d,dtypeb	;
	dad	d		; hl zeigt auf richtigen dtypeb eintrag
	push	h		; bringe zeiger
	popix			; nach indexregister x
	bitx	5,0		; teste auf mini/maxi bit
	jrz	setup1		;
	call	mminiset	; wenn null dann mini frequenz einstellen
	jr	setup2		;
setup1	call	mmaxiset	; wenn eins dann maxi frequenz einstellen
setup2	ldx	c,0		; setze diskformat in cmdtab
	mov	a,c		; setze mfm bit
	ani	01000000b	;
	sta	cmdtab		;
	mov	a,c		; setze sektorgroesse
	ani	00000011b	;
	sta	secsz		;
	mvi	a,0ffh		; setze dtl auf 0ffh wenn sektor groesser 128
	jrnz	setup3		;
	mvi	a,80h		; setze dtl auf 000h wenn sektor gleich 128
setup3	sta	dtll		;
	ldx	a,2		; setze eot geich letztem sektor
	sta	eot		;
	ldx	a,5		; setze gap laenge
	sta	gapll		;
	ldx	a,3		; setze writeprecompensation
	ani	00000111b	;
	sta	write$precom	;
	ldx	a,7		; setze erste spur mit
	sta	precom$begin	; writeprecompensation
	lda	@rdrv		; setze laufwerk
	ani	00000011b	;
	sta	unit		;
				; setze spur sektor und head
	lda	@trk		; lade spur nach
	mov	c,a		; register c
	lda	@sect		; lade sektor nach
	mov	b,a		; register b
	ldx	a,4		; welche track reihenfolge (VERFAHREN) ?
	ani	00000111b	; 
	jrz	ttrans0		; VERFAHREN 1
	cpi	1		;
	jrz	ttrans1		; VERFAHREN 2
	cpi	2		;
	jrz	ttrans2		; VERFAHREN 3
	cpi	3		;
	jrz	ttrans3		; VERFAHREN 4
				; wenn Bit2 gesetzt, dann
	jr	ttrans4		; VERFAHREN 5
				;
ttrans0:			; VERFAHREN 1 spur umwandlung, es gilt:
				; eine spur besteht aus vorder- und
				; rueckseite. das oberste bit der sektor-
				; angabe gibt die seite an. dieses verfahren
				; wurde bei prof-80 ausschliesslich verwendet.
				; einseitige prof-80 formate lassen sich
				; gleichwertig mit VERFAHREN 1, 3
				; oder 4 verwirklichen. fuer zweiseitige
				; prof-80 formate sind VERFAHREN 1 und 2
				; moeglich, VERFAHREN 2 ist jedoch guenstiger,
				; da sektran-tabelle um faktor 2 kleiner wird.
				; mit VERFAHREN 1 lassen sich exotische
				; formate mit beliebig wechselnden sektoren
				; auf vorder- und rueckseite verwirklichen.
				;
	mov	d,b		; sektor nach reg. d
	mov	a,b		; und akku kopieren.
	ani	01111111b	; blende oberstes bit aus
	mov	b,a		; ergibt richtiger sektor.
	mov	a,d		; oberstes bit gibt seite an
	rlc			; also schiebe oberstes bit in unterstes
	ani	00000001b	; und maskiere es.
	jr	setup4		;
				;
ttrans1:			; VERFAHREN 2 spur umwandlung, es gilt:
				; v0,r0,v1,r1,........,vn,rn
				;
	mov	d,c		; kopiere spur in reg. c
	mov	a,c		; und in akku.
	rrc			; teile spur durch 2
	ani	01111111b	; und lege neue spur
	mov	c,a		; wieder in c ab.
	mov	a,d		; head gleich
	ani	00000001b	; unterstem altspur bit.
	jr	setup4		; weiter bei setup4
				;
ttrans2:			; VERFAHREN 3 spur umwandlung, es gilt:
				; v0,v1,........vn,r0,r1,......rn
				;
	ldx	a,6		; lade anzahl der spuren einer seite nach a.
	mov	d,a		; kopiere anzahl der spuren nach reg. d
	dcr	a		; spuren beginnen mit null, 1 weniger
	cmp	c		; ist aktuelle spur groesser als letzte spur ?
	mvi	a,0		; nein, dann seite 0
	jrnc	setup4		; und weiter.
	mov	a,c		; sonst rueckseite
	sub	d		; bei spur 0 weiter
	mov	c,a		;
	mvi	a,1		; und seite eins anwaehlen.
	jr	setup4		;
				;
ttrans3:			; VERFAHREN 4 spur umwandlung, es gilt:
				; v0,v1,......,vn,rn,rn-1,.......,r0
				;
	ldx	a,6		; lade anzahl der spuren einer seite nach a.
	mov	d,a		; kopiere anzahl nach reg d.
	dcr	a		; eins weniger.
	cmp	c		; ist aktuelle spur groesser als letzte spur ?
	mvi	a,0		; nein, dann seite 0
	jrnc	setup4		; und weiter.
	mov	a,d		; anzahl der spuren nach a
	add	d		; verdoppeln
	dcr	a		; und weniger eins.
	sub	c		; ziehe aktuelle spur ab
	mov	c,a		; ergibt spurnr. auf rueckseite.
	mvi	a,1		; setzte rueckseite.
	jr	setup4		;
				;
ttrans4:			; VERFAHREN 5 spur umwandlung. 
				; Es wird kein fester Algorithmus verwendet,
				; sondern eine Trackuebersetzungstabelle
				; herangezogen. Byte 27 und 28 des
				; Disktypelisteintrags zeigen auf die gueltige
				; Uebersetzungstabelle. Ist Bit8 eines Eintrages
				; in der Trackuebersetzungstabelle gesetzt,
				; dann wird die Rueckseitenspur verwendet.
				;
	ldx	l,27		; lade zeiger auf trackuebersetungstabelle
	ldx	h,28		; nach hl.
	mov	e,c		; setze zeiger auf relativen eintrag
	mvi	d,0		; zur gewuenschten spur.
	dad	d		; ok, hl zeigt auf richtige spur.
	mov	a,m		; lade nach a
	ani	01111111b	; und blende rueckseitenbit aus.
	mov	c,a		; spur nach c.
	mov	a,m		; rueckseitenbit in akku.
	rlc			;
	ani	00000001b	;
	jr	setup4		;
				;
setup4:				; trage die aus dem jeweiligen VERFAHREN
				; gewonnenen Werte in die CMDTAB ein.
				;
	ora	a		; 
	jrz	setup5		;
				;
	bitx	4,4		; headbit auf rueckseite
	jrnz	setup6		;
	mvi	a,00000010b	;
	jr	setup6		;
				;
setup5:	bitx	4,0		; headbit auf vorderseite
	jrz	setup6		;
	mvi	a,00000011b	;
				;
setup6:	sta	head		;
	mov	a,c		;
	sta	track		;
	mov	a,b		;
	sta	sector		;
	ret			;


setmem:
				; setze dmaadresse
				;
	mvi	a,1		; einen sektor uebertragen
	sta	sectcnt		;
	lda	@dbnk		; lade obere 8 bit der phys. dmaadresse
	mov	e,a		;
	mvi	d,0		;
	lxi	h,ibtab		;
	dad	d		;
	mov	a,m		;
	rrc			;
	rrc			;
	rrc			;
	rrc			;
	mov	d,a		; rette in d
	ani	00fh		; in a stehen jetzt die oberen 4 bit
	sta	dmabank		; der phys. dma adresse
	mov	a,d		; 
	ani	0f0h		;
	lhld	@dma		; lese dma adresse
	add	h		; addiere bit 12 bis 15 dazu
	mov	h,a		;
	shld	dmaadr		; trage dmaadresse ein
	ret			;


roderw	ds	1



TEST$FORMAT:
	;TESTET DAS FORMAT DER DISK, DIE SICH IM VON
	;@RDRV SPEZIFIZIERTEN LAUFWERK BEFINDET UND VERGLEICHT
	;ES MIT DEN IN DTYPEL ERLAUBTEN FORMATEN.
	;IST DAS FORMAT NICHT ERKENNBAR, ODER IN DTYPEL
	;NICHT VEREINBART, SO KEHRT TEST$FORMAT MIT AKKU=0FFH
	;ZURUECK. KONNTE DAS FORMAT ERMITTELT WERDEN UND WAR ES AUCH IN
	;DTYPEL VEREINBART, DANN KEHRT TEST$FORMAT MIT AKKU GLEICH
	;NUMMER DES EINTRAGES ZURUECK. IX ZEIGT AUF ANFANG DES EINTRAGS.
	;
	;
ttrk	equ	2		;Auf dieser Spur wird das Format
				;getestet
	if	kdrive$switch	;
	call	chchg		;
	endif			;
	mvi	a,2		;Flag, fuer einmaliges Umschalten
	sta	auto$track$flag	;zwischen 40 und 80 Spuren
	lda	@rdrv		;SETZE DAS ZU TESTENDE LAUFWERK
	ani	03h		;maskiere die oberen 6 bits
	STA	UNIT		;
	MVI	A,ttrk		;TESTE FORMAT AUF DER ANGEGEBENEN SPUR
	STA	TEST$TRACK	;
testf8:	CALL	mtest		;
	ORA	A		;WAR TEST ERFOLGREICH ?
	JRZ	TESTF6		;SPRUNG WENN JA
TESTF2:	MVI	A,0FFH		;SONST RUECKSPRUNG MIT AKKU=0FFH
	RET			;
				;
testf6:				;Der Code bis zum Label testf7 dient
				;zur automatischen 40/80-Spurumschaltung
				;bei 80-Spur-Laufwerken.
				;
	lda	rest+3		;pruefe ob die richtige Spur im ID-Feld
	cpi	ttrk		;steht.
	jrz	testf7		;ja, alles ok => weiter
				;
	call	unit$mask	;Erzeuge Laufwerksmaske in c
	lda	seeknr		;
	mov	b,a		;rette SEEKNR in b
	rlc ! rlc ! rlc ! rlc	;Teste ob physikalisches 80-Spur-LW.
	xra	b		;(wenn double step und 80-Track-Bit
	ana	c		;fuer dieses Laufwerk unterschiedlich sind,
	ani	00fh		;wird ein phys.-80-Spur-LW. angenommen)
	jrz	testf2		;Fehler wenn kein 80-Spur-Laufwerk
				;
	mov	a,b		;lade SEEKNR nach a
	xra	c		;und inveriere die beiden fuer
	sta	seeknr		;dieses Laufwerk relevanten Bits
	lda	auto$track$flag	;pruefe ob automatische Umschaltung
	dcr	a		;bereits einmal erfolgte.
	jrz	testf2		;wenn ja, Fehler
	sta	auto$track$flag	;sonst teste nochmals mit anderer
	jr	testf8		;Spurimpulszahl
				;
testf7:				;OK, FORMAT DATEN STEHEN IN TEST$TYPE
				;TEST$LSEK UND TEST$TRACK.
	LXIX	DTYPEB		;IX ZEIGT AUF ERSTEN EINTRAG DER LISTE.
	LDA	TEST$TYPE	;TEST$TYPE
	MOV	D,A		;NACH D.
	LDA	TEST$MSEK	;LETZTER SEKTOR
	MOV	E,A		;NACH E.
	LDA	TEST$LSEK	;ERSTER SEKTOR
	MOV	H,A		;NACH H.
	LDA	@RDRV		;BERECHNE MASKE FUER UNIT.
	INR	A		;
	MOV	B,A		;
	MVI	A,00001000B	;
TESTF5:	RLC			;
	DJNZ	TESTF5		;
	MOV	L,A		;OK, MASKE IN L.
	MVI	B,0		;ZAEHLER FUER FORMATNUMMER AUF NULL.
TESTF4:	BITX	3,0		;ENDE DER LISTE WENN BIT 3 AUF 1.
	JRNZ	TESTF2		;WENN DIES DER FALL ZURUECK, NICHT ERKANNT.
	LDX	A,0		;VERGLEICHE TEST$TYPE.
	CMP	D		;
	JRNZ	NEXT$ENTRY	;SPRUNG WENN UNGLEICH.
	LDX	A,1		;VERGLEICHE TEST$LSEK.
	CMP	H		;
	JRNZ	NEXT$ENTRY	;SPRUNG WENN UNGLEICH.
	LDX	A,2		;VERGLEICHE TEST$MSEK.
	CMP	E		;
	JRNZ	NEXT$ENTRY	;SPRUNG WENN UNGLEICH.
	LDX	A,3		;IST DAS FORMAT AUCH AUF DIESEM
	ANA	L		;LAUFWERK GUELTIG ?
	JRZ	NEXT$ENTRY	;SPRUNG WENN NICHT GUELTIG.
				;
				;OK, DISK WURDE ERKANNT
	mov	a,b		;
	RET			;
				;
NEXT$ENTRY:			;SETZE IX AUF NAECHSTEN EINTRAG
				;DER DTYPEL, ERHOEHE B UM 1.
	push	b		;
	lxi	b,l$dtyl	;LAENGE DER DTYPEL
	dadx	b		;ZU IX ADDIEREN.
	pop	b		;
	inr	b		;ERHOEHE B UM EINS.
	jr	testf4		;


unit$mask:			;erzeuge aus UNIT-Wert
				;LW-Maske fuer SEEKNR
	lda	unit		;
	ani	00000011b	;
	mvi	c,11h		;
	rz			;
	mov	b,a		;
	mov	a,c		;
unimask	rlc			;
	djnz	unimask		;
	mov	c,a		;
	ret			;

current$dph	ds	2	;
auto$track$flag	ds	1	;

	end
