{ ========================================================================== }
{                                                                            }
{          Generator fuer Prommbare Files, fuer CONITEC Darmstadt            }
{          von Manfred Oheimer.                                              }
{                                                                            }
{          Modul zur Interpretation von Textfiles, die den Programmlauf      }
{          steuern, bzw. Parameter enthalten.                                }
{                                                                            }
{          Letzte Aenderung : 10.12.86 / 17.12.89 (Joachim)                  }
{                                                                            }
{ ========================================================================== }


function getcommandfile(fnam:string14):boolean;

var errcode,counter             : integer;
    firstword                   : zeile;
    hc                          : char;


procedure getfirstword ( inpline : zeile );
var i : integer;
begin
   firstword:='';
   i:=1;
   while (i<=LENGTH(inpline)) and (not (inpline[i] in [' ',';',chr(9)])) do
      begin
         firstword := firstword + UPCASE(inpline[i]);
         i:=i+1;
      end;
end;


function emptyline ( inpline : zeile ) : boolean;
begin
   if LENGTH ( inpline ) = 0 then emptyline := TRUE
      else
         begin
            getfirstword ( inpline );
            if LENGTH ( firstword ) = 0 then emptyline := TRUE
               else emptyline := FALSE;
         end;
end;



procedure setdata ( inpline : zeile ; zeiger : sourcefilepointer );
var  sfln : integer;
begin
   getfirstword ( inpline );
   zeiger^.filnam := firstword;
   sfln := LENGTH ( firstword );
   DELETE ( inpline , 1 , sfln );
   { alle fuehrenden Blanks in inpline loeschen }
   while (inpline [1] = ' ') or (inpline[1] = chr(9)) do DELETE (inpline , 1 , 1 );
   getfirstword ( inpline );
   with zeiger^ do begin  { sucht nach Parametern in Gross/Kleinschreibung }
      if POS ( 'S' , firstword ) <> 0 then sys := TRUE else
      if POS ( 's' , firstword ) <> 0 then sys := TRUE else sys := FALSE;
      if POS ( 'A' , firstword ) <> 0 then arch := TRUE else
      if POS ( 'a' , firstword ) <> 0 then arch := TRUE else arch := FALSE;
      if POS ( 'R' , firstword ) <> 0 then ro := TRUE else
      if POS ( 'r' , firstword ) <> 0 then ro := TRUE else ro := FALSE;
   end;
end;




begin
   ASSIGN(FileVar,fnam);
   {$I- }
   RESET(FileVar)
   {$I+ };
   if (IOresult=0) then
      begin
         getcommandfile:=TRUE; { Rueckmeldung ans Hauptprogramm }


   { **************  Endlicher Zustands-Automat ***************************** }


   counter := 0;                              { Zaehler fuer nicht leere Zeilen }
   repeat                         { Schleife liest zeilenweise den Steuerfile }
      readln( FileVar , BUFF );
      if not( emptyline( BUFF ) ) then      { Leerzeilen werden ausgeblendet }
        begin
          case counter of
          0 : begin                                  { Einlesen der EPROMSIZE }
                 getfirstword ( BUFF );
                 VAL ( firstword , EPROMSIZEINKBYTE , errcode );
                 if errcode <> 0 then begin FATALERROR := TRUE; EXIT; end;
              end;
          1 : begin                                               {  NREPROMS }
                 getfirstword ( BUFF );
                 VAL ( firstword , NREPROMS , errcode );
                 if errcode <> 0 then begin FATALERROR := TRUE; EXIT; end;
              end;
          2 : begin                                             { SOURCEDRIVE }
                 getfirstword ( BUFF );
                 hc := BUFF[1]; { Damit wird der LaufwerksBezeichner getestet }
                 if ($40 < ORD(UPCASE( hc )))and(ORD(UPCASE( hc )) <$51 )
                            then SOURCEDR := UPCASE( hc )
                            else begin FATALERROR := TRUE; EXIT; end;
              end;
          3 : begin                                               { DESTDRIVE }
                 getfirstword ( BUFF );
                 hc := BUFF[1];
                 if ($40 < ORD(UPCASE( hc )))and(ORD(UPCASE( hc )) <$51 )
                            then DESTDR := UPCASE ( hc )
                            else begin FATALERROR := TRUE; EXIT; end;
              end;
          4 : begin         { Anfang Dateinamen-Liste / NRDIRENTR + BLOCKSIZE }
                 getfirstword ( BUFF );
                 VAL ( firstword , BLKSIZEINKB , errcode );
                 NEW(sfpt);
                 sfroot:=sfpt;                  { Wurzel-der-Sourcefile-Kette }
                 sfpth:=sfpt;
                 if errcode <> 0 then begin
                               BLKSIZEINKB := 0;
                               setdata ( BUFF , sfpt );
                               NEW(sfpth);
                               sfpt^.next:=sfpth;
                               counter := 5;           { ueberspringe Zust. 5 }
                            end { end-of-no-blksize }
              end;
          5 : begin
                 getfirstword ( BUFF );
                 VAL ( firstword , NRDIRENTR , errcode );
                 if errcode <> 0 then begin
                                         FATALERROR := TRUE;
                                         EXIT;
                                      end { end-of-no-blksize }
              end;
          else                   { Ab hier koennen nur noch Dateinamen kommen }
               sfpt:=sfpth;
               setdata ( BUFF , sfpt );
               NEW(sfpth);
               sfpt^.next:=sfpth;
          end;
          counter := counter + 1; { counter nur erhoehen, wenn not(emptyline) }
       end;                                           { end-of-not(emptyline) }
   until (EOF( FileVar ) or FATALERROR);
   if EOF( FileVar ) then sfpt^.next := NIL;

{ ****************** Ende des Zustands-Automaten **************************** }

      end { end-of-IOresult=0 }
    else begin
           writeln('Der Steuerfile "GPF.CTR" ist nicht vorhanden !!! ');
           delay(1000);
           getcommandfile:=FALSE; { Rueckmeldung ans Hauptprogramm }
         end; { end-of-IOresult<>0 }
end; { end-of-getcommandfile }


