%name I2Z
%{
/************************************************************
8080 to Z80 Mnemonic Converter
(c) 89 by J.Sievers cplhh.Hanse.de
(c) 07 by J.Sievers nadhh.Hanse.de
(c) 08 by W.Kurtz www.prof80.de updated and improved:
	for upper case source only
(c) 09 by W.Kurtz www.prof80.de expanded

    Use I2Z 8080InputFile > Z80OutputFile

Finally, main is defined in the programs section since the
one in the library calls yyparse instead.
************************************************************/
#include <errno.h>
#include <string.h>
int wc = 0;
char buf[20],buf1[20],buf2[20];
%}

%start WORD

t       [ \t]+
z       [a-zA-z0-9]
nz      ($|[^a-zA-z0-9])
Label  	[a-zA-Z0-9+\$]+
Label1  [ \t]*[a-zA-Z0-9+\$]+
Label2  [ \t]+[a-zA-Z0-9+\$]+
Register    [ABCDEHLM(HL)]
Bit     [0-7]

%%
;[^\n]*\n			{ printf("%s",yytext);}   /* Kommentare */
\.[A-Za-z][^ \t]+	{ printf("%s",yytext);}   /* Pseudo-Ops */
{t}DB{t}.*			{ printf("\tDEF%s",strchr(yytext,'B'));} /* define bytes */
{t}DS{t}.*			{ printf("\tDEF%s",strchr(yytext,'S'));} /* define space */
{t}DW{t}.*			{ printf("\tDEF%s",strchr(yytext,'W'));} /* define words */
{t}SET{t}			{ printf("\tEQU\t");}    /* SET ist bei der Z80 ein Bit-Befehl */
,M{nz}				{ printf(",(HL)\t%c",yytext[yyleng-1]);} /* Speicherzugriff */
M,					{ printf("(HL),");}
{t}M{nz}			{ printf("\t(HL)%c",yytext[yyleng-1]);}

	  /*********************************/
	 /***       Z80.LIB Anfang      ***/
	/*********************************/

{t}LD[XY]{t}{Register},{Label1}     {													strcpy(buf, strtok(yytext," \t" ));
																						strcpy(buf1,strtok(NULL,  " \t "));
									printf("\tLD\t%s,(I%c+%s)",buf1,buf[2],							strtok(NULL,  " \t,"));		}
{t}ST[XY]{t}{Register},{Label1}		{													strcpy(buf, strtok(yytext," \t" ));
																						strcpy(buf1,strtok(NULL,  " \t "));
									printf("\tLD\t(I%c+%s),%s",buf[2],								strtok(NULL,  " \t,"),buf1);}
{t}(BIT|RES|SET)[XY]{t}{Label},{Label1}	{ 												strcpy(buf, strtok(yytext," \t" ));
																						strcpy(buf1,strtok(NULL,  " \t "));
									printf("\t%c%c%c\t%s,(I%c+%s)",buf[0],buf[1],buf[2],buf1,buf[3],strtok(NULL,  " \t,"));		}
{t}LXI[XY]{Label2} 				{ strcpy(buf,strtok(yytext," \t"));	printf("\tLD\tI%c,%s",			buf[3],						strtok(NULL," \t"))	;}
{t}L(BC|DE|SP|IX|IY)D{t}{Label}	{ strcpy(buf,strtok(yytext," \t"));	printf("\tLD\t%c%c,(%s)",		buf[1],buf[2],				strtok(NULL," \t"))	;}
{t}S(BC|DE|SP|IX|IY)D{t}{Label}	{ strcpy(buf,strtok(yytext," \t"));	printf("\tLD\t(%s),%c%c",		strtok(NULL," \t"),			buf[1],buf[2])		;}
{t}S(UB|BC)[XY]{Label1}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tS%c%c\tA,(I%c+%s)",	buf[1],buf[2],buf[3],		strtok(NULL," \t"))	;}
{t}MVI[XY]{t}{Label},{Label}	{ strcpy(buf,strtok(yytext," \t"));	printf("\tLD\t(I%c+%s),%s",		buf[3],strtok(NULL," ,"),	strtok(NULL," ," ))	;}
{t}RA[LR][XY]{t}{Label}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tR%c\t(I%c+%s)",		buf[2],buf[3],				strtok(NULL," \t"))	;}
{t}R[LR]C[XY]{t}{Label}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tR%cC\t(I%c+%s)",		buf[1],buf[3],				strtok(NULL," \t"))	;}
{t}S[LR][AL][XY]{t}{Label}		{ strcpy(buf,strtok(yytext," \t"));	printf("\tS%c%c\t(I%c+%s)",		buf[1],buf[2],buf[3],		strtok(NULL," \t"))	;}
{t}AD[CD][XY]{t}{Label}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tAD%c\tA,(I%c+%s)",	buf[2],buf[3],				strtok(NULL," \t"))	;}
{t}AND[XY]{t}{Label}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tAND\t(I%c+%s)",		buf[3],						strtok(NULL," \t"))	;}
{t}OR[XY]{t}{Label}				{ strcpy(buf,strtok(yytext," \t"));	printf("\tOR\t(I%c+%s)",		buf[2],						strtok(NULL," \t"))	;}
{t}XOR[XY]{t}{Label}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tXOR\t(I%c+%s)",		buf[3],						strtok(NULL," \t"))	;}
{t}CMP[XY]{t}{Label}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tCP\t(I%c+%s)",		buf[3],						strtok(NULL," \t"))	;}
{t}INR[XY]{t}{Label}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tINC\t(I%c+%s)",		buf[3],						strtok(NULL," \t"))	;}
{t}DCR[XY]{t}{Label}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tDEC\t(I%c+%s)",		buf[3],						strtok(NULL," \t"))	;}
{t}SPI[XY]						{ strcpy(buf,strtok(yytext," \t"));	printf("\tLD\tSP,I%c",			buf[3])											;}
{t}XTI[XY]						{ strcpy(buf,strtok(yytext," \t"));	printf("\tEX\t(SP),I%c",		buf[3])											;}
{t}INXI[XY]						{ strcpy(buf,strtok(yytext," \t"));	printf("\tINC\tI%c",			buf[4])											;}
{t}DCXI[XY]						{ strcpy(buf,strtok(yytext," \t"));	printf("\tDEC\tI%c",			buf[4])											;}
{t}PCI[XY]						{ strcpy(buf,strtok(yytext," \t"));	printf("\tJP\t(I%c)",			buf[3])											;}
{t}POPI[XY]						{ strcpy(buf,strtok(yytext," \t"));	printf("\tPOP\tI%c",			buf[4])											;}
{t}PUSHI[XY]					{ strcpy(buf,strtok(yytext," \t"));	printf("\tPUSH\tI%c",			buf[5])											;}
{t}RA[LR]R						{ strcpy(buf,strtok(yytext," \t"));	printf("\tR%c",					buf[2])											;}
{t}R[LR]CR						{ strcpy(buf,strtok(yytext," \t"));	printf("\tR%cC",				buf[1])											;}
{t}S[LR][AL]R					{ strcpy(buf,strtok(yytext," \t"));	printf("\tS%c%c",				buf[1],buf[2])									;}
{t}INP{t}{Register}				{ strcpy(buf,strtok(yytext," \t"));	printf("\tIN\t%s,(C)",			strtok(NULL," \t"))								;}
{t}OUTP{t}{Register}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tOUT\t(C),%s",			strtok(NULL," \t"))								;}
{t}DAD[XY]{t}{Label}			{ strcpy(buf,strtok(yytext," \t"));	printf("\tADD\tI%c,%s",			buf[3],						strtok(NULL," \t"))	;}
{t}DADC{t}{Label}				{ strcpy(buf,strtok(yytext," \t"));	printf("\tADC\tHL,%s",			strtok(NULL," \t"))								;}
{t}DSBC{t}{Label}				{ strcpy(buf,strtok(yytext," \t"));	printf("\tSBC\tHL,%s",			strtok(NULL," \t"))								;}
{t}SETB							{ 									printf("\tSET")								;}
{t}LDAI							{ printf("\tLD\tA,I");}
{t}LDAR							{ printf("\tLD\tA,R");}
{t}EXAF							{ printf("\tEX\tAF,AF'");}
{t}EXX							{ printf("\tEXX");}
{t}IM0							{ printf("\tIM\t0");}
{t}IM1							{ printf("\tIM\t1");}
{t}IM2							{ printf("\tIM\t2");}
{t}STAI							{ printf("\tLD\tI,A");}
{t}STAR							{ printf("\tLD\tR,A");}
{t}NEG							{ printf("\tNEG");}
{t}RLD							{ printf("\tRLD");}
{t}RRD							{ printf("\tRRD");}
{t}CCI							{ printf("\tCPI");}
{t}CCIR							{ printf("\tCPIR");}
{t}CCD							{ printf("\tCPD");}
{t}CCDR							{ printf("\tCPDR");}
{t}JR{t}{Label}					{ strtok(yytext," \t,"); 			printf("\tJR\t%s",   	strtok(NULL," \t,"));}
{t}JRNZ{t}{Label}				{ strtok(yytext," \t,"); 			printf("\tJR\tNZ,%s",	strtok(NULL," \t,"));}
{t}JRZ{t}{Label}				{ strtok(yytext," \t,"); 			printf("\tJR\tZ,%s",	strtok(NULL," \t,"));}
{t}JRNC{t}{Label}				{ strtok(yytext," \t,"); 			printf("\tJR\tNC,%s",	strtok(NULL," \t,"));}
{t}JRC{t}{Label}				{ strtok(yytext," \t,"); 			printf("\tJR\tC,%s",	strtok(NULL," \t,"));}
{t}DJNZ{t}{Label}				{ strtok(yytext," \t,"); 			printf("\tDJNZ\t%s",	strtok(NULL," \t,"));}
{t}RETI							{ printf("\tRETI");}
{t}RETN							{ printf("\tRETN");}
{t}INI							{ printf("\tINI");}
{t}INIR							{ printf("\tINIR");}
{t}IND							{ printf("\tIND");}
{t}INDR							{ printf("\tINDR");}
{t}OUTI							{ printf("\tOUTI");}
{t}OTIR							{ printf("\tOTIR");}
{t}OUTD							{ printf("\tOUTD");}
{t}OTDR							{ printf("\tOTDR");}
{t}LDI							{ printf("\tLDI");}
{t}LDIR							{ printf("\tLDIR");}
{t}LDD							{ printf("\tLDD");}
{t}LDDR							{ printf("\tLDDR");}

	  /*********************************/
	 /***       8080 - Befehle      ***/
	/*********************************/

{t}CALL{t}			{ printf("\tCALL\t");}
{t}CNZ{t}			{ printf("\tCALL\tNZ,");}
{t}CZ{t}			{ printf("\tCALL\tZ,");}
{t}CNC{t}			{ printf("\tCALL\tNC,");}
{t}CC{t}			{ printf("\tCALL\tC,");}
{t}CPO{t}			{ printf("\tCALL\tPO,");}
{t}CPE{t}			{ printf("\tCALL\tPE,");}
{t}CP{t}			{ printf("\tCALL\tP,");}
{t}CM{t}			{ printf("\tCALL\tM,");}
{t}LDAX{t}[BD]		{ printf("\tLD\tA,(%c%c)",yytext[yyleng-1], *(char*)(strchr("BCDE",yytext[yyleng-1])+1));}
{t}STAX{t}[BD]		{ printf("\tLD\t(%c%c),A",yytext[yyleng-1], *(char*)(strchr("BCDE",yytext[yyleng-1])+1));}
{t}INX{t}[BDHS]P?	{ if(yytext[yyleng-1]=='P') yyleng--; printf("\tINC\t%c%c",yytext[yyleng-1], *(char*)(strchr("BCDEHLSP",yytext[yyleng-1])+1));}
{t}DCX{t}[BDHS]P?	{ if(yytext[yyleng-1]=='P') yyleng--; printf("\tDEC\t%c%c",yytext[yyleng-1], *(char*)(strchr("BCDEHLSP",yytext[yyleng-1])+1));}
{t}DAD{t}[BDHS]P?	{ if(yytext[yyleng-1]=='P') yyleng--; printf("\tADD\tHL,%c%c",yytext[yyleng-1], *(char*)(strchr("BCDEHLSP",yytext[yyleng-1])+1));}
{t}PUSH{t}[BDH]		{ printf("\tPUSH\t%c%c",yytext[yyleng-1], *(char*)(strchr("BCDEHL",yytext[yyleng-1])+1));}
{t}POP{t}[BDH]		{ printf("\tPOP\t%c%c",yytext[yyleng-1], *(char*)(strchr("BCDEHL",yytext[yyleng-1])+1));}
{t}LXI{t}[BDH]		{ printf("\tLD\t%c%c",yytext[yyleng-1], *(char*)(strchr("BCDEHL",yytext[yyleng-1])+1));}
{t}LXI{t}			{ printf("\tLD\t");}
{t}LDA{t}{Label}	{ strtok(yytext," \t"); printf("\tLD\tA,(%s)",strtok(NULL," \t"));}
{t}STA{t}{Label}	{ strtok(yytext," \t"); printf("\tLD\t(%s),A",strtok(NULL," \t"));}
{t}LHLD{t}{Label}	{ strtok(yytext," \t"); printf("\tLD\tHL,(%s)",strtok(NULL," \t"));}
{t}SHLD{t}{Label}	{ strtok(yytext," \t"); printf("\tLD\t(%s),HL",strtok(NULL," \t"));}
{t}IN{t}{Label}		{ strtok(yytext," \t"); printf("\tIN\tA,(%s)",strtok(NULL," \t"));}
{t}OUT{t}{Label}	{ strtok(yytext," \t"); printf("\tOUT\t(%s),A",strtok(NULL," \t"));}
{t}MOV{t}M			{ printf("\tLD\t(HL)");}
{t}MOV{t}			{ printf("\tLD\t");}
{t}MVI{t}			{ printf("\tLD\t");}
{t}JMP{t}			{ printf("\tJP\t");}
{t}XCHG				{ printf("\tEX\tDE,HL");}
{t}XTHL				{ printf("\tEX\t(SP),HL");}
{t}SPHL				{ printf("\tLD\tSP,HL");}
{t}PCHL				{ printf("\tJP\t(HL)");}
{t}HLT				{ printf("\tHALT");}
{t}SUB{t}M			{ printf("\tSUB\t(HL)");}
{t}SUI{t}			{ printf("\tSUB\t");}
{t}SBB{t}M			{ printf("\tSBC\t(HL)");}
{t}SBB{t}			{ printf("\tSBC\t");}
{t}SBI{t}			{ printf("\tSBC\t");}
{t}ADI{t}			{ printf("\tADD\tA,");}
{t}ACI{t}			{ printf("\tADC\tA,");}
{t}ADD{t}M			{ printf("\tADD\tA,(HL)");}
{t}ADD{t}			{ printf("\tADD\tA,");}
{t}ADC{t}M			{ printf("\tADC\tA,(HL)");}
{t}ADC{t}			{ printf("\tADC\tA,");}
{t}INR{t}M			{ printf("\tINC\t(HL)");}
{t}INR{t}			{ printf("\tINC\t");}
{t}DCR{t}M			{ printf("\tDEC\t(HL)");}
{t}DCR{t}			{ printf("\tDEC\t");}
{t}CMA				{ printf("\tCPL");}
{t}STC				{ printf("\tSCF");}
{t}CMC				{ printf("\tCCF");}
{t}RLC{nz}			{ printf("\tRLCA%c",yytext[yyleng-1]);}
{t}RRC{nz}			{ printf("\tRRCA%c",yytext[yyleng-1]);}
{t}RAL{nz}			{ printf("\tRLA%c",yytext[yyleng-1]);}
{t}RAR{nz}			{ printf("\tRRA%c",yytext[yyleng-1]);}
{t}RNZ				{ printf("\tRET\tNZ");}
{t}RZ				{ printf("\tRET\tZ");}
{t}RNC				{ printf("\tRET\tNC");}
{t}RC				{ printf("\tRET\tC");}
{t}RPO				{ printf("\tRET\tPO");}
{t}RPE				{ printf("\tRET\tPE");}
{t}RP				{ printf("\tRET\tP");}
{t}RM				{ printf("\tRET\tM");}
{t}RST{t}[0-7]		{ printf("\tRST\t%XH",((int)yytext[yyleng-1]-(int)'0')*8);}
{t}PSW				{ printf("\tAF");}
{t}ANA{t}M			{ printf("\tAND\t(HL)");}
{t}ANA{t}			{ printf("\tAND\t");}
{t}ANI{t}			{ printf("\tAND\t");}
{t}XRA{t}M			{ printf("\tXOR\t(HL)");}
{t}XRA{t}			{ printf("\tXOR\t");}
{t}XRI{t}			{ printf("\tXOR\t");}
{t}ORA{t}M			{ printf("\tOR\t(HL)");}
{t}ORA{t}			{ printf("\tOR\t");}
{t}ORI{t}			{ printf("\tOR\t");}
{t}CMP{t}M			{ printf("\tCP\t(HL)");}
{t}CMP{t}			{ printf("\tCP\t");}
{t}CPI{t}			{ printf("\tCP\t");}
{t}JNZ{t}			{ printf("\tJP\tNZ,");}
{t}JZ{t}			{ printf("\tJP\tZ,");}
{t}JNC{t}			{ printf("\tJP\tNC,");}
{t}JC{t}			{ printf("\tJP\tC,");}
{t}JPO{t}			{ printf("\tJP\tPO,");}
{t}JPE{t}			{ printf("\tJP\tPE,");}
{t}JP{t}			{ printf("\tJP\tP,");}
{t}JM{t}			{ printf("\tJP\tM,");}
^[A-Za-z][^ \t]+				{ printf("%s",yytext);}
.|\n							{ putchar(*yytext);}

%%



int main(int argc, char** argv)
{
	int res;

	yyin = fopen(argv[1], "r");
	if (yyin != NULL)
	{
		res= yylex();
	}
	else
	{
		res = errno;
		perror("Input");
		printf("\n\n");
		printf("**********************************\n");
		printf("*                                *\n");
		printf("*         INTEL to ZILOG         *\n");
		printf("*      Sourcecode-Translator     *\n");
		printf("*   (versteht 8080 und Z80.LIB)  *\n");
		printf("*                                *\n");
		printf("*       V1.0 vom 11.07.2009      *\n");
		printf("*                                *\n");
		printf("*  Aufruf: \"I2Z infile>outfile\"  *\n");
		printf("*                                *\n");
		printf("**********************************\n");
	}
	return res;
}
