%name UPPER
%{
/************************************************************
convert assembler source files to upper case (without comments)
(c) 08 by W.Kurtz www.prof80.de updated and improved:
User UPPER InputFile > OutputFile
************************************************************/
#include <errno.h>
#include <string.h>
%}

%%
;[^\n]*\n	{ printf("%s",yytext); }       /* Kommentare unverndert bernehmen */
[a-z]   { printf("%c",yytext[0]-97+65 ); } /* Klein- in Grobuchstaben umsetzen */
%%
int main(int argc, char** argv)
{
	int res;

	yyin = fopen(argv[1], "r");
	if (yyin != NULL)
	res= yylex();
	else
	{
		res = errno;
		perror("Input");
		printf("\n\n");
		printf("************************************\n");
		printf("*                                  *\n");
		printf("*             U P P E R            *\n");
		printf("*          setzt Klein- in         *\n");
		printf("*        Grossbuchstaben um        *\n");
		printf("*                                  *\n");
		printf("*  Aufruf: \"UPPER infile>outfile\"  *\n");
		printf("*                                  *\n");
		printf("************************************\n");
	}
	return res;
}
